/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.Category;
import org.prebid.server.settings.model.StoredDataResult;
import org.prebid.server.settings.model.StoredDataType;
import org.prebid.server.settings.model.StoredResponseDataResult;
import org.prebid.server.settings.proto.response.HttpAccountsResponse;
import org.prebid.server.settings.proto.response.HttpFetcherResponse;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpApplicationSettings
implements ApplicationSettings {
    private static final Logger logger = LoggerFactory.getLogger(HttpApplicationSettings.class);
    private static final TypeReference<Map<String, Category>> CATEGORY_RESPONSE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpoint;
    private final String ampEndpoint;
    private final String videoEndpoint;
    private final String categoryEndpoint;
    private final HttpClient httpClient;
    private final JacksonMapper mapper;

    public HttpApplicationSettings(HttpClient httpClient, JacksonMapper mapper, String endpoint, String ampEndpoint, String videoEndpoint, String categoryEndpoint) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.mapper = Objects.requireNonNull(mapper);
        this.endpoint = HttpUtil.validateUrl((String)Objects.requireNonNull(endpoint));
        this.ampEndpoint = HttpUtil.validateUrl((String)Objects.requireNonNull(ampEndpoint));
        this.videoEndpoint = HttpUtil.validateUrl((String)Objects.requireNonNull(videoEndpoint));
        this.categoryEndpoint = HttpUtil.validateUrl((String)Objects.requireNonNull(categoryEndpoint));
    }

    public Future<Account> getAccountById(String accountId, Timeout timeout) {
        return this.fetchAccountsByIds(Collections.singleton(accountId), timeout).map(accounts -> (Account)accounts.stream().findFirst().orElseThrow(() -> new PreBidException("Account with id : %s not found".formatted(accountId))));
    }

    private Future<Set<Account>> fetchAccountsByIds(Set<String> accountIds, Timeout timeout) {
        if (CollectionUtils.isEmpty(accountIds)) {
            return Future.succeededFuture(Collections.emptySet());
        }
        long remainingTimeout = timeout.remaining();
        if (timeout.remaining() <= 0L) {
            return Future.failedFuture((Throwable)new TimeoutException("Timeout has been exceeded"));
        }
        return this.httpClient.get(HttpApplicationSettings.accountsRequestUrlFrom((String)this.endpoint, accountIds), HttpUtil.headers(), remainingTimeout).compose(response -> this.processAccountsResponse(response, accountIds)).recover(Future::failedFuture);
    }

    private static String accountsRequestUrlFrom(String endpoint, Set<String> accountIds) {
        StringBuilder url = new StringBuilder(endpoint);
        url.append(endpoint.contains("?") ? "&" : "?");
        if (!accountIds.isEmpty()) {
            url.append("account-ids=[\"").append(HttpApplicationSettings.joinIds(accountIds)).append("\"]");
        }
        return url.toString();
    }

    private Future<Set<Account>> processAccountsResponse(HttpClientResponse response, Set<String> accountIds) {
        return Future.succeededFuture((Object)this.toAccountsResult(response.getStatusCode(), response.getBody(), accountIds));
    }

    private Set<Account> toAccountsResult(int statusCode, String body, Set<String> accountIds) {
        HttpAccountsResponse response;
        if (statusCode != HttpResponseStatus.OK.code()) {
            throw new PreBidException("Error fetching accounts %s via http: unexpected response status %d".formatted(accountIds, statusCode));
        }
        try {
            response = (HttpAccountsResponse)this.mapper.decodeValue(body, HttpAccountsResponse.class);
        }
        catch (DecodeException e) {
            throw new PreBidException("Error fetching accounts %s via http: failed to parse response: %s".formatted(accountIds, e.getMessage()));
        }
        Map accounts = response.getAccounts();
        return MapUtils.isNotEmpty((Map)accounts) ? new HashSet(accounts.values()) : Collections.emptySet();
    }

    public Future<StoredDataResult> getStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return this.fetchStoredData(this.endpoint, requestIds, impIds, timeout);
    }

    public Future<StoredDataResult> getAmpStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return this.fetchStoredData(this.ampEndpoint, requestIds, Collections.emptySet(), timeout);
    }

    public Future<StoredDataResult> getVideoStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return this.fetchStoredData(this.videoEndpoint, requestIds, impIds, timeout);
    }

    public Future<StoredResponseDataResult> getStoredResponses(Set<String> responseIds, Timeout timeout) {
        return Future.failedFuture((Throwable)new PreBidException("Not supported"));
    }

    public Future<Map<String, String>> getCategories(String primaryAdServer, String publisher, Timeout timeout) {
        String url = StringUtils.isNotEmpty((CharSequence)publisher) ? "%s/%s/%s.json".formatted(this.categoryEndpoint, primaryAdServer, publisher) : "%s/%s.json".formatted(this.categoryEndpoint, primaryAdServer);
        long remainingTimeout = timeout.remaining();
        if (remainingTimeout <= 0L) {
            return Future.failedFuture((Throwable)new TimeoutException("Failed to fetch categories from url '%s'. Reason: Timeout exceeded".formatted(url)));
        }
        return this.httpClient.get(url, remainingTimeout).map(httpClientResponse -> this.processCategoryResponse(httpClientResponse, url));
    }

    private Map<String, String> processCategoryResponse(HttpClientResponse httpClientResponse, String url) {
        Map categories;
        int statusCode = httpClientResponse.getStatusCode();
        if (statusCode != 200) {
            throw this.makeFailedCategoryFetchException(url, "Response status code is '%d'".formatted(statusCode));
        }
        String body = httpClientResponse.getBody();
        if (StringUtils.isEmpty((CharSequence)body)) {
            throw this.makeFailedCategoryFetchException(url, "Response body is null or empty");
        }
        try {
            categories = (Map)this.mapper.decodeValue(body, CATEGORY_RESPONSE_REFERENCE);
        }
        catch (DecodeException e) {
            throw this.makeFailedCategoryFetchException(url, "Failed to decode response body with error " + e.getMessage());
        }
        return categories.entrySet().stream().filter(catToCategory -> catToCategory.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, catToCategory -> ((Category)catToCategory.getValue()).getId()));
    }

    private PreBidException makeFailedCategoryFetchException(String url, String reason) {
        return new PreBidException("Failed to fetch categories from url '%s'. Reason: %s".formatted(url, reason));
    }

    private Future<StoredDataResult> fetchStoredData(String endpoint, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        if (CollectionUtils.isEmpty(requestIds) && CollectionUtils.isEmpty(impIds)) {
            return Future.succeededFuture((Object)StoredDataResult.of(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList()));
        }
        long remainingTimeout = timeout.remaining();
        if (remainingTimeout <= 0L) {
            return HttpApplicationSettings.failStoredDataResponse((Throwable)new TimeoutException("Timeout has been exceeded"), requestIds, impIds);
        }
        return this.httpClient.get(HttpApplicationSettings.storeRequestUrlFrom((String)endpoint, requestIds, impIds), HttpUtil.headers(), remainingTimeout).compose(response -> this.processStoredDataResponse(response, requestIds, impIds)).recover(exception -> HttpApplicationSettings.failStoredDataResponse((Throwable)exception, (Set)requestIds, (Set)impIds));
    }

    private static String storeRequestUrlFrom(String endpoint, Set<String> requestIds, Set<String> impIds) {
        StringBuilder url = new StringBuilder(endpoint);
        url.append(endpoint.contains("?") ? "&" : "?");
        if (!requestIds.isEmpty()) {
            url.append("request-ids=[\"").append(HttpApplicationSettings.joinIds(requestIds)).append("\"]");
        }
        if (!impIds.isEmpty()) {
            if (!requestIds.isEmpty()) {
                url.append("&");
            }
            url.append("imp-ids=[\"").append(HttpApplicationSettings.joinIds(impIds)).append("\"]");
        }
        return url.toString();
    }

    private static String joinIds(Set<String> ids) {
        return String.join((CharSequence)"\",\"", ids);
    }

    private static Future<StoredDataResult> failStoredDataResponse(Throwable throwable, Set<String> requestIds, Set<String> impIds) {
        return Future.succeededFuture((Object)HttpApplicationSettings.toFailedStoredDataResult(requestIds, impIds, (String)throwable.getMessage(), (Object[])new Object[0]));
    }

    private Future<StoredDataResult> processStoredDataResponse(HttpClientResponse response, Set<String> requestIds, Set<String> impIds) {
        return Future.succeededFuture((Object)this.toStoredDataResult(requestIds, impIds, response.getStatusCode(), response.getBody()));
    }

    private static StoredDataResult toFailedStoredDataResult(Set<String> requestIds, Set<String> impIds, String errorMessageFormat, Object ... args) {
        Object errorRequests = requestIds.isEmpty() ? "" : "stored requests for ids " + requestIds;
        String separator = requestIds.isEmpty() || impIds.isEmpty() ? "" : " and ";
        Object errorImps = impIds.isEmpty() ? "" : "stored imps for ids " + impIds;
        String error = "Error fetching %s%s%s via HTTP: %s".formatted(errorRequests, separator, errorImps, errorMessageFormat.formatted(args));
        logger.info((Object)error);
        return StoredDataResult.of(Collections.emptyMap(), Collections.emptyMap(), Collections.singletonList(error));
    }

    private StoredDataResult toStoredDataResult(Set<String> requestIds, Set<String> impIds, int statusCode, String body) {
        HttpFetcherResponse response;
        if (statusCode != HttpResponseStatus.OK.code()) {
            return HttpApplicationSettings.toFailedStoredDataResult(requestIds, impIds, (String)"HTTP status code %d", (Object[])new Object[]{statusCode});
        }
        try {
            response = (HttpFetcherResponse)this.mapper.decodeValue(body, HttpFetcherResponse.class);
        }
        catch (DecodeException e) {
            return HttpApplicationSettings.toFailedStoredDataResult(requestIds, impIds, (String)"parsing json failed for response: %s with message: %s", (Object[])new Object[]{body, e.getMessage()});
        }
        return this.parseResponse(requestIds, impIds, response);
    }

    private StoredDataResult parseResponse(Set<String> requestIds, Set<String> impIds, HttpFetcherResponse response) {
        ArrayList errors = new ArrayList();
        Map storedIdToRequest = this.parseStoredDataOrAddError(requestIds, response.getRequests(), StoredDataType.request, errors);
        Map storedIdToImp = this.parseStoredDataOrAddError(impIds, response.getImps(), StoredDataType.imp, errors);
        return StoredDataResult.of((Map)storedIdToRequest, (Map)storedIdToImp, errors);
    }

    private Map<String, String> parseStoredDataOrAddError(Set<String> ids, Map<String, ObjectNode> storedData, StoredDataType type, List<String> errors) {
        HashMap<String, String> result = new HashMap<String, String>(ids.size());
        HashSet<String> notParsedIds = new HashSet<String>();
        if (storedData != null) {
            for (Map.Entry<String, ObjectNode> entry : storedData.entrySet()) {
                String jsonAsString;
                String id2 = entry.getKey();
                try {
                    jsonAsString = this.mapper.mapper().writeValueAsString((Object)entry.getValue());
                }
                catch (JsonProcessingException e) {
                    errors.add("Error parsing %s json for id: %s with message: %s".formatted(type, id2, e.getMessage()));
                    notParsedIds.add(id2);
                    continue;
                }
                result.put(id2, jsonAsString);
            }
        }
        if (result.size() < ids.size()) {
            HashSet<String> missedIds = new HashSet<String>(ids);
            missedIds.removeAll(result.keySet());
            missedIds.removeAll(notParsedIds);
            errors.addAll(missedIds.stream().map(id -> "Stored %s not found for id: %s".formatted(type, id)).toList());
        }
        return result;
    }
}

