/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.settings;

import io.vertx.core.Future;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.Timeout;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.settings.ApplicationSettings;
import org.prebid.server.settings.SettingsCache;
import org.prebid.server.settings.helper.StoredDataFetcher;
import org.prebid.server.settings.helper.StoredItemResolver;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.StoredDataResult;
import org.prebid.server.settings.model.StoredItem;
import org.prebid.server.settings.model.StoredResponseDataResult;

/*
 * Exception performing whole class analysis ignored.
 */
public class CachingApplicationSettings
implements ApplicationSettings {
    private static final Logger logger = LoggerFactory.getLogger(CachingApplicationSettings.class);
    private final ApplicationSettings delegate;
    private final Map<String, Account> accountCache;
    private final Map<String, String> accountToErrorCache;
    private final Map<String, String> adServerPublisherToErrorCache;
    private final Map<String, Map<String, String>> categoryConfigCache;
    private final SettingsCache cache;
    private final SettingsCache ampCache;
    private final SettingsCache videoCache;
    private final Metrics metrics;

    public CachingApplicationSettings(ApplicationSettings delegate, SettingsCache cache, SettingsCache ampCache, SettingsCache videoCache, Metrics metrics, int ttl, int size) {
        if (ttl <= 0 || size <= 0) {
            throw new IllegalArgumentException("ttl and size must be positive");
        }
        this.delegate = Objects.requireNonNull(delegate);
        this.accountCache = SettingsCache.createCache((int)ttl, (int)size);
        this.accountToErrorCache = SettingsCache.createCache((int)ttl, (int)size);
        this.adServerPublisherToErrorCache = SettingsCache.createCache((int)ttl, (int)size);
        this.categoryConfigCache = SettingsCache.createCache((int)ttl, (int)size);
        this.cache = Objects.requireNonNull(cache);
        this.ampCache = Objects.requireNonNull(ampCache);
        this.videoCache = Objects.requireNonNull(videoCache);
        this.metrics = Objects.requireNonNull(metrics);
    }

    public Future<Account> getAccountById(String accountId, Timeout timeout) {
        return CachingApplicationSettings.getFromCacheOrDelegate((Map)this.accountCache, (Map)this.accountToErrorCache, (String)accountId, (Timeout)timeout, (arg_0, arg_1) -> ((ApplicationSettings)this.delegate).getAccountById(arg_0, arg_1), (T event) -> this.metrics.updateSettingsCacheEventMetric(MetricName.account, event));
    }

    public Future<StoredDataResult> getStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return CachingApplicationSettings.getFromCacheOrDelegate((SettingsCache)this.cache, (String)accountId, requestIds, impIds, (Timeout)timeout, (arg_0, arg_1, arg_2, arg_3) -> ((ApplicationSettings)this.delegate).getStoredData(arg_0, arg_1, arg_2, arg_3));
    }

    public Future<StoredDataResult> getAmpStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return CachingApplicationSettings.getFromCacheOrDelegate((SettingsCache)this.ampCache, (String)accountId, requestIds, impIds, (Timeout)timeout, (arg_0, arg_1, arg_2, arg_3) -> ((ApplicationSettings)this.delegate).getAmpStoredData(arg_0, arg_1, arg_2, arg_3));
    }

    public Future<StoredDataResult> getVideoStoredData(String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout) {
        return CachingApplicationSettings.getFromCacheOrDelegate((SettingsCache)this.videoCache, (String)accountId, requestIds, impIds, (Timeout)timeout, (arg_0, arg_1, arg_2, arg_3) -> ((ApplicationSettings)this.delegate).getVideoStoredData(arg_0, arg_1, arg_2, arg_3));
    }

    public Future<StoredResponseDataResult> getStoredResponses(Set<String> responseIds, Timeout timeout) {
        return this.delegate.getStoredResponses(responseIds, timeout);
    }

    public Future<Map<String, String>> getCategories(String primaryAdServer, String publisher, Timeout timeout) {
        String compoundKey = StringUtils.isNotBlank((CharSequence)publisher) ? "%s_%s".formatted(primaryAdServer, publisher) : primaryAdServer;
        return CachingApplicationSettings.getFromCacheOrDelegate((Map)this.categoryConfigCache, (Map)this.adServerPublisherToErrorCache, (String)compoundKey, (Timeout)timeout, (T key, U timeoutParam) -> this.delegate.getCategories(primaryAdServer, publisher, timeout), CachingApplicationSettings::noOp);
    }

    private static <T> Future<T> getFromCacheOrDelegate(Map<String, T> cache, Map<String, String> accountToErrorCache, String key, Timeout timeout, BiFunction<String, Timeout, Future<T>> retriever, Consumer<MetricName> metricUpdater) {
        T cachedValue = cache.get(key);
        if (cachedValue != null) {
            metricUpdater.accept(MetricName.hit);
            return Future.succeededFuture(cachedValue);
        }
        metricUpdater.accept(MetricName.miss);
        String preBidExceptionMessage = accountToErrorCache.get(key);
        if (preBidExceptionMessage != null) {
            return Future.failedFuture((Throwable)new PreBidException(preBidExceptionMessage));
        }
        return retriever.apply(key, timeout).map(value -> {
            cache.put(key, value);
            return value;
        }).recover(throwable -> CachingApplicationSettings.cacheAndReturnFailedFuture((Throwable)throwable, (String)key, (Map)accountToErrorCache));
    }

    private static Future<StoredDataResult> getFromCacheOrDelegate(SettingsCache cache, String accountId, Set<String> requestIds, Set<String> impIds, Timeout timeout, StoredDataFetcher<String, Set<String>, Set<String>, Timeout, Future<StoredDataResult>> retriever) {
        String normalizedAccountId = StringUtils.stripToNull((String)accountId);
        Map requestCache = cache.getRequestCache();
        Map impCache = cache.getImpCache();
        HashSet missedRequestIds = new HashSet();
        Map storedIdToRequest = CachingApplicationSettings.getFromCacheOrAddMissedIds((String)normalizedAccountId, requestIds, (Map)requestCache, missedRequestIds);
        HashSet missedImpIds = new HashSet();
        Map storedIdToImp = CachingApplicationSettings.getFromCacheOrAddMissedIds((String)normalizedAccountId, impIds, (Map)impCache, missedImpIds);
        if (missedRequestIds.isEmpty() && missedImpIds.isEmpty()) {
            return Future.succeededFuture((Object)StoredDataResult.of((Map)storedIdToRequest, (Map)storedIdToImp, Collections.emptyList()));
        }
        return ((Future)retriever.apply((Object)normalizedAccountId, missedRequestIds, missedImpIds, (Object)timeout)).map(result -> {
            Map storedIdToRequestFromDelegate = result.getStoredIdToRequest();
            storedIdToRequest.putAll(storedIdToRequestFromDelegate);
            for (Map.Entry entry : storedIdToRequestFromDelegate.entrySet()) {
                cache.saveRequestCache(normalizedAccountId, (String)entry.getKey(), (String)entry.getValue());
            }
            Map storedIdToImpFromDelegate = result.getStoredIdToImp();
            storedIdToImp.putAll(storedIdToImpFromDelegate);
            for (Map.Entry entry : storedIdToImpFromDelegate.entrySet()) {
                cache.saveImpCache(normalizedAccountId, (String)entry.getKey(), (String)entry.getValue());
            }
            return StoredDataResult.of((Map)storedIdToRequest, (Map)storedIdToImp, (List)result.getErrors());
        });
    }

    private static <T> Future<T> cacheAndReturnFailedFuture(Throwable throwable, String key, Map<String, String> cache) {
        if (throwable instanceof PreBidException) {
            cache.put(key, throwable.getMessage());
        }
        return Future.failedFuture((Throwable)throwable);
    }

    private static Map<String, String> getFromCacheOrAddMissedIds(String accountId, Set<String> ids, Map<String, Set<StoredItem>> cache, Set<String> missedIds) {
        HashMap<String, String> idToStoredItem = new HashMap<String, String>(ids.size());
        for (String id : ids) {
            try {
                StoredItem resolvedStoredItem = StoredItemResolver.resolve(null, (String)accountId, (String)id, cache.get(id));
                idToStoredItem.put(id, resolvedStoredItem.getData());
            }
            catch (PreBidException e) {
                missedIds.add(id);
            }
        }
        return idToStoredItem;
    }

    public void invalidateAccountCache(String accountId) {
        this.accountCache.remove(accountId);
        logger.debug((Object)"Account with id {0} was invalidated", new Object[]{accountId});
    }

    public void invalidateAllAccountCache() {
        this.accountCache.clear();
        logger.debug((Object)"All accounts cache were invalidated");
    }

    private static <ANY> void noOp(ANY any) {
    }
}

