/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.proto.openrtb.ext.request;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestBidAdjustmentFactors;
import org.prebid.server.proto.openrtb.ext.request.ImpMediaType;

public final class ExtRequestBidAdjustmentFactors {
    private final Map<String, BigDecimal> adjustments = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private final EnumMap<ImpMediaType, Map<String, BigDecimal>> mediatypes;

    @JsonAnyGetter
    public Map<String, BigDecimal> getAdjustments() {
        return Collections.unmodifiableMap(this.adjustments);
    }

    @JsonAnySetter
    public void addFactor(String key, BigDecimal value) {
        this.adjustments.put(key, value);
    }

    @ConstructorProperties(value={"mediatypes"})
    ExtRequestBidAdjustmentFactors(EnumMap<ImpMediaType, Map<String, BigDecimal>> mediatypes) {
        this.mediatypes = mediatypes;
    }

    public static ExtRequestBidAdjustmentFactorsBuilder builder() {
        return new ExtRequestBidAdjustmentFactorsBuilder();
    }

    public ExtRequestBidAdjustmentFactorsBuilder toBuilder() {
        return new ExtRequestBidAdjustmentFactorsBuilder().mediatypes(this.mediatypes);
    }

    public EnumMap<ImpMediaType, Map<String, BigDecimal>> getMediatypes() {
        return this.mediatypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtRequestBidAdjustmentFactors)) {
            return false;
        }
        ExtRequestBidAdjustmentFactors other = (ExtRequestBidAdjustmentFactors)o;
        Map this$adjustments = this.getAdjustments();
        Map other$adjustments = other.getAdjustments();
        if (this$adjustments == null ? other$adjustments != null : !((Object)this$adjustments).equals(other$adjustments)) {
            return false;
        }
        EnumMap this$mediatypes = this.getMediatypes();
        EnumMap other$mediatypes = other.getMediatypes();
        return !(this$mediatypes == null ? other$mediatypes != null : !((Object)this$mediatypes).equals(other$mediatypes));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map $adjustments = this.getAdjustments();
        result = result * 59 + ($adjustments == null ? 43 : ((Object)$adjustments).hashCode());
        EnumMap $mediatypes = this.getMediatypes();
        result = result * 59 + ($mediatypes == null ? 43 : ((Object)$mediatypes).hashCode());
        return result;
    }

    public String toString() {
        return "ExtRequestBidAdjustmentFactors(adjustments=" + this.getAdjustments() + ", mediatypes=" + this.getMediatypes() + ")";
    }
}

