/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.gdpr;

import com.iabtcf.decoder.DecoderOption;
import com.iabtcf.decoder.TCString;
import io.vertx.core.Future;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.IpAddressHelper;
import org.prebid.server.auction.model.IpAddress;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.execution.Timeout;
import org.prebid.server.geolocation.GeoLocationService;
import org.prebid.server.geolocation.model.GeoInfo;
import org.prebid.server.log.ConditionalLogger;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.Metrics;
import org.prebid.server.privacy.gdpr.Tcf2Service;
import org.prebid.server.privacy.gdpr.TcfDefinerService;
import org.prebid.server.privacy.gdpr.VendorIdResolver;
import org.prebid.server.privacy.gdpr.model.PrivacyEnforcementAction;
import org.prebid.server.privacy.gdpr.model.RequestLogInfo;
import org.prebid.server.privacy.gdpr.model.TCStringEmpty;
import org.prebid.server.privacy.gdpr.model.TcfContext;
import org.prebid.server.privacy.gdpr.model.TcfResponse;
import org.prebid.server.privacy.gdpr.model.VendorPermission;
import org.prebid.server.privacy.model.Privacy;
import org.prebid.server.settings.model.AccountGdprConfig;
import org.prebid.server.settings.model.EnabledForRequestType;
import org.prebid.server.settings.model.GdprConfig;

/*
 * Exception performing whole class analysis ignored.
 */
public class TcfDefinerService {
    private static final Logger logger = LoggerFactory.getLogger(TcfDefinerService.class);
    private static final ConditionalLogger AMP_CORRUPT_CONSENT_LOGGER = new ConditionalLogger("amp_corrupt_consent", logger);
    private static final ConditionalLogger APP_CORRUPT_CONSENT_LOGGER = new ConditionalLogger("app_corrupt_consent", logger);
    private static final ConditionalLogger SITE_CORRUPT_CONSENT_LOGGER = new ConditionalLogger("site_corrupt_consent", logger);
    private static final ConditionalLogger DOOH_CORRUPT_CONSENT_LOGGER = new ConditionalLogger("dooh_corrupt_consent", logger);
    private static final ConditionalLogger UNDEFINED_CORRUPT_CONSENT_LOGGER = new ConditionalLogger("undefined_corrupt_consent", logger);
    private static final String GDPR_ENABLED = "1";
    private final boolean gdprEnabled;
    private final String gdprDefaultValue;
    private final boolean consentStringMeansInScope;
    private final Tcf2Service tcf2Service;
    private final Set<String> eeaCountries;
    private final GeoLocationService geoLocationService;
    private final BidderCatalog bidderCatalog;
    private final IpAddressHelper ipAddressHelper;
    private final Metrics metrics;

    public TcfDefinerService(GdprConfig gdprConfig, Set<String> eeaCountries, Tcf2Service tcf2Service, GeoLocationService geoLocationService, BidderCatalog bidderCatalog, IpAddressHelper ipAddressHelper, Metrics metrics) {
        this.gdprEnabled = gdprConfig != null && BooleanUtils.isNotFalse((Boolean)gdprConfig.getEnabled());
        this.gdprDefaultValue = gdprConfig != null ? gdprConfig.getDefaultValue() : null;
        this.consentStringMeansInScope = gdprConfig != null && BooleanUtils.isTrue((Boolean)gdprConfig.getConsentStringMeansInScope());
        this.tcf2Service = Objects.requireNonNull(tcf2Service);
        this.eeaCountries = Objects.requireNonNull(eeaCountries);
        this.geoLocationService = geoLocationService;
        this.bidderCatalog = Objects.requireNonNull(bidderCatalog);
        this.ipAddressHelper = Objects.requireNonNull(ipAddressHelper);
        this.metrics = Objects.requireNonNull(metrics);
    }

    public Future<TcfContext> resolveTcfContext(Privacy privacy, String country, String ipAddress, AccountGdprConfig accountGdprConfig, MetricName requestType, RequestLogInfo requestLogInfo, Timeout timeout) {
        Future tcfContextFuture = !this.isGdprEnabled(accountGdprConfig, requestType) ? Future.succeededFuture((Object)TcfContext.empty()) : this.prepareTcfContext(privacy, country, ipAddress, requestLogInfo, timeout);
        return tcfContextFuture.map(arg_0 -> this.updateTcfGeoMetrics(arg_0));
    }

    public Future<TcfContext> resolveTcfContext(Privacy privacy, String ipAddress, AccountGdprConfig accountGdprConfig, MetricName requestType, RequestLogInfo requestLogInfo, Timeout timeout) {
        return this.resolveTcfContext(privacy, null, ipAddress, accountGdprConfig, requestType, requestLogInfo, timeout);
    }

    public Future<TcfResponse<Integer>> resultForVendorIds(Set<Integer> vendorIds, TcfContext tcfContext) {
        return this.resultForInternal(tcfContext, country -> this.createAllowAllTcfResponse(vendorIds, country), (tcfConsent, country) -> this.tcf2Service.permissionsFor(vendorIds, tcfConsent).map(vendorPermissions -> TcfDefinerService.createVendorIdTcfResponse((Collection)vendorPermissions, (String)country)));
    }

    public Future<TcfResponse<String>> resultForBidderNames(Set<String> bidderNames, VendorIdResolver vendorIdResolver, TcfContext tcfContext, AccountGdprConfig accountGdprConfig) {
        return this.resultForInternal(tcfContext, country -> this.createAllowAllTcfResponse(bidderNames, country), (consentString, country) -> this.tcf2Service.permissionsFor(bidderNames, vendorIdResolver, consentString, accountGdprConfig).map(vendorPermissions -> TcfDefinerService.createBidderNameTcfResponse((Collection)vendorPermissions, (String)country)));
    }

    public Future<TcfResponse<String>> resultForBidderNames(Set<String> bidderNames, TcfContext tcfContext, AccountGdprConfig accountGdprConfig) {
        return this.resultForBidderNames(bidderNames, VendorIdResolver.of((BidderCatalog)this.bidderCatalog), tcfContext, accountGdprConfig);
    }

    private <T> Future<TcfResponse<T>> resultForInternal(TcfContext tcfContext, Function<String, Future<TcfResponse<T>>> allowAllTcfResponseCreator, BiFunction<TCString, String, Future<TcfResponse<T>>> tcf2Strategy) {
        String country;
        GeoInfo geoInfo = tcfContext.getGeoInfo();
        String string = country = geoInfo != null ? geoInfo.getCountry() : null;
        if (!tcfContext.isInGdprScope()) {
            return allowAllTcfResponseCreator.apply(country);
        }
        return tcf2Strategy.apply(tcfContext.getConsent(), country);
    }

    private boolean isGdprEnabled(AccountGdprConfig accountGdprConfig, MetricName requestType) {
        Boolean accountGdprEnabled;
        Boolean bl = accountGdprEnabled = accountGdprConfig != null ? accountGdprConfig.getEnabled() : null;
        if (requestType == null) {
            return (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{accountGdprEnabled, this.gdprEnabled});
        }
        EnabledForRequestType enabledForRequestType = accountGdprConfig != null ? accountGdprConfig.getEnabledForRequestType() : null;
        Boolean enabledForType = enabledForRequestType != null ? enabledForRequestType.isEnabledFor(requestType) : null;
        return (Boolean)ObjectUtils.firstNonNull((Object[])new Boolean[]{enabledForType, accountGdprEnabled, this.gdprEnabled});
    }

    private Future<TcfContext> prepareTcfContext(Privacy privacy, String country, String ipAddress, RequestLogInfo requestLogInfo, Timeout timeout) {
        String consentString = privacy.getConsentString();
        TCStringParsingResult consentStringParsingResult = this.parseConsentString(consentString, requestLogInfo);
        TCString consent = consentStringParsingResult.getResult();
        boolean consentValid = TcfDefinerService.isConsentValid((TCString)consent);
        String effectiveIpAddress = this.maybeMaskIp(ipAddress, consent);
        Boolean inEea = this.isCountryInEea(country);
        TcfContext defaultContext = TcfContext.builder().inGdprScope(TcfDefinerService.inScopeOfGdpr((String)this.gdprDefaultValue)).consentString(consentString).consent(consent).consentValid(consentValid).inEea(inEea).ipAddress(effectiveIpAddress).warnings(consentStringParsingResult.getWarnings()).build();
        if (this.consentStringMeansInScope && consentValid) {
            return Future.succeededFuture((Object)defaultContext.toBuilder().inGdprScope(true).build());
        }
        String gdpr = privacy.getGdpr();
        if (StringUtils.isNotEmpty((CharSequence)gdpr)) {
            return Future.succeededFuture((Object)defaultContext.toBuilder().inGdprScope(TcfDefinerService.inScopeOfGdpr((String)gdpr)).build());
        }
        if (country != null) {
            return Future.succeededFuture((Object)defaultContext.toBuilder().inGdprScope(this.inScopeOfGdpr(inEea)).build());
        }
        if (ipAddress != null && this.geoLocationService != null) {
            return this.geoLocationService.lookup(effectiveIpAddress, timeout).map(geoInfo -> this.updateMetricsAndEnrichWithGeo(geoInfo, defaultContext)).recover(error -> this.logError(error, defaultContext));
        }
        return Future.succeededFuture((Object)defaultContext);
    }

    private String maybeMaskIp(String ipAddress, TCString consent) {
        if (!TcfDefinerService.shouldMaskIp((TCString)consent)) {
            return ipAddress;
        }
        IpAddress ip = this.ipAddressHelper.toIpAddress(ipAddress);
        if (ip == null) {
            return ipAddress;
        }
        return ip.getVersion() == IpAddress.IP.v4 ? this.ipAddressHelper.maskIpv4(ipAddress) : this.ipAddressHelper.anonymizeIpv6(ipAddress);
    }

    private static boolean shouldMaskIp(TCString consent) {
        return TcfDefinerService.isConsentValid((TCString)consent) && consent.getVersion() == 2 && !consent.getSpecialFeatureOptIns().contains(1);
    }

    private TcfContext updateMetricsAndEnrichWithGeo(GeoInfo geoInfo, TcfContext tcfContext) {
        this.metrics.updateGeoLocationMetric(true);
        Boolean inEea = this.isCountryInEea(geoInfo.getCountry());
        boolean inScope = this.inScopeOfGdpr(inEea);
        return tcfContext.toBuilder().geoInfo(geoInfo).inGdprScope(inScope).inEea(inEea).build();
    }

    private Future<TcfContext> logError(Throwable error, TcfContext tcfContext) {
        String message = "Geolocation lookup failed: " + error.getMessage();
        logger.warn((Object)message);
        logger.debug((Object)message, error);
        this.metrics.updateGeoLocationMetric(false);
        return Future.succeededFuture((Object)tcfContext);
    }

    private Boolean isCountryInEea(String country) {
        return country != null ? Boolean.valueOf(this.eeaCountries.contains(country)) : null;
    }

    private TcfContext updateTcfGeoMetrics(TcfContext tcfContext) {
        if (tcfContext.isInGdprScope()) {
            this.metrics.updatePrivacyTcfGeoMetric(tcfContext.getConsent().getVersion(), tcfContext.getInEea());
        }
        return tcfContext;
    }

    private <T> Future<TcfResponse<T>> createAllowAllTcfResponse(Set<T> keys, String country) {
        return Future.succeededFuture((Object)TcfResponse.of((Boolean)false, (Map)TcfDefinerService.allowAll(keys), (String)country));
    }

    private static TcfResponse<Integer> createVendorIdTcfResponse(Collection<VendorPermission> vendorPermissions, String country) {
        return TcfResponse.of((Boolean)true, vendorPermissions.stream().collect(Collectors.toMap(VendorPermission::getVendorId, VendorPermission::getPrivacyEnforcementAction)), (String)country);
    }

    private static TcfResponse<String> createBidderNameTcfResponse(Collection<VendorPermission> vendorPermissions, String country) {
        return TcfResponse.of((Boolean)true, vendorPermissions.stream().collect(Collectors.toMap(VendorPermission::getBidderName, VendorPermission::getPrivacyEnforcementAction)), (String)country);
    }

    private static <T> Map<T, PrivacyEnforcementAction> allowAll(Collection<T> identifiers) {
        return identifiers.stream().collect(Collectors.toMap(Function.identity(), ignored -> PrivacyEnforcementAction.allowAll()));
    }

    private static boolean inScopeOfGdpr(String gdpr) {
        return Objects.equals(gdpr, "1");
    }

    private boolean inScopeOfGdpr(Boolean inEea) {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)inEea, (boolean)TcfDefinerService.inScopeOfGdpr((String)this.gdprDefaultValue));
    }

    private TCStringParsingResult parseConsentString(String consentString, RequestLogInfo requestLogInfo) {
        ArrayList warnings = new ArrayList();
        if (StringUtils.isBlank((CharSequence)consentString)) {
            this.metrics.updatePrivacyTcfMissingMetric();
            return TCStringParsingResult.of((TCString)TCStringEmpty.create(), warnings);
        }
        TCString tcString = this.decodeTcString(consentString, requestLogInfo, warnings);
        if (tcString == null) {
            this.metrics.updatePrivacyTcfInvalidMetric();
            return TCStringParsingResult.of((TCString)TCStringEmpty.create(), warnings);
        }
        return this.toValidResult(consentString, TCStringParsingResult.of((TCString)tcString, warnings));
    }

    private TCStringParsingResult toValidResult(String consentString, TCStringParsingResult parsingResult) {
        List warnings = parsingResult.getWarnings();
        TCString tcString = parsingResult.getResult();
        int version = tcString.getVersion();
        this.metrics.updatePrivacyTcfRequestsMetric(version);
        if (version == 1) {
            warnings.add("Parsing consent string:\"" + consentString + "\" failed. TCF version 1 is deprecated and treated as corrupted TCF version 2");
            return TCStringParsingResult.of((TCString)TCStringEmpty.create(), (List)warnings);
        }
        int tcfPolicyVersion = tcString.getTcfPolicyVersion();
        if (tcfPolicyVersion > 4) {
            warnings.add("Parsing consent string: %s failed. TCF policy version %d is not supported".formatted(consentString, tcfPolicyVersion));
            return TCStringParsingResult.of((TCString)TCStringEmpty.create(), (List)warnings);
        }
        return TCStringParsingResult.of((TCString)tcString, (List)warnings);
    }

    private TCString decodeTcString(String consentString, RequestLogInfo requestLogInfo, List<String> warnings) {
        try {
            return TCString.decode((String)consentString, (DecoderOption[])new DecoderOption[0]);
        }
        catch (Exception e) {
            TcfDefinerService.logWarn((String)consentString, (String)e.getMessage(), (RequestLogInfo)requestLogInfo);
            warnings.add("Parsing consent string:\"%s\" - failed. %s".formatted(consentString, e.getMessage()));
            return null;
        }
    }

    private static void logWarn(String consent, String message, RequestLogInfo requestLogInfo) {
        if (requestLogInfo == null || requestLogInfo.getRequestType() == null) {
            String exceptionMessage = "Parsing consent string:\"%s\" failed for undefined type with exception %s".formatted(consent, message);
            UNDEFINED_CORRUPT_CONSENT_LOGGER.info(exceptionMessage, 100);
            return;
        }
        switch (1.$SwitchMap$org$prebid$server$metric$MetricName[requestLogInfo.getRequestType().ordinal()]) {
            case 1: {
                AMP_CORRUPT_CONSENT_LOGGER.info(TcfDefinerService.logMessage((String)consent, (String)MetricName.amp.toString(), (RequestLogInfo)requestLogInfo, (String)message), 100);
                break;
            }
            case 2: {
                APP_CORRUPT_CONSENT_LOGGER.info(TcfDefinerService.logMessage((String)consent, (String)MetricName.openrtb2app.toString(), (RequestLogInfo)requestLogInfo, (String)message), 100);
                break;
            }
            case 3: {
                DOOH_CORRUPT_CONSENT_LOGGER.info(TcfDefinerService.logMessage((String)consent, (String)MetricName.openrtb2dooh.toString(), (RequestLogInfo)requestLogInfo, (String)message), 100);
                break;
            }
            case 4: {
                SITE_CORRUPT_CONSENT_LOGGER.info(TcfDefinerService.logMessage((String)consent, (String)MetricName.openrtb2web.toString(), (RequestLogInfo)requestLogInfo, (String)message), 100);
                break;
            }
            default: {
                UNDEFINED_CORRUPT_CONSENT_LOGGER.info(TcfDefinerService.logMessage((String)consent, (String)"video or sync or setuid", (RequestLogInfo)requestLogInfo, (String)message), 100);
            }
        }
    }

    private static String logMessage(String consent, String type, RequestLogInfo requestLogInfo, String message) {
        return "Parsing consent string: \"%s\" failed for: %s type for account id: %s with ref: %s with exception: %s".formatted(consent, type, requestLogInfo.getAccountId(), requestLogInfo.getRefUrl(), message);
    }

    private static boolean isConsentValid(TCString consent) {
        return consent != null && !(consent instanceof TCStringEmpty);
    }

    public static boolean isConsentStringValid(String consentString) {
        try {
            TCString.decode((String)consentString, (DecoderOption[])new DecoderOption[0]);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }
}

