/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.privacy.gdpr;

import com.iabtcf.decoder.TCString;
import io.vertx.core.Future;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.privacy.gdpr.Tcf2Service;
import org.prebid.server.privacy.gdpr.VendorIdResolver;
import org.prebid.server.privacy.gdpr.model.PrivacyEnforcementAction;
import org.prebid.server.privacy.gdpr.model.VendorPermission;
import org.prebid.server.privacy.gdpr.model.VendorPermissionWithGvl;
import org.prebid.server.privacy.gdpr.tcfstrategies.purpose.PurposeStrategy;
import org.prebid.server.privacy.gdpr.tcfstrategies.specialfeature.SpecialFeaturesStrategy;
import org.prebid.server.privacy.gdpr.vendorlist.VersionedVendorListService;
import org.prebid.server.privacy.gdpr.vendorlist.proto.PurposeCode;
import org.prebid.server.privacy.gdpr.vendorlist.proto.Vendor;
import org.prebid.server.settings.model.AccountGdprConfig;
import org.prebid.server.settings.model.EnforcePurpose;
import org.prebid.server.settings.model.GdprConfig;
import org.prebid.server.settings.model.Purpose;
import org.prebid.server.settings.model.PurposeOneTreatmentInterpretation;
import org.prebid.server.settings.model.Purposes;
import org.prebid.server.settings.model.SpecialFeature;
import org.prebid.server.settings.model.SpecialFeatures;

/*
 * Exception performing whole class analysis ignored.
 */
public class Tcf2Service {
    private final Purposes defaultPurposes;
    private final SpecialFeatures defaultSpecialFeatures;
    private final VersionedVendorListService versionedVendorListService;
    private final List<PurposeStrategy> purposeStrategies;
    private final List<SpecialFeaturesStrategy> specialFeaturesStrategies;
    private final BidderCatalog bidderCatalog;
    private final PurposeOneTreatmentInterpretation purposeOneTreatmentInterpretation;

    public Tcf2Service(GdprConfig gdprConfig, List<PurposeStrategy> purposeStrategies, List<SpecialFeaturesStrategy> specialFeaturesStrategies, VersionedVendorListService versionedVendorListService, BidderCatalog bidderCatalog) {
        this.defaultPurposes = gdprConfig.getPurposes() == null ? Purposes.builder().build() : gdprConfig.getPurposes();
        this.defaultSpecialFeatures = gdprConfig.getSpecialFeatures() == null ? SpecialFeatures.builder().build() : gdprConfig.getSpecialFeatures();
        this.purposeOneTreatmentInterpretation = gdprConfig.getPurposeOneTreatmentInterpretation();
        this.versionedVendorListService = Objects.requireNonNull(versionedVendorListService);
        this.bidderCatalog = Objects.requireNonNull(bidderCatalog);
        this.purposeStrategies = Objects.requireNonNull(purposeStrategies);
        this.specialFeaturesStrategies = Objects.requireNonNull(specialFeaturesStrategies);
    }

    public Future<Collection<VendorPermission>> permissionsFor(Set<Integer> vendorIds, TCString tcfConsent) {
        return this.permissionsForInternal(this.vendorPermissions(vendorIds), tcfConsent, null);
    }

    public Future<Collection<VendorPermission>> permissionsFor(Set<String> bidderNames, VendorIdResolver vendorIdResolver, TCString tcfConsent, AccountGdprConfig accountGdprConfig) {
        return this.permissionsForInternal(this.vendorPermissions(bidderNames, vendorIdResolver), tcfConsent, accountGdprConfig);
    }

    private Collection<VendorPermission> vendorPermissions(Set<Integer> vendorIds) {
        return vendorIds.stream().filter(Objects::nonNull).map(vendorId -> VendorPermission.of((Integer)vendorId, (String)this.bidderCatalog.nameByVendorId(vendorId), (PrivacyEnforcementAction)PrivacyEnforcementAction.restrictAll())).toList();
    }

    private Collection<VendorPermission> vendorPermissions(Set<String> bidderNames, VendorIdResolver vendorIdResolver) {
        return bidderNames.stream().filter(Objects::nonNull).map(bidderName -> VendorPermission.of((Integer)vendorIdResolver.resolve(bidderName), (String)bidderName, (PrivacyEnforcementAction)PrivacyEnforcementAction.restrictAll())).toList();
    }

    private Future<Collection<VendorPermission>> permissionsForInternal(Collection<VendorPermission> vendorPermissions, TCString tcfConsent, AccountGdprConfig accountGdprConfig) {
        Purposes mergedPurposes = this.mergeAccountPurposes(accountGdprConfig);
        SpecialFeatures mergedSpecialFeatures = this.mergeAccountSpecialFeatures(accountGdprConfig);
        PurposeOneTreatmentInterpretation mergedPurposeOneTreatmentInterpretation = this.mergePurposeOneTreatmentInterpretation(accountGdprConfig);
        VendorPermissionsByType vendorPermissionsByType = Tcf2Service.toVendorPermissionsByType(vendorPermissions, (AccountGdprConfig)accountGdprConfig);
        return this.versionedVendorListService.forConsent(tcfConsent).map(vendorGvlPermissions -> Tcf2Service.wrapWithGVL((VendorPermissionsByType)vendorPermissionsByType, (Map)vendorGvlPermissions)).compose(gvlResult -> this.processSupportedPurposeStrategies(tcfConsent, gvlResult, mergedPurposes, this.purposeOneTreatmentInterpretation), ignoredFailed -> this.processDowngradedSupportedPurposeStrategies(tcfConsent, vendorPermissionsByType, mergedPurposes, mergedPurposeOneTreatmentInterpretation)).map(changedVendorPermissions -> this.processSupportedSpecialFeatureStrategies(tcfConsent, changedVendorPermissions, mergedSpecialFeatures));
    }

    private static VendorPermissionsByType<VendorPermission> toVendorPermissionsByType(Collection<VendorPermission> vendorPermissions, AccountGdprConfig accountGdprConfig) {
        List basicEnforcedVendors;
        List list = basicEnforcedVendors = accountGdprConfig != null ? accountGdprConfig.getBasicEnforcementVendors() : null;
        if (CollectionUtils.isEmpty((Collection)basicEnforcedVendors)) {
            return VendorPermissionsByType.of(Collections.emptyList(), vendorPermissions);
        }
        Map<Boolean, List<VendorPermission>> isBasicEnforcedToPermissions = vendorPermissions.stream().collect(Collectors.partitioningBy(vendorPermission -> basicEnforcedVendors.contains(vendorPermission.getBidderName())));
        List weakPermissions = isBasicEnforcedToPermissions.getOrDefault(true, Collections.emptyList());
        List standardPermissions = isBasicEnforcedToPermissions.getOrDefault(false, Collections.emptyList());
        return VendorPermissionsByType.of(weakPermissions, standardPermissions);
    }

    private static VendorPermissionsByType<VendorPermissionWithGvl> wrapWithGVL(VendorPermissionsByType<VendorPermission> vendorPermissionsByType, Map<Integer, Vendor> vendorGvlPermissions) {
        List<VendorPermissionWithGvl> weakPermissions = vendorPermissionsByType.getWeakPermissions().stream().map(vendorPermission -> Tcf2Service.wrapWithGVL((VendorPermission)vendorPermission, (Map)vendorGvlPermissions)).toList();
        List<VendorPermissionWithGvl> standardPermissions = vendorPermissionsByType.getStandardPermissions().stream().map(vendorPermission -> Tcf2Service.wrapWithGVL((VendorPermission)vendorPermission, (Map)vendorGvlPermissions)).toList();
        return VendorPermissionsByType.of(weakPermissions, standardPermissions);
    }

    private static VendorPermissionWithGvl wrapWithGVL(VendorPermission vendorPermission, Map<Integer, Vendor> vendorGvlPermissions) {
        Integer vendorId = vendorPermission.getVendorId();
        Vendor vendorGvlByVendorId = vendorId != null ? vendorGvlPermissions.getOrDefault(vendorId, Vendor.empty((Integer)vendorId)) : Vendor.empty((Integer)vendorId);
        return VendorPermissionWithGvl.of((VendorPermission)vendorPermission, (Vendor)vendorGvlByVendorId);
    }

    private Future<Collection<VendorPermission>> processSupportedPurposeStrategies(TCString tcfConsent, VendorPermissionsByType<VendorPermissionWithGvl> vendorPermissionsByType, Purposes purposes, PurposeOneTreatmentInterpretation purposeOneTreatmentInterpretation) {
        for (PurposeStrategy purposeStrategy : this.purposeStrategies) {
            PurposeCode tcfPurpose = purposeStrategy.getPurpose();
            Purpose purposeById = this.findPurposeByTcfPurpose(tcfPurpose, purposes);
            Purpose weakPurpose = Tcf2Service.weakPurpose((Purpose)purposeById);
            Collection standardPermissions = vendorPermissionsByType.getStandardPermissions();
            Collection weakPermissions = vendorPermissionsByType.getWeakPermissions();
            this.processPurposeStrategy(tcfConsent, standardPermissions, purposeById, purposeStrategy, purposeOneTreatmentInterpretation, false);
            this.processPurposeStrategy(tcfConsent, weakPermissions, weakPurpose, purposeStrategy, purposeOneTreatmentInterpretation, true);
        }
        return Future.succeededFuture(vendorPermissionsByType.joinPermissions().stream().map(VendorPermissionWithGvl::getVendorPermission).toList());
    }

    private Future<Collection<VendorPermission>> processDowngradedSupportedPurposeStrategies(TCString tcfConsent, VendorPermissionsByType<VendorPermission> vendorPermissionsByType, Purposes purposes, PurposeOneTreatmentInterpretation purposeOneTreatmentInterpretation) {
        VendorPermissionsByType vendorPermissionsWithGvlByType = Tcf2Service.wrapWithGVL(vendorPermissionsByType, Collections.emptyMap());
        for (PurposeStrategy purposeStrategy : this.purposeStrategies) {
            PurposeCode tcfPurpose = purposeStrategy.getPurpose();
            Purpose downgradedPurposeById = Tcf2Service.downgradePurpose((Purpose)this.findPurposeByTcfPurpose(tcfPurpose, purposes));
            Purpose weakPurpose = Tcf2Service.weakPurpose((Purpose)downgradedPurposeById);
            Collection standardPermissions = vendorPermissionsWithGvlByType.getStandardPermissions();
            Collection weakPermissions = vendorPermissionsWithGvlByType.getWeakPermissions();
            this.processPurposeStrategy(tcfConsent, standardPermissions, downgradedPurposeById, purposeStrategy, purposeOneTreatmentInterpretation, true);
            this.processPurposeStrategy(tcfConsent, weakPermissions, weakPurpose, purposeStrategy, purposeOneTreatmentInterpretation, true);
        }
        return Future.succeededFuture((Object)vendorPermissionsByType.joinPermissions());
    }

    private void processPurposeStrategy(TCString tcfConsent, Collection<VendorPermissionWithGvl> vendorPermissionsWithGvl, Purpose purpose, PurposeStrategy purposeStrategy, PurposeOneTreatmentInterpretation purposeOneTreatmentInterpretation, boolean wasDowngraded) {
        if (purposeStrategy.getPurpose() == PurposeCode.ONE && tcfConsent.getPurposeOneTreatment()) {
            this.processPurposeOneTreatment(purposeOneTreatmentInterpretation, tcfConsent, purpose, purposeStrategy, vendorPermissionsWithGvl, wasDowngraded);
        } else {
            purposeStrategy.processTypePurposeStrategy(tcfConsent, purpose, vendorPermissionsWithGvl, wasDowngraded);
        }
    }

    private void processPurposeOneTreatment(PurposeOneTreatmentInterpretation purposeOneTreatmentInterpretation, TCString tcfConsent, Purpose purposeOne, PurposeStrategy purposeOneStrategy, Collection<VendorPermissionWithGvl> vendorPermissionsWithGvl, boolean wasDowngraded) {
        switch (1.$SwitchMap$org$prebid$server$settings$model$PurposeOneTreatmentInterpretation[purposeOneTreatmentInterpretation.ordinal()]) {
            case 1: {
                vendorPermissionsWithGvl.forEach(vendorPermission -> purposeOneStrategy.allow(vendorPermission.getVendorPermission().getPrivacyEnforcementAction()));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                purposeOneStrategy.processTypePurposeStrategy(tcfConsent, purposeOne, vendorPermissionsWithGvl, wasDowngraded);
            }
        }
    }

    private static Purpose downgradePurpose(Purpose purpose) {
        EnforcePurpose enforcePurpose = purpose.getEnforcePurpose();
        return enforcePurpose == null || Objects.equals(enforcePurpose, EnforcePurpose.full) ? Purpose.of((EnforcePurpose)EnforcePurpose.basic, (Boolean)purpose.getEnforceVendors(), (List)purpose.getVendorExceptions()) : purpose;
    }

    private static Purpose weakPurpose(Purpose purpose) {
        EnforcePurpose enforcePurpose = purpose.getEnforcePurpose();
        EnforcePurpose downgradedEnforce = enforcePurpose == null || Objects.equals(enforcePurpose, EnforcePurpose.full) ? EnforcePurpose.basic : enforcePurpose;
        return Purpose.of((EnforcePurpose)downgradedEnforce, (Boolean)false, (List)purpose.getVendorExceptions());
    }

    private Collection<VendorPermission> processSupportedSpecialFeatureStrategies(TCString tcfConsent, Collection<VendorPermission> vendorPermissions, SpecialFeatures specialFeatures) {
        for (SpecialFeaturesStrategy specialFeaturesStrategy : this.specialFeaturesStrategies) {
            int specialFeatureId = specialFeaturesStrategy.getSpecialFeatureId();
            SpecialFeature specialFeatureById = this.findSpecialFeatureById(specialFeatureId, specialFeatures);
            specialFeaturesStrategy.processSpecialFeaturesStrategy(tcfConsent, specialFeatureById, vendorPermissions);
        }
        return vendorPermissions;
    }

    private Purposes mergeAccountPurposes(AccountGdprConfig accountGdprConfig) {
        if (accountGdprConfig == null || accountGdprConfig.getPurposes() == null) {
            return this.defaultPurposes;
        }
        Purposes accountPurposes = accountGdprConfig.getPurposes();
        return Purposes.builder().p1((Purpose)Tcf2Service.mergeItem((Object)accountPurposes.getP1(), (Object)this.defaultPurposes.getP1())).p2((Purpose)Tcf2Service.mergeItem((Object)accountPurposes.getP2(), (Object)this.defaultPurposes.getP2())).p3((Purpose)Tcf2Service.mergeItem((Object)accountPurposes.getP3(), (Object)this.defaultPurposes.getP3())).p4((Purpose)Tcf2Service.mergeItem((Object)accountPurposes.getP4(), (Object)this.defaultPurposes.getP4())).p5((Purpose)Tcf2Service.mergeItem((Object)accountPurposes.getP5(), (Object)this.defaultPurposes.getP5())).p6((Purpose)Tcf2Service.mergeItem((Object)accountPurposes.getP6(), (Object)this.defaultPurposes.getP6())).p7((Purpose)Tcf2Service.mergeItem((Object)accountPurposes.getP7(), (Object)this.defaultPurposes.getP7())).p8((Purpose)Tcf2Service.mergeItem((Object)accountPurposes.getP8(), (Object)this.defaultPurposes.getP8())).p9((Purpose)Tcf2Service.mergeItem((Object)accountPurposes.getP9(), (Object)this.defaultPurposes.getP9())).p10((Purpose)Tcf2Service.mergeItem((Object)accountPurposes.getP10(), (Object)this.defaultPurposes.getP10())).build();
    }

    private SpecialFeatures mergeAccountSpecialFeatures(AccountGdprConfig accountGdprConfig) {
        if (accountGdprConfig == null || accountGdprConfig.getSpecialFeatures() == null) {
            return this.defaultSpecialFeatures;
        }
        SpecialFeatures accountSpecialFeatures = accountGdprConfig.getSpecialFeatures();
        return SpecialFeatures.builder().sf1((SpecialFeature)Tcf2Service.mergeItem((Object)accountSpecialFeatures.getSf1(), (Object)this.defaultSpecialFeatures.getSf1())).sf2((SpecialFeature)Tcf2Service.mergeItem((Object)accountSpecialFeatures.getSf2(), (Object)this.defaultSpecialFeatures.getSf2())).build();
    }

    private Purpose findPurposeByTcfPurpose(PurposeCode tcfPurpose, Purposes purposes) {
        return switch (1.$SwitchMap$org$prebid$server$privacy$gdpr$vendorlist$proto$PurposeCode[tcfPurpose.ordinal()]) {
            case 1 -> purposes.getP1();
            case 2 -> purposes.getP2();
            case 3 -> purposes.getP3();
            case 4 -> purposes.getP4();
            case 5 -> purposes.getP5();
            case 6 -> purposes.getP6();
            case 7 -> purposes.getP7();
            case 8 -> purposes.getP8();
            case 9 -> purposes.getP9();
            case 10 -> purposes.getP10();
            default -> throw new IllegalArgumentException("Illegal TCF code for purpose: " + tcfPurpose);
        };
    }

    private SpecialFeature findSpecialFeatureById(int specialFeatureId, SpecialFeatures specialFeatures) {
        return switch (specialFeatureId) {
            case 1 -> specialFeatures.getSf1();
            case 2 -> specialFeatures.getSf2();
            default -> throw new IllegalArgumentException("Illegal TCF code for special feature: " + specialFeatureId);
        };
    }

    private PurposeOneTreatmentInterpretation mergePurposeOneTreatmentInterpretation(AccountGdprConfig accountGdprConfig) {
        if (accountGdprConfig == null || accountGdprConfig.getPurposeOneTreatmentInterpretation() == null) {
            return this.purposeOneTreatmentInterpretation;
        }
        return (PurposeOneTreatmentInterpretation)Tcf2Service.mergeItem((Object)accountGdprConfig.getPurposeOneTreatmentInterpretation(), (Object)this.purposeOneTreatmentInterpretation);
    }

    private static <T> T mergeItem(T prioritisedItem, T item) {
        return prioritisedItem == null ? item : prioritisedItem;
    }
}

