/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.model;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import java.beans.ConstructorProperties;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.model.CaseInsensitiveMultiMap;
import org.prebid.server.model.HttpRequestContext;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public final class HttpRequestContext {
    private final String absoluteUri;
    private final CaseInsensitiveMultiMap queryParams;
    private final CaseInsensitiveMultiMap headers;
    private final String body;
    private final String scheme;
    private final String remoteHost;

    public static HttpRequestContext from(RoutingContext context) {
        return HttpRequestContext.builder().absoluteUri(context.request().uri()).queryParams(CaseInsensitiveMultiMap.builder().addAll(HttpRequestContext.toMap((MultiMap)context.request().params())).build()).headers(HttpRequestContext.headers((RoutingContext)context)).build();
    }

    private static CaseInsensitiveMultiMap headers(RoutingContext context) {
        Map headers = HttpRequestContext.toMap((MultiMap)context.request().headers());
        String cookieHeader = HttpUtil.createCookiesHeader((RoutingContext)context);
        if (StringUtils.isNotEmpty((CharSequence)cookieHeader)) {
            headers.put(HttpHeaders.COOKIE.toString(), cookieHeader);
        }
        return CaseInsensitiveMultiMap.builder().addAll(headers).build();
    }

    private static Map<String, String> toMap(MultiMap multiMap) {
        return multiMap.names().stream().collect(Collectors.toMap(Function.identity(), arg_0 -> ((MultiMap)multiMap).get(arg_0)));
    }

    @ConstructorProperties(value={"absoluteUri", "queryParams", "headers", "body", "scheme", "remoteHost"})
    HttpRequestContext(String absoluteUri, CaseInsensitiveMultiMap queryParams, CaseInsensitiveMultiMap headers, String body, String scheme, String remoteHost) {
        this.absoluteUri = absoluteUri;
        this.queryParams = queryParams;
        this.headers = headers;
        this.body = body;
        this.scheme = scheme;
        this.remoteHost = remoteHost;
    }

    public static HttpRequestContextBuilder builder() {
        return new HttpRequestContextBuilder();
    }

    public String getAbsoluteUri() {
        return this.absoluteUri;
    }

    public CaseInsensitiveMultiMap getQueryParams() {
        return this.queryParams;
    }

    public CaseInsensitiveMultiMap getHeaders() {
        return this.headers;
    }

    public String getBody() {
        return this.body;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequestContext)) {
            return false;
        }
        HttpRequestContext other = (HttpRequestContext)o;
        String this$absoluteUri = this.getAbsoluteUri();
        String other$absoluteUri = other.getAbsoluteUri();
        if (this$absoluteUri == null ? other$absoluteUri != null : !this$absoluteUri.equals(other$absoluteUri)) {
            return false;
        }
        CaseInsensitiveMultiMap this$queryParams = this.getQueryParams();
        CaseInsensitiveMultiMap other$queryParams = other.getQueryParams();
        if (this$queryParams == null ? other$queryParams != null : !this$queryParams.equals(other$queryParams)) {
            return false;
        }
        CaseInsensitiveMultiMap this$headers = this.getHeaders();
        CaseInsensitiveMultiMap other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
            return false;
        }
        String this$remoteHost = this.getRemoteHost();
        String other$remoteHost = other.getRemoteHost();
        return !(this$remoteHost == null ? other$remoteHost != null : !this$remoteHost.equals(other$remoteHost));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $absoluteUri = this.getAbsoluteUri();
        result = result * 59 + ($absoluteUri == null ? 43 : $absoluteUri.hashCode());
        CaseInsensitiveMultiMap $queryParams = this.getQueryParams();
        result = result * 59 + ($queryParams == null ? 43 : $queryParams.hashCode());
        CaseInsensitiveMultiMap $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        String $remoteHost = this.getRemoteHost();
        result = result * 59 + ($remoteHost == null ? 43 : $remoteHost.hashCode());
        return result;
    }

    public String toString() {
        return "HttpRequestContext(absoluteUri=" + this.getAbsoluteUri() + ", queryParams=" + this.getQueryParams() + ", headers=" + this.getHeaders() + ", body=" + this.getBody() + ", scheme=" + this.getScheme() + ", remoteHost=" + this.getRemoteHost() + ")";
    }
}

