/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.metric;

import com.codahale.metrics.MetricRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.prebid.server.metric.ActivitiesMetrics;
import org.prebid.server.metric.BidTypeMetrics;
import org.prebid.server.metric.CounterType;
import org.prebid.server.metric.MetricName;
import org.prebid.server.metric.RequestMetrics;
import org.prebid.server.metric.RequestTypeMetrics;
import org.prebid.server.metric.ResponseMetrics;
import org.prebid.server.metric.UpdatableMetrics;

/*
 * Exception performing whole class analysis ignored.
 */
class AdapterTypeMetrics
extends UpdatableMetrics {
    private final Function<MetricName, RequestTypeMetrics> requestTypeMetricsCreator;
    private final Map<MetricName, RequestTypeMetrics> requestTypeMetrics;
    private final RequestMetrics requestMetrics;
    private final Function<String, BidTypeMetrics> bidTypeMetricsCreator;
    private final Map<String, BidTypeMetrics> bidTypeMetrics;
    private final ResponseMetrics responseMetrics;
    private final ActivitiesMetrics activitiesMetrics;

    AdapterTypeMetrics(MetricRegistry metricRegistry, CounterType counterType, String adapterType) {
        super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), AdapterTypeMetrics.nameCreator((String)AdapterTypeMetrics.createAdapterPrefix((String)Objects.requireNonNull(adapterType))));
        this.bidTypeMetricsCreator = bidType -> new BidTypeMetrics(metricRegistry, counterType, AdapterTypeMetrics.createAdapterPrefix((String)adapterType), bidType);
        this.requestTypeMetricsCreator = requestType -> new RequestTypeMetrics(metricRegistry, counterType, AdapterTypeMetrics.createAdapterPrefix((String)adapterType), requestType);
        this.requestTypeMetrics = new HashMap();
        this.requestMetrics = new RequestMetrics(metricRegistry, counterType, AdapterTypeMetrics.createAdapterPrefix((String)adapterType));
        this.bidTypeMetrics = new HashMap();
        this.responseMetrics = new ResponseMetrics(metricRegistry, counterType, AdapterTypeMetrics.createAdapterPrefix((String)adapterType));
        this.activitiesMetrics = new ActivitiesMetrics(metricRegistry, counterType, AdapterTypeMetrics.createAdapterPrefix((String)adapterType));
    }

    AdapterTypeMetrics(MetricRegistry metricRegistry, CounterType counterType, String accountAdapterPrefix, String adapterType) {
        super(Objects.requireNonNull(metricRegistry), Objects.requireNonNull(counterType), AdapterTypeMetrics.nameCreator((String)AdapterTypeMetrics.createAdapterPrefix((String)Objects.requireNonNull(accountAdapterPrefix), (String)Objects.requireNonNull(adapterType))));
        this.requestMetrics = new RequestMetrics(metricRegistry, counterType, AdapterTypeMetrics.createAdapterPrefix((String)accountAdapterPrefix, (String)adapterType));
        this.requestTypeMetricsCreator = null;
        this.requestTypeMetrics = null;
        this.bidTypeMetricsCreator = null;
        this.bidTypeMetrics = null;
        this.responseMetrics = null;
        this.activitiesMetrics = null;
    }

    private static String createAdapterPrefix(String adapterType) {
        return "adapter." + adapterType;
    }

    private static String createAdapterPrefix(String adapterPrefix, String adapterType) {
        return "%s.%s".formatted(adapterPrefix, adapterType);
    }

    private static Function<MetricName, String> nameCreator(String prefix) {
        return metricName -> "%s.%s".formatted(prefix, metricName);
    }

    RequestTypeMetrics requestType(MetricName requestType) {
        return (RequestTypeMetrics)this.requestTypeMetrics.computeIfAbsent(requestType, this.requestTypeMetricsCreator);
    }

    RequestMetrics request() {
        return this.requestMetrics;
    }

    BidTypeMetrics forBidType(String bidType) {
        return (BidTypeMetrics)this.bidTypeMetrics.computeIfAbsent(bidType, this.bidTypeMetricsCreator);
    }

    ResponseMetrics response() {
        return this.responseMetrics;
    }

    ActivitiesMetrics activities() {
        return this.activitiesMetrics;
    }
}

