/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.log.model;

import java.beans.ConstructorProperties;
import org.prebid.server.log.model.HttpLogSpec;

public final class HttpLogSpec {
    private final Endpoint endpoint;
    private final Integer statusCode;
    private final String account;
    private final String bidder;
    private final int limit;

    @ConstructorProperties(value={"endpoint", "statusCode", "account", "bidder", "limit"})
    private HttpLogSpec(Endpoint endpoint, Integer statusCode, String account, String bidder, int limit) {
        this.endpoint = endpoint;
        this.statusCode = statusCode;
        this.account = account;
        this.bidder = bidder;
        this.limit = limit;
    }

    public static HttpLogSpec of(Endpoint endpoint, Integer statusCode, String account, String bidder, int limit) {
        return new HttpLogSpec(endpoint, statusCode, account, bidder, limit);
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public String getAccount() {
        return this.account;
    }

    public String getBidder() {
        return this.bidder;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpLogSpec)) {
            return false;
        }
        HttpLogSpec other = (HttpLogSpec)o;
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        Integer this$statusCode = this.getStatusCode();
        Integer other$statusCode = other.getStatusCode();
        if (this$statusCode == null ? other$statusCode != null : !((Object)this$statusCode).equals(other$statusCode)) {
            return false;
        }
        Endpoint this$endpoint = this.getEndpoint();
        Endpoint other$endpoint = other.getEndpoint();
        if (this$endpoint == null ? other$endpoint != null : !this$endpoint.equals(other$endpoint)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$bidder = this.getBidder();
        String other$bidder = other.getBidder();
        return !(this$bidder == null ? other$bidder != null : !this$bidder.equals(other$bidder));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLimit();
        Integer $statusCode = this.getStatusCode();
        result = result * 59 + ($statusCode == null ? 43 : ((Object)$statusCode).hashCode());
        Endpoint $endpoint = this.getEndpoint();
        result = result * 59 + ($endpoint == null ? 43 : $endpoint.hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $bidder = this.getBidder();
        result = result * 59 + ($bidder == null ? 43 : $bidder.hashCode());
        return result;
    }

    public String toString() {
        return "HttpLogSpec(endpoint=" + this.getEndpoint() + ", statusCode=" + this.getStatusCode() + ", account=" + this.getAccount() + ", bidder=" + this.getBidder() + ", limit=" + this.getLimit() + ")";
    }
}

