/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.log;

import ch.qos.logback.classic.Level;
import io.vertx.core.Vertx;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class LoggerControlKnob {
    private static final String PREBID_LOGGER = "org.prebid.server";
    private final Vertx vertx;
    private final ch.qos.logback.classic.Logger logger;
    private final Level originalLevel;
    private final Lock lock = new ReentrantLock();
    private Long restoreTimerId = null;

    public LoggerControlKnob(Vertx vertx) {
        this.vertx = Objects.requireNonNull(vertx);
        this.logger = LoggerControlKnob.getPrebidLogger();
        this.originalLevel = this.logger != null ? this.logger.getLevel() : null;
    }

    public void changeLogLevel(String level, Duration duration) {
        if (this.logger == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.restoreTimerId != null) {
                this.vertx.cancelTimer(this.restoreTimerId.longValue());
                this.restoreTimerId = null;
            }
            this.logger.setLevel(Level.toLevel((String)level, (Level)this.originalLevel));
            this.restoreTimerId = this.vertx.setTimer(duration.toMillis(), arg_0 -> this.resetLoggerLevel(arg_0));
        }
        finally {
            this.lock.unlock();
        }
    }

    private static ch.qos.logback.classic.Logger getPrebidLogger() {
        Logger prebidSlf4jLogger = LoggerFactory.getLogger((String)"org.prebid.server");
        return prebidSlf4jLogger instanceof ch.qos.logback.classic.Logger ? (ch.qos.logback.classic.Logger)prebidSlf4jLogger : null;
    }

    private void resetLoggerLevel(long triggeredTimerId) {
        this.lock.lock();
        try {
            if (this.restoreTimerId == null || triggeredTimerId != this.restoreTimerId) {
                return;
            }
            this.logger.setLevel(this.originalLevel);
            this.restoreTimerId = null;
        }
        finally {
            this.lock.unlock();
        }
    }
}

