/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.log;

import com.github.benmanes.caffeine.cache.Caffeine;
import io.vertx.core.logging.Logger;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.commons.lang3.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConditionalLogger {
    private static final int CACHE_MAXIMUM_SIZE = 10000;
    private static final int EXPIRE_CACHE_DURATION = 1;
    private final String key;
    private final Logger logger;
    private final ConcurrentMap<String, AtomicInteger> messageToCount;
    private final ConcurrentMap<String, Long> messageToWait;

    public ConditionalLogger(String key, Logger logger) {
        this.key = key;
        this.logger = Objects.requireNonNull(logger);
        this.messageToCount = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.HOURS).build().asMap();
        this.messageToWait = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.HOURS).build().asMap();
    }

    public ConditionalLogger(Logger logger) {
        this(null, logger);
    }

    public void infoWithKey(String key, String message, int limit) {
        this.log(key, limit, logger -> logger.info((Object)message));
    }

    public void info(String message, int limit) {
        this.log(message, limit, logger -> logger.info((Object)message));
    }

    public void info(String message, long duration, TimeUnit unit) {
        this.log(message, duration, unit, logger -> logger.info((Object)message));
    }

    public void info(String message, double samplingRate) {
        if (samplingRate >= 1.0 || ThreadLocalRandom.current().nextDouble() < samplingRate) {
            this.logger.warn((Object)message);
        }
    }

    public void errorWithKey(String key, String message, int limit) {
        this.log(key, limit, logger -> logger.error((Object)message));
    }

    public void error(String message, int limit) {
        this.log(message, limit, logger -> logger.error((Object)message));
    }

    public void error(String message, long duration, TimeUnit unit) {
        this.log(message, duration, unit, logger -> logger.error((Object)message));
    }

    public void error(String message, double samplingRate) {
        if (samplingRate >= 1.0 || ThreadLocalRandom.current().nextDouble() < samplingRate) {
            this.logger.error((Object)message);
        }
    }

    public void debug(String message, int limit) {
        this.log(message, limit, logger -> logger.debug((Object)message));
    }

    public void debug(String message, long duration, TimeUnit unit) {
        this.log(message, duration, unit, logger -> logger.debug((Object)message));
    }

    public void warn(String message, int limit) {
        this.log(message, limit, logger -> logger.warn((Object)message));
    }

    public void warn(String message, long duration, TimeUnit unit) {
        this.log(message, duration, unit, logger -> logger.warn((Object)message));
    }

    public void warn(String message, double samplingRate) {
        if (samplingRate >= 1.0 || ThreadLocalRandom.current().nextDouble() < samplingRate) {
            this.logger.warn((Object)message);
        }
    }

    private void log(String key, int limit, Consumer<Logger> consumer) {
        String resolvedKey = (String)ObjectUtils.defaultIfNull((Object)this.key, (Object)key);
        AtomicInteger count = this.messageToCount.computeIfAbsent(resolvedKey, ignored -> new AtomicInteger());
        if (count.incrementAndGet() >= limit) {
            count.set(0);
            consumer.accept(this.logger);
        }
    }

    private void log(String key, long duration, TimeUnit unit, Consumer<Logger> consumer) {
        String resolvedKey;
        long endTime;
        long currentTime = Instant.now().toEpochMilli();
        if (currentTime >= (endTime = this.messageToWait.computeIfAbsent(resolvedKey = (String)ObjectUtils.defaultIfNull((Object)this.key, (Object)key), ignored -> ConditionalLogger.calculateEndTime((long)duration, (TimeUnit)unit)).longValue())) {
            this.messageToWait.replace(resolvedKey, endTime, ConditionalLogger.calculateEndTime((long)duration, (TimeUnit)unit));
            consumer.accept(this.logger);
        }
    }

    private static long calculateEndTime(long duration, TimeUnit unit) {
        long durationInMillis = unit.toMillis(duration);
        return Instant.now().plusMillis(durationInMillis).toEpochMilli();
    }
}

