/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.hooks.execution;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.response.BidResponse;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.time.Clock;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.BidderRequest;
import org.prebid.server.auction.model.BidderResponse;
import org.prebid.server.execution.Timeout;
import org.prebid.server.execution.TimeoutFactory;
import org.prebid.server.hooks.execution.HookCatalog;
import org.prebid.server.hooks.execution.InvocationContextProvider;
import org.prebid.server.hooks.execution.StageExecutor;
import org.prebid.server.hooks.execution.model.EndpointExecutionPlan;
import org.prebid.server.hooks.execution.model.ExecutionGroup;
import org.prebid.server.hooks.execution.model.ExecutionPlan;
import org.prebid.server.hooks.execution.model.HookExecutionContext;
import org.prebid.server.hooks.execution.model.HookId;
import org.prebid.server.hooks.execution.model.HookStageExecutionResult;
import org.prebid.server.hooks.execution.model.Stage;
import org.prebid.server.hooks.execution.model.StageExecutionPlan;
import org.prebid.server.hooks.execution.model.StageWithHookType;
import org.prebid.server.hooks.execution.v1.InvocationContextImpl;
import org.prebid.server.hooks.execution.v1.auction.AuctionInvocationContextImpl;
import org.prebid.server.hooks.execution.v1.auction.AuctionRequestPayloadImpl;
import org.prebid.server.hooks.execution.v1.auction.AuctionResponsePayloadImpl;
import org.prebid.server.hooks.execution.v1.bidder.AllProcessedBidResponsesPayloadImpl;
import org.prebid.server.hooks.execution.v1.bidder.BidderInvocationContextImpl;
import org.prebid.server.hooks.execution.v1.bidder.BidderRequestPayloadImpl;
import org.prebid.server.hooks.execution.v1.bidder.BidderResponsePayloadImpl;
import org.prebid.server.hooks.execution.v1.entrypoint.EntrypointPayloadImpl;
import org.prebid.server.hooks.v1.Hook;
import org.prebid.server.hooks.v1.InvocationContext;
import org.prebid.server.hooks.v1.auction.AuctionInvocationContext;
import org.prebid.server.hooks.v1.auction.AuctionRequestPayload;
import org.prebid.server.hooks.v1.auction.AuctionResponsePayload;
import org.prebid.server.hooks.v1.bidder.AllProcessedBidResponsesPayload;
import org.prebid.server.hooks.v1.bidder.BidderInvocationContext;
import org.prebid.server.hooks.v1.bidder.BidderRequestPayload;
import org.prebid.server.hooks.v1.bidder.BidderResponsePayload;
import org.prebid.server.hooks.v1.entrypoint.EntrypointPayload;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.model.CaseInsensitiveMultiMap;
import org.prebid.server.model.Endpoint;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountHooksConfiguration;

/*
 * Exception performing whole class analysis ignored.
 */
public class HookStageExecutor {
    private static final String ENTITY_HTTP_REQUEST = "http-request";
    private static final String ENTITY_AUCTION_REQUEST = "auction-request";
    private static final String ENTITY_AUCTION_RESPONSE = "auction-response";
    private static final String ENTITY_ALL_PROCESSED_BID_RESPONSES = "all-processed-bid-responses";
    private static final Account EMPTY_ACCOUNT = Account.empty((String)"");
    private final ExecutionPlan hostExecutionPlan;
    private final ExecutionPlan defaultAccountExecutionPlan;
    private final HookCatalog hookCatalog;
    private final TimeoutFactory timeoutFactory;
    private final Vertx vertx;
    private final Clock clock;

    private HookStageExecutor(ExecutionPlan hostExecutionPlan, ExecutionPlan defaultAccountExecutionPlan, HookCatalog hookCatalog, TimeoutFactory timeoutFactory, Vertx vertx, Clock clock) {
        this.hostExecutionPlan = hostExecutionPlan;
        this.defaultAccountExecutionPlan = defaultAccountExecutionPlan;
        this.hookCatalog = hookCatalog;
        this.timeoutFactory = timeoutFactory;
        this.vertx = vertx;
        this.clock = clock;
    }

    public static HookStageExecutor create(String hostExecutionPlan, String defaultAccountExecutionPlan, HookCatalog hookCatalog, TimeoutFactory timeoutFactory, Vertx vertx, Clock clock, JacksonMapper mapper) {
        return new HookStageExecutor(HookStageExecutor.parseAndValidateExecutionPlan((String)hostExecutionPlan, (JacksonMapper)Objects.requireNonNull(mapper), (HookCatalog)Objects.requireNonNull(hookCatalog)), HookStageExecutor.parseAndValidateExecutionPlan((String)defaultAccountExecutionPlan, (JacksonMapper)mapper, (HookCatalog)hookCatalog), hookCatalog, Objects.requireNonNull(timeoutFactory), Objects.requireNonNull(vertx), Objects.requireNonNull(clock));
    }

    public Future<HookStageExecutionResult<EntrypointPayload>> executeEntrypointStage(CaseInsensitiveMultiMap queryParams, CaseInsensitiveMultiMap headers, String body, HookExecutionContext context) {
        Endpoint endpoint = context.getEndpoint();
        return this.stageExecutor(StageWithHookType.ENTRYPOINT, "http-request", context).withExecutionPlan(this.planForEntrypointStage(endpoint)).withInitialPayload((Object)EntrypointPayloadImpl.of((CaseInsensitiveMultiMap)queryParams, (CaseInsensitiveMultiMap)headers, (String)body)).withInvocationContextProvider(this.invocationContextProvider(endpoint)).withRejectAllowed(true).execute();
    }

    public Future<HookStageExecutionResult<AuctionRequestPayload>> executeRawAuctionRequestStage(AuctionContext auctionContext) {
        BidRequest bidRequest = auctionContext.getBidRequest();
        Account account = auctionContext.getAccount();
        HookExecutionContext context = auctionContext.getHookExecutionContext();
        Endpoint endpoint = context.getEndpoint();
        return this.stageExecutor(StageWithHookType.RAW_AUCTION_REQUEST, "auction-request", context, account, endpoint).withInitialPayload((Object)AuctionRequestPayloadImpl.of((BidRequest)bidRequest)).withInvocationContextProvider(this.auctionInvocationContextProvider(endpoint, auctionContext)).withRejectAllowed(true).execute();
    }

    public Future<HookStageExecutionResult<AuctionRequestPayload>> executeProcessedAuctionRequestStage(AuctionContext auctionContext) {
        BidRequest bidRequest = auctionContext.getBidRequest();
        Account account = auctionContext.getAccount();
        HookExecutionContext context = auctionContext.getHookExecutionContext();
        Endpoint endpoint = context.getEndpoint();
        return this.stageExecutor(StageWithHookType.PROCESSED_AUCTION_REQUEST, "auction-request", context, account, endpoint).withInitialPayload((Object)AuctionRequestPayloadImpl.of((BidRequest)bidRequest)).withInvocationContextProvider(this.auctionInvocationContextProvider(endpoint, auctionContext)).withRejectAllowed(true).execute();
    }

    public Future<HookStageExecutionResult<BidderRequestPayload>> executeBidderRequestStage(BidderRequest bidderRequest, AuctionContext auctionContext) {
        Account account = auctionContext.getAccount();
        HookExecutionContext context = auctionContext.getHookExecutionContext();
        String bidder = bidderRequest.getBidder();
        Endpoint endpoint = context.getEndpoint();
        return this.stageExecutor(StageWithHookType.BIDDER_REQUEST, bidder, context, account, endpoint).withInitialPayload((Object)BidderRequestPayloadImpl.of((BidRequest)bidderRequest.getBidRequest())).withInvocationContextProvider(this.bidderInvocationContextProvider(endpoint, auctionContext, bidder)).withRejectAllowed(true).execute();
    }

    public Future<HookStageExecutionResult<BidderResponsePayload>> executeRawBidderResponseStage(BidderResponse bidderResponse, AuctionContext auctionContext) {
        Account account = auctionContext.getAccount();
        HookExecutionContext context = auctionContext.getHookExecutionContext();
        List bids = bidderResponse.getSeatBid().getBids();
        String bidder = bidderResponse.getBidder();
        Endpoint endpoint = context.getEndpoint();
        return this.stageExecutor(StageWithHookType.RAW_BIDDER_RESPONSE, bidder, context, account, endpoint).withInitialPayload((Object)BidderResponsePayloadImpl.of((List)bids)).withInvocationContextProvider(this.bidderInvocationContextProvider(endpoint, auctionContext, bidder)).withRejectAllowed(true).execute();
    }

    public Future<HookStageExecutionResult<BidderResponsePayload>> executeProcessedBidderResponseStage(BidderResponse bidderResponse, AuctionContext auctionContext) {
        Account account = auctionContext.getAccount();
        HookExecutionContext context = auctionContext.getHookExecutionContext();
        List bids = bidderResponse.getSeatBid().getBids();
        String bidder = bidderResponse.getBidder();
        Endpoint endpoint = context.getEndpoint();
        return this.stageExecutor(StageWithHookType.PROCESSED_BIDDER_RESPONSE, bidder, context, account, endpoint).withInitialPayload((Object)BidderResponsePayloadImpl.of((List)bids)).withInvocationContextProvider(this.bidderInvocationContextProvider(endpoint, auctionContext, bidder)).withRejectAllowed(true).execute();
    }

    public Future<HookStageExecutionResult<AllProcessedBidResponsesPayload>> executeAllProcessedBidResponsesStage(List<BidderResponse> bidderResponses, AuctionContext auctionContext) {
        Account account = auctionContext.getAccount();
        HookExecutionContext context = auctionContext.getHookExecutionContext();
        Endpoint endpoint = context.getEndpoint();
        return this.stageExecutor(StageWithHookType.ALL_PROCESSED_BID_RESPONSES, "all-processed-bid-responses", context, account, endpoint).withInitialPayload((Object)AllProcessedBidResponsesPayloadImpl.of(bidderResponses)).withInvocationContextProvider(this.auctionInvocationContextProvider(endpoint, auctionContext)).withRejectAllowed(false).execute();
    }

    public Future<HookStageExecutionResult<AuctionResponsePayload>> executeAuctionResponseStage(BidResponse bidResponse, AuctionContext auctionContext) {
        Account account = (Account)ObjectUtils.defaultIfNull((Object)auctionContext.getAccount(), (Object)EMPTY_ACCOUNT);
        HookExecutionContext context = auctionContext.getHookExecutionContext();
        Endpoint endpoint = context.getEndpoint();
        return this.stageExecutor(StageWithHookType.AUCTION_RESPONSE, "auction-response", context, account, endpoint).withInitialPayload((Object)AuctionResponsePayloadImpl.of((BidResponse)bidResponse)).withInvocationContextProvider(this.auctionInvocationContextProvider(endpoint, auctionContext)).withRejectAllowed(false).execute();
    }

    private <PAYLOAD, CONTEXT extends InvocationContext> StageExecutor<PAYLOAD, CONTEXT> stageExecutor(StageWithHookType<? extends Hook<PAYLOAD, CONTEXT>> stage, String entity, HookExecutionContext context) {
        return StageExecutor.create((HookCatalog)this.hookCatalog, (Vertx)this.vertx, (Clock)this.clock).withStage(stage).withEntity(entity).withHookExecutionContext(context);
    }

    private <PAYLOAD, CONTEXT extends InvocationContext> StageExecutor<PAYLOAD, CONTEXT> stageExecutor(StageWithHookType<? extends Hook<PAYLOAD, CONTEXT>> stage, String entity, HookExecutionContext context, Account account, Endpoint endpoint) {
        return this.stageExecutor(stage, entity, context).withExecutionPlan(this.planForStage(account, endpoint, stage.stage()));
    }

    private static ExecutionPlan parseAndValidateExecutionPlan(String executionPlan, JacksonMapper mapper, HookCatalog hookCatalog) {
        return HookStageExecutor.validateExecutionPlan((ExecutionPlan)HookStageExecutor.parseExecutionPlan((String)executionPlan, (JacksonMapper)mapper), (HookCatalog)hookCatalog);
    }

    private static ExecutionPlan validateExecutionPlan(ExecutionPlan plan, HookCatalog hookCatalog) {
        plan.getEndpoints().values().stream().map(EndpointExecutionPlan::getStages).map(Map::entrySet).flatMap(Collection::stream).forEach(stageToPlan -> ((StageExecutionPlan)stageToPlan.getValue()).getGroups().stream().map(ExecutionGroup::getHookSequence).flatMap(Collection::stream).forEach(hookId -> HookStageExecutor.validateHookId((Stage)((Stage)stageToPlan.getKey()), (HookId)hookId, (HookCatalog)hookCatalog)));
        return plan;
    }

    private static void validateHookId(Stage stage, HookId hookId, HookCatalog hookCatalog) {
        Hook hook = hookCatalog.hookById(hookId.getModuleCode(), hookId.getHookImplCode(), StageWithHookType.forStage((Stage)stage));
        if (hook == null) {
            throw new IllegalArgumentException("Hooks execution plan contains unknown or disabled hook: stage=%s, hookId=%s".formatted(stage, hookId));
        }
    }

    private static ExecutionPlan parseExecutionPlan(String executionPlan, JacksonMapper mapper) {
        if (StringUtils.isBlank((CharSequence)executionPlan)) {
            return ExecutionPlan.empty();
        }
        try {
            return (ExecutionPlan)mapper.decodeValue(executionPlan, ExecutionPlan.class);
        }
        catch (DecodeException e) {
            throw new IllegalArgumentException("Hooks execution plan could not be parsed", e);
        }
    }

    private StageExecutionPlan planForEntrypointStage(Endpoint endpoint) {
        return this.effectiveStagePlanFrom(ExecutionPlan.empty(), endpoint, Stage.entrypoint);
    }

    private StageExecutionPlan planForStage(Account account, Endpoint endpoint, Stage stage) {
        return this.effectiveStagePlanFrom(this.effectiveExecutionPlanFor(account), endpoint, stage);
    }

    private StageExecutionPlan effectiveStagePlanFrom(ExecutionPlan accountExecutionPlan, Endpoint endpoint, Stage stage) {
        StageExecutionPlan hostStageExecutionPlan = HookStageExecutor.stagePlanFrom((ExecutionPlan)this.hostExecutionPlan, (Endpoint)endpoint, (Stage)stage);
        StageExecutionPlan accountStageExecutionPlan = HookStageExecutor.stagePlanFrom((ExecutionPlan)accountExecutionPlan, (Endpoint)endpoint, (Stage)stage);
        if (hostStageExecutionPlan.isEmpty()) {
            return accountStageExecutionPlan;
        }
        if (accountStageExecutionPlan.isEmpty()) {
            return hostStageExecutionPlan;
        }
        List combinedGroups = Stream.of(hostStageExecutionPlan, accountStageExecutionPlan).map(StageExecutionPlan::getGroups).flatMap(Collection::stream).toList();
        return StageExecutionPlan.of(combinedGroups);
    }

    private static StageExecutionPlan stagePlanFrom(ExecutionPlan executionPlan, Endpoint endpoint, Stage stage) {
        return executionPlan.getEndpoints().getOrDefault(endpoint, EndpointExecutionPlan.empty()).getStages().getOrDefault(stage, StageExecutionPlan.empty());
    }

    private ExecutionPlan effectiveExecutionPlanFor(Account account) {
        AccountHooksConfiguration hooksAccountConfig = account.getHooks();
        ExecutionPlan accountExecutionPlan = hooksAccountConfig != null ? hooksAccountConfig.getExecutionPlan() : null;
        return accountExecutionPlan != null ? accountExecutionPlan : this.defaultAccountExecutionPlan;
    }

    private InvocationContextProvider<InvocationContext> invocationContextProvider(Endpoint endpoint) {
        return (timeout, hookId, moduleContext) -> this.invocationContext(endpoint, timeout);
    }

    private InvocationContextImpl invocationContext(Endpoint endpoint, Long timeout) {
        return InvocationContextImpl.of((Timeout)this.createTimeout(timeout), (Endpoint)endpoint);
    }

    private InvocationContextProvider<AuctionInvocationContext> auctionInvocationContextProvider(Endpoint endpoint, AuctionContext auctionContext) {
        return (timeout, hookId, moduleContext) -> this.auctionInvocationContext(endpoint, timeout, auctionContext, hookId, moduleContext);
    }

    private AuctionInvocationContextImpl auctionInvocationContext(Endpoint endpoint, Long timeout, AuctionContext auctionContext, HookId hookId, Object moduleContext) {
        return AuctionInvocationContextImpl.of((InvocationContext)this.invocationContext(endpoint, timeout), (AuctionContext)auctionContext, (boolean)auctionContext.getDebugContext().isDebugEnabled(), (ObjectNode)HookStageExecutor.accountConfigFor((Account)auctionContext.getAccount(), (HookId)hookId), (Object)moduleContext);
    }

    private InvocationContextProvider<BidderInvocationContext> bidderInvocationContextProvider(Endpoint endpoint, AuctionContext auctionContext, String bidder) {
        return (timeout, hookId, moduleContext) -> BidderInvocationContextImpl.of((AuctionInvocationContext)this.auctionInvocationContext(endpoint, timeout, auctionContext, hookId, moduleContext), (String)bidder);
    }

    private Timeout createTimeout(Long timeout) {
        return this.timeoutFactory.create(timeout.longValue());
    }

    private static ObjectNode accountConfigFor(Account account, HookId hookId) {
        AccountHooksConfiguration accountHooksConfiguration = account.getHooks();
        Map modulesConfiguration = accountHooksConfiguration != null ? accountHooksConfiguration.getModules() : Collections.emptyMap();
        return modulesConfiguration != null ? (ObjectNode)modulesConfiguration.get(hookId.getModuleCode()) : null;
    }
}

