/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler.info;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.bidder.BidderInfo;
import org.prebid.server.handler.info.BidderDetailsHandler;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.model.Endpoint;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class BidderDetailsHandler
implements Handler<RoutingContext> {
    private static final String BIDDER_NAME_PARAM = "bidderName";
    private static final String ALL_PARAM_VALUE = "all";
    private final JacksonMapper mapper;
    private final Map<String, String> bidderInfos;

    public BidderDetailsHandler(BidderCatalog bidderCatalog, JacksonMapper mapper) {
        BidderDetailsHandler.validateAliases((BidderCatalog)Objects.requireNonNull(bidderCatalog));
        this.mapper = Objects.requireNonNull(mapper);
        this.bidderInfos = this.createBidderInfos(bidderCatalog);
    }

    private static void validateAliases(BidderCatalog bidderCatalog) {
        if (bidderCatalog.names().contains("all")) {
            throw new IllegalArgumentException("There is '%s' bidder or alias configured which is unacceptable.".formatted("all"));
        }
    }

    private Map<String, String> createBidderInfos(BidderCatalog bidderCatalog) {
        Map nameToInfo = bidderCatalog.names().stream().collect(Collectors.toMap(Function.identity(), name -> this.bidderNode(bidderCatalog, name)));
        Map<String, ObjectNode> allToInfos = Collections.singletonMap("all", this.allInfos(nameToInfo));
        return (Map)Stream.of(nameToInfo, allToInfos).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, map -> this.mapper.encodeToString((Object)((ObjectNode)map.getValue())), (first, second) -> second, CaseInsensitiveMap::new));
    }

    private ObjectNode bidderNode(BidderCatalog bidderCatalog, String name) {
        BidderInfo bidderInfo = bidderCatalog.bidderInfoByName(name);
        return (ObjectNode)this.mapper.mapper().valueToTree((Object)BidderInfoResponseModel.from((BidderInfo)bidderInfo));
    }

    private ObjectNode allInfos(Map<String, ObjectNode> nameToInfo) {
        return (ObjectNode)this.mapper.mapper().valueToTree(new TreeMap<String, ObjectNode>(nameToInfo));
    }

    public void handle(RoutingContext routingContext) {
        String bidderName = routingContext.request().getParam("bidderName");
        String endpoint = "%s/%s".formatted(Endpoint.info_bidders.value(), bidderName);
        String bidderInfo = (String)this.bidderInfos.get(bidderName);
        if (bidderInfo != null) {
            HttpUtil.executeSafely((RoutingContext)routingContext, (String)endpoint, response -> response.putHeader(HttpUtil.CONTENT_TYPE_HEADER, (CharSequence)HttpHeaderValues.APPLICATION_JSON).end(bidderInfo));
        } else {
            HttpUtil.executeSafely((RoutingContext)routingContext, (String)endpoint, response -> response.setStatusCode(HttpResponseStatus.NOT_FOUND.code()).end());
        }
    }
}

