/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.handler;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.time.ZonedDateTime;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.deals.AlertHttpService;
import org.prebid.server.deals.DeliveryProgressService;
import org.prebid.server.deals.DeliveryStatsService;
import org.prebid.server.deals.LineItemService;
import org.prebid.server.deals.PlannerService;
import org.prebid.server.deals.RegisterService;
import org.prebid.server.exception.InvalidRequestException;
import org.prebid.server.handler.ForceDealsUpdateHandler;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ForceDealsUpdateHandler
implements Handler<RoutingContext> {
    private static final String ACTION_NAME_PARAM = "action_name";
    private final DeliveryStatsService deliveryStatsService;
    private final PlannerService plannerService;
    private final RegisterService registerService;
    private final AlertHttpService alertHttpService;
    private final DeliveryProgressService deliveryProgressService;
    private final LineItemService lineItemService;
    private final String endpoint;

    public ForceDealsUpdateHandler(DeliveryStatsService deliveryStatsService, PlannerService plannerService, RegisterService registerService, AlertHttpService alertHttpService, DeliveryProgressService deliveryProgressService, LineItemService lineItemService, String endpoint) {
        this.deliveryStatsService = Objects.requireNonNull(deliveryStatsService);
        this.plannerService = Objects.requireNonNull(plannerService);
        this.registerService = Objects.requireNonNull(registerService);
        this.alertHttpService = Objects.requireNonNull(alertHttpService);
        this.deliveryProgressService = Objects.requireNonNull(deliveryProgressService);
        this.lineItemService = Objects.requireNonNull(lineItemService);
        this.endpoint = Objects.requireNonNull(endpoint);
    }

    public void handle(RoutingContext routingContext) {
        try {
            this.handleDealsAction(ForceDealsUpdateHandler.dealsActionFrom((RoutingContext)routingContext));
            HttpUtil.executeSafely((RoutingContext)routingContext, (String)this.endpoint, response -> response.setStatusCode(HttpResponseStatus.NO_CONTENT.code()).end());
        }
        catch (InvalidRequestException e) {
            this.respondWithError(routingContext, HttpResponseStatus.BAD_REQUEST, (Exception)((Object)e));
        }
        catch (Exception e) {
            this.respondWithError(routingContext, HttpResponseStatus.INTERNAL_SERVER_ERROR, e);
        }
    }

    private static DealsAction dealsActionFrom(RoutingContext routingContext) {
        String actionName = routingContext.request().getParam("action_name");
        if (StringUtils.isEmpty((CharSequence)actionName)) {
            throw new InvalidRequestException("Parameter '%s' is required and can't be empty".formatted("action_name"));
        }
        try {
            return DealsAction.valueOf((String)actionName.toUpperCase());
        }
        catch (IllegalArgumentException ignored) {
            throw new InvalidRequestException("Given '%s' parameter value '%s' is not among possible actions".formatted("action_name", actionName));
        }
    }

    private void handleDealsAction(DealsAction dealsAction) {
        switch (1.$SwitchMap$org$prebid$server$handler$ForceDealsUpdateHandler$DealsAction[dealsAction.ordinal()]) {
            case 1: {
                this.plannerService.updateLineItemMetaData();
                break;
            }
            case 2: {
                this.deliveryStatsService.sendDeliveryProgressReports();
                break;
            }
            case 3: {
                this.registerService.performRegistration();
                break;
            }
            case 4: {
                this.alertHttpService.resetAlertCount("pbs-register-client-error");
                this.alertHttpService.resetAlertCount("pbs-planner-client-error");
                this.alertHttpService.resetAlertCount("pbs-planner-empty-response-error");
                this.alertHttpService.resetAlertCount("pbs-delivery-stats-client-error");
                break;
            }
            case 5: {
                this.deliveryProgressService.createDeliveryProgressReports(ZonedDateTime.now());
                break;
            }
            case 6: {
                this.lineItemService.invalidateLineItems();
            }
        }
    }

    private void respondWithError(RoutingContext routingContext, HttpResponseStatus statusCode, Exception exception) {
        HttpUtil.executeSafely((RoutingContext)routingContext, (String)this.endpoint, response -> response.setStatusCode(statusCode.code()).end(exception.getMessage()));
    }
}

