/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.execution;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.CopyOptions;
import io.vertx.core.file.FileProps;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.file.OpenOptions;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.streams.Pump;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.execution.RemoteFileProcessor;
import org.prebid.server.execution.retry.RetryPolicy;
import org.prebid.server.execution.retry.Retryable;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class RemoteFileSyncer {
    private static final Logger logger = LoggerFactory.getLogger(RemoteFileSyncer.class);
    private final String downloadUrl;
    private final String saveFilePath;
    private final String tmpFilePath;
    private final RetryPolicy retryPolicy;
    private final long timeout;
    private final long updatePeriod;
    private final HttpClient httpClient;
    private final Vertx vertx;
    private final FileSystem fileSystem;

    public RemoteFileSyncer(String downloadUrl, String saveFilePath, String tmpFilePath, RetryPolicy retryPolicy, long timeout, long updatePeriod, HttpClient httpClient, Vertx vertx) {
        this.downloadUrl = HttpUtil.validateUrl((String)downloadUrl);
        this.saveFilePath = Objects.requireNonNull(saveFilePath);
        this.tmpFilePath = Objects.requireNonNull(tmpFilePath);
        this.retryPolicy = Objects.requireNonNull(retryPolicy);
        this.timeout = timeout;
        this.updatePeriod = updatePeriod;
        this.httpClient = Objects.requireNonNull(httpClient);
        this.vertx = Objects.requireNonNull(vertx);
        this.fileSystem = vertx.fileSystem();
        RemoteFileSyncer.createAndCheckWritePermissionsFor((FileSystem)this.fileSystem, (String)saveFilePath);
        RemoteFileSyncer.createAndCheckWritePermissionsFor((FileSystem)this.fileSystem, (String)tmpFilePath);
    }

    private static void createAndCheckWritePermissionsFor(FileSystem fileSystem, String filePath) {
        try {
            FileProps props;
            String dirPath = Paths.get(filePath, new String[0]).getParent().toString();
            FileProps fileProps = props = fileSystem.existsBlocking(dirPath) ? fileSystem.propsBlocking(dirPath) : null;
            if (props == null || !props.isDirectory()) {
                fileSystem.mkdirsBlocking(dirPath);
            } else if (!Files.isWritable(Paths.get(dirPath, new String[0]))) {
                throw new PreBidException("No write permissions for directory: " + dirPath);
            }
        }
        catch (FileSystemException | InvalidPathException e) {
            throw new PreBidException("Cannot create directory for file: " + filePath, e);
        }
    }

    public void sync(RemoteFileProcessor processor) {
        this.isFileExists(this.saveFilePath).compose(exists -> exists != false ? this.processSavedFile(processor) : this.syncRemoteFiles(this.retryPolicy)).onComplete(syncResult -> this.handleSync(processor, syncResult));
    }

    private Future<Boolean> isFileExists(String filePath) {
        Promise promise = Promise.promise();
        this.fileSystem.exists(filePath, async -> {
            if (async.succeeded()) {
                promise.complete((Object)((Boolean)async.result()));
            } else {
                promise.fail("Cant check if file exists " + filePath);
            }
        });
        return promise.future();
    }

    private Future<Boolean> processSavedFile(RemoteFileProcessor processor) {
        return processor.setDataPath(this.saveFilePath).map((Object)false).recover(ignored -> this.removeCorruptedSaveFile());
    }

    private Future<Boolean> removeCorruptedSaveFile() {
        return this.deleteFileIfExists(this.saveFilePath).compose(ignored -> this.syncRemoteFiles(this.retryPolicy)).recover(error -> Future.failedFuture((Throwable)new PreBidException("Corrupted file %s can't be deleted. Please check permission or delete manually.".formatted(this.saveFilePath), error)));
    }

    private Future<Boolean> syncRemoteFiles(RetryPolicy retryPolicy) {
        return this.deleteFileIfExists(this.tmpFilePath).compose(ignored -> this.downloadToTempFile()).recover(error -> this.retrySync(retryPolicy)).compose(downloadResult -> this.swapFiles()).map((Object)true);
    }

    private Future<Void> deleteFileIfExists(String filePath) {
        return this.isFileExists(filePath).compose(exists -> exists != false ? this.deleteFile(filePath) : Future.succeededFuture());
    }

    private Future<Void> deleteFile(String filePath) {
        Promise promise = Promise.promise();
        this.fileSystem.delete(filePath, (Handler)promise);
        return promise.future();
    }

    private Future<Void> downloadToTempFile() {
        return this.openFile(this.tmpFilePath).compose(tmpFile -> this.requestData().compose(response -> this.pumpToFile(response, tmpFile)));
    }

    private Future<HttpClientResponse> requestData() {
        Promise promise = Promise.promise();
        this.httpClient.getAbs(this.downloadUrl, arg_0 -> ((Promise)promise).complete(arg_0)).end();
        return promise.future();
    }

    private Future<Void> retrySync(RetryPolicy retryPolicy) {
        if (retryPolicy instanceof Retryable) {
            Retryable policy = (Retryable)retryPolicy;
            logger.info((Object)"Retrying file download from {0} with policy: {1}", new Object[]{this.downloadUrl, retryPolicy});
            Promise promise = Promise.promise();
            this.vertx.setTimer(policy.delay(), timerId -> this.syncRemoteFiles(policy.next()).onFailure(arg_0 -> ((Promise)promise).fail(arg_0)).onSuccess(ignored -> promise.complete()));
            return promise.future();
        }
        return Future.failedFuture((Throwable)new PreBidException("File sync failed"));
    }

    private Future<AsyncFile> openFile(String path) {
        Promise promise = Promise.promise();
        this.fileSystem.open(path, new OpenOptions().setCreateNew(true), (Handler)promise);
        return promise.future();
    }

    private Future<Void> pumpToFile(HttpClientResponse httpClientResponse, AsyncFile asyncFile) {
        Promise promise = Promise.promise();
        logger.info((Object)"Trying to download file from {0}", new Object[]{this.downloadUrl});
        httpClientResponse.pause();
        Pump pump = Pump.pump((ReadStream)httpClientResponse, (WriteStream)asyncFile);
        pump.start();
        httpClientResponse.resume();
        long timeoutTimerId = this.setTimeoutTimer(asyncFile, pump, promise);
        httpClientResponse.endHandler(responseEndResult -> this.handleResponseEnd(asyncFile, timeoutTimerId, promise));
        return promise.future();
    }

    private long setTimeoutTimer(AsyncFile asyncFile, Pump pump, Promise<Void> promise) {
        return this.vertx.setTimer(this.timeout, timerId -> this.handleTimeout(asyncFile, pump, promise));
    }

    private void handleTimeout(AsyncFile asyncFile, Pump pump, Promise<Void> promise) {
        pump.stop();
        asyncFile.close();
        if (!promise.future().isComplete()) {
            promise.fail((Throwable)new TimeoutException("Timeout on download"));
        }
    }

    private void handleResponseEnd(AsyncFile asyncFile, long idTimer, Promise<Void> promise) {
        this.vertx.cancelTimer(idTimer);
        asyncFile.flush().close(promise);
    }

    private Future<Void> swapFiles() {
        Promise promise = Promise.promise();
        logger.info((Object)"Sync {0} to {1}", new Object[]{this.tmpFilePath, this.saveFilePath});
        CopyOptions copyOptions = new CopyOptions().setReplaceExisting(true);
        this.fileSystem.move(this.tmpFilePath, this.saveFilePath, copyOptions, (Handler)promise);
        return promise.future();
    }

    private void handleSync(RemoteFileProcessor remoteFileProcessor, AsyncResult<Boolean> syncResult) {
        if (syncResult.succeeded()) {
            if (((Boolean)syncResult.result()).booleanValue()) {
                logger.info((Object)"Sync service for {0}", new Object[]{this.saveFilePath});
                remoteFileProcessor.setDataPath(this.saveFilePath).onComplete(arg_0 -> this.logFileProcessStatus(arg_0));
            } else {
                logger.info((Object)"Sync is not required for {0}", new Object[]{this.saveFilePath});
            }
        } else {
            logger.error((Object)"Cant sync file from {0}", syncResult.cause(), new Object[]{this.downloadUrl});
        }
        if (this.updatePeriod > 0L) {
            this.vertx.setTimer(this.updatePeriod, idUpdateNew -> this.configureAutoUpdates(remoteFileProcessor));
        }
    }

    private void logFileProcessStatus(AsyncResult<?> serviceRespond) {
        if (serviceRespond.succeeded()) {
            logger.info((Object)"Service successfully received file {0}.", new Object[]{this.saveFilePath});
        } else {
            logger.error((Object)"Service cant process file {0} and still unavailable.", new Object[]{this.saveFilePath});
        }
    }

    private void configureAutoUpdates(RemoteFileProcessor remoteFileProcessor) {
        logger.info((Object)"Check for updated for {0}", new Object[]{this.saveFilePath});
        this.tryUpdate().onComplete(asyncUpdate -> {
            if (asyncUpdate.failed()) {
                logger.warn((Object)"File {0} update failed", asyncUpdate.cause(), new Object[]{this.saveFilePath});
            }
            this.handleSync(remoteFileProcessor, asyncUpdate);
        });
    }

    private Future<Boolean> tryUpdate() {
        return this.isFileExists(this.saveFilePath).compose(fileExists -> fileExists != false ? this.isUpdateRequired() : Future.succeededFuture((Object)true)).compose(needUpdate -> needUpdate != false ? this.syncRemoteFiles(this.retryPolicy) : Future.succeededFuture((Object)false));
    }

    private Future<Boolean> isUpdateRequired() {
        Promise isUpdateRequired = Promise.promise();
        this.httpClient.headAbs(this.downloadUrl, response -> this.checkNewVersion(response, isUpdateRequired)).exceptionHandler(arg_0 -> ((Promise)isUpdateRequired).fail(arg_0)).end();
        return isUpdateRequired.future();
    }

    private void checkNewVersion(HttpClientResponse response, Promise<Boolean> isUpdateRequired) {
        String contentLengthParameter = response.getHeader(HttpHeaders.CONTENT_LENGTH);
        if (StringUtils.isNumeric((CharSequence)contentLengthParameter) && !contentLengthParameter.equals("0")) {
            long contentLength = Long.parseLong(contentLengthParameter);
            this.fileSystem.props(this.saveFilePath, filePropsResult -> {
                if (filePropsResult.succeeded()) {
                    logger.info((Object)"Prev length = {0}, new length = {1}", new Object[]{((FileProps)filePropsResult.result()).size(), contentLength});
                    isUpdateRequired.complete((Object)(((FileProps)filePropsResult.result()).size() != contentLength ? 1 : 0));
                } else {
                    isUpdateRequired.fail(filePropsResult.cause());
                }
            });
        } else {
            isUpdateRequired.fail("ContentLength is invalid: " + contentLengthParameter);
        }
    }
}

