/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.targeting.syntax;

import java.util.EnumSet;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.deals.targeting.syntax.TargetingCategory;
import org.prebid.server.exception.TargetingSyntaxException;

/*
 * Exception performing whole class analysis ignored.
 */
public class TargetingCategory {
    private static final String BIDDER_PARAM_PATH_PATTERN = "\\w+(\\.\\w+)+";
    private static final EnumSet<Type> DYNAMIC_TYPES = EnumSet.of(Type.deviceGeoExt, new Type[]{Type.deviceExt, Type.bidderParam, Type.userSegment, Type.userFirstPartyData, Type.siteFirstPartyData});
    private static final EnumSet<Type> STATIC_TYPES = EnumSet.complementOf(DYNAMIC_TYPES);
    private final Type type;
    private final String path;

    public TargetingCategory(Type type) {
        this(type, null);
    }

    public TargetingCategory(Type type, String path) {
        this.type = Objects.requireNonNull(type);
        this.path = path;
    }

    public static boolean isTargetingCategory(String candidate) {
        boolean isSimpleCategory = STATIC_TYPES.stream().anyMatch(op -> op.attribute().equals(candidate));
        return isSimpleCategory || DYNAMIC_TYPES.stream().anyMatch(op -> candidate.startsWith(op.attribute()));
    }

    public static TargetingCategory fromString(String candidate) {
        for (Type type : STATIC_TYPES) {
            if (!type.attribute().equals(candidate)) continue;
            return new TargetingCategory(type);
        }
        for (Type type : DYNAMIC_TYPES) {
            if (!candidate.startsWith(type.attribute())) continue;
            return TargetingCategory.parseDynamicCategory((String)candidate, (Type)type);
        }
        throw new IllegalArgumentException("Unrecognized targeting category: " + candidate);
    }

    private static TargetingCategory parseDynamicCategory(String candidate, Type type) {
        return switch (1.$SwitchMap$org$prebid$server$deals$targeting$syntax$TargetingCategory$Type[type.ordinal()]) {
            case 1, 2, 3, 4, 5 -> TargetingCategory.parseByTypeAttribute((String)candidate, (Type)type);
            case 6 -> TargetingCategory.parseBidderParam((String)candidate, (Type)type);
            default -> throw new IllegalStateException("Unexpected dynamic targeting category type " + type);
        };
    }

    private static TargetingCategory parseByTypeAttribute(String candidate, Type type) {
        String candidatePath = StringUtils.substringAfter((String)candidate, (String)type.attribute());
        return new TargetingCategory(type, candidatePath);
    }

    private static TargetingCategory parseBidderParam(String candidate, Type type) {
        String candidatePath = StringUtils.substringAfter((String)candidate, (String)type.attribute());
        if (candidatePath.matches("\\w+(\\.\\w+)+")) {
            return new TargetingCategory(type, TargetingCategory.dropBidderName((String)candidatePath));
        }
        throw new TargetingSyntaxException("BidderParam path is incorrect: " + candidatePath);
    }

    private static String dropBidderName(String path) {
        int index = path.indexOf(46);
        return path.substring(index + 1);
    }

    public Type type() {
        return this.type;
    }

    public String path() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TargetingCategory)) {
            return false;
        }
        TargetingCategory other = (TargetingCategory)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Type this$type = this.type;
        Type other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$path = this.path;
        String other$path = other.path;
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TargetingCategory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $type = this.type;
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $path = this.path;
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }
}

