/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.model;

import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.prebid.server.proto.openrtb.ext.response.ExtTraceDeal;

public class DeepDebugLog {
    private final boolean deepDebugEnabled;
    private final List<ExtTraceDeal> entries;
    private final Clock clock;

    private DeepDebugLog(boolean deepDebugEnabled, Clock clock) {
        this.deepDebugEnabled = deepDebugEnabled;
        this.entries = deepDebugEnabled ? new LinkedList() : null;
        this.clock = Objects.requireNonNull(clock);
    }

    public static DeepDebugLog create(boolean deepDebugEnabled, Clock clock) {
        return new DeepDebugLog(deepDebugEnabled, clock);
    }

    public void add(String lineItemId, ExtTraceDeal.Category category, Supplier<String> messageSupplier) {
        if (this.deepDebugEnabled) {
            this.entries.add(ExtTraceDeal.of((String)lineItemId, (ZonedDateTime)ZonedDateTime.now(this.clock), (ExtTraceDeal.Category)category, (String)messageSupplier.get()));
        }
    }

    public boolean isDeepDebugEnabled() {
        return this.deepDebugEnabled;
    }

    public List<ExtTraceDeal> entries() {
        return this.entries == null ? Collections.emptyList() : Collections.unmodifiableList(this.entries);
    }
}

