/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.lineitem;

import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.prebid.server.deals.LineItemService;
import org.prebid.server.deals.lineitem.DeliveryPlan;
import org.prebid.server.deals.lineitem.LineItem;
import org.prebid.server.deals.lineitem.LineItemStatus;
import org.prebid.server.deals.lineitem.LostToLineItem;
import org.prebid.server.deals.model.TxnLog;
import org.prebid.server.deals.proto.report.Event;

/*
 * Exception performing whole class analysis ignored.
 */
public class DeliveryProgress {
    private static final String WIN_EVENT_TYPE = "win";
    private final Map<String, LineItemStatus> lineItemStatuses;
    private final Map<String, LongAdder> requestsPerAccount;
    private final Map<String, Map<String, LostToLineItem>> lineItemIdToLost;
    private final LongAdder requests;
    private ZonedDateTime startTimeStamp;
    private ZonedDateTime endTimeStamp;
    private final LineItemService lineItemService;

    private DeliveryProgress(ZonedDateTime startTimeStamp, LineItemService lineItemService) {
        this.startTimeStamp = Objects.requireNonNull(startTimeStamp);
        this.lineItemStatuses = new ConcurrentHashMap();
        this.requests = new LongAdder();
        this.requestsPerAccount = new ConcurrentHashMap();
        this.lineItemIdToLost = new ConcurrentHashMap();
        this.lineItemService = Objects.requireNonNull(lineItemService);
    }

    public static DeliveryProgress of(ZonedDateTime startTimeStamp, LineItemService lineItemService) {
        return new DeliveryProgress(startTimeStamp, lineItemService);
    }

    public DeliveryProgress copyWithOriginalPlans() {
        DeliveryProgress progress = DeliveryProgress.of((ZonedDateTime)this.getStartTimeStamp(), (LineItemService)this.lineItemService);
        for (LineItemStatus originalStatus : this.lineItemStatuses.values()) {
            progress.lineItemStatuses.put(originalStatus.getLineItemId(), this.createStatusWithPlans(originalStatus));
        }
        progress.mergeFrom(this);
        return progress;
    }

    private LineItemStatus createStatusWithPlans(LineItemStatus originalStatus) {
        LineItemStatus status = this.createLineItemStatus(originalStatus.getLineItemId());
        status.getDeliveryPlans().addAll(originalStatus.getDeliveryPlans());
        return status;
    }

    public void recordTransactionLog(TxnLog txnLog, Map<String, Integer> planIdToTokenPriority, String accountId) {
        this.accountRequests(accountId).increment();
        this.requests.increment();
        txnLog.lineItemSentToClientAsTopMatch().forEach(lineItemId -> this.increment(lineItemId, LineItemStatus::incSentToClientAsTopMatch));
        txnLog.lineItemsSentToClient().forEach(lineItemId -> this.increment(lineItemId, LineItemStatus::incSentToClient));
        txnLog.lineItemsMatchedDomainTargeting().forEach(lineItemId -> this.increment(lineItemId, LineItemStatus::incDomainMatched));
        txnLog.lineItemsMatchedWholeTargeting().forEach(lineItemId -> this.increment(lineItemId, LineItemStatus::incTargetMatched));
        txnLog.lineItemsMatchedTargetingFcapped().forEach(lineItemId -> this.increment(lineItemId, LineItemStatus::incTargetMatchedButFcapped));
        txnLog.lineItemsMatchedTargetingFcapLookupFailed().forEach(lineItemId -> this.increment(lineItemId, LineItemStatus::incTargetMatchedButFcapLookupFailed));
        txnLog.lineItemsPacingDeferred().forEach(lineItemId -> this.increment(lineItemId, LineItemStatus::incPacingDeferred));
        txnLog.lineItemsSentToBidder().values().forEach(idList -> idList.forEach(lineItemId -> this.increment(lineItemId, LineItemStatus::incSentToBidder)));
        txnLog.lineItemsSentToBidderAsTopMatch().values().forEach(bidderList -> bidderList.forEach(lineItemId -> this.increment(lineItemId, LineItemStatus::incSentToBidderAsTopMatch)));
        txnLog.lineItemsReceivedFromBidder().values().forEach(idList -> idList.forEach(lineItemId -> this.increment(lineItemId, LineItemStatus::incReceivedFromBidder)));
        txnLog.lineItemsResponseInvalidated().forEach(lineItemId -> this.increment(lineItemId, LineItemStatus::incReceivedFromBidderInvalidated));
        txnLog.lineItemSentToClientAsTopMatch().forEach(lineItemId -> this.incToken(lineItemId, planIdToTokenPriority));
        txnLog.lostMatchingToLineItems().forEach((lineItemId, lostToLineItemsIds) -> this.updateLostToEachLineItem(lineItemId, lostToLineItemsIds, this.lineItemIdToLost));
        txnLog.lostAuctionToLineItems().forEach((lineItemId, lostToLineItemsIds) -> this.updateLostToEachLineItem(lineItemId, lostToLineItemsIds, this.lineItemIdToLost));
    }

    public void recordWinEvent(String lineItemId) {
        LineItemStatus lineItemStatus = this.lineItemStatuses.computeIfAbsent(lineItemId, arg_0 -> this.createLineItemStatus(arg_0));
        Event winEvent = lineItemStatus.getEvents().stream().filter(event -> event.getType().equals("win")).findAny().orElseGet(() -> Event.of((String)"win", (LongAdder)new LongAdder()));
        winEvent.getCount().increment();
        lineItemStatus.getEvents().add(winEvent);
    }

    private LineItemStatus createLineItemStatus(String lineItemId) {
        LineItem lineItem = this.lineItemService.getLineItemById(lineItemId);
        return lineItem != null ? LineItemStatus.of((LineItem)lineItem) : LineItemStatus.of((String)lineItemId);
    }

    public void mergeFrom(DeliveryProgress another) {
        this.requests.add(another.requests.sum());
        another.requestsPerAccount.forEach((accountId, requestsCount) -> this.mergeRequestsCount(accountId, requestsCount, this.requestsPerAccount));
        another.lineItemStatuses.forEach((lineItemId, lineItemStatus) -> this.lineItemStatuses.computeIfAbsent(lineItemId, arg_0 -> this.createLineItemStatus(arg_0)).merge(lineItemStatus));
        another.lineItemIdToLost.forEach((lineItemId, currentLineItemLost) -> this.mergeCurrentLineItemLostReportToOverall(lineItemId, currentLineItemLost, this.lineItemIdToLost));
    }

    public void upsertPlanReferenceFromLineItem(LineItem lineItem) {
        String lineItemId = lineItem.getLineItemId();
        LineItemStatus existingLineItemStatus = (LineItemStatus)this.lineItemStatuses.get(lineItemId);
        DeliveryPlan activeDeliveryPlan = lineItem.getActiveDeliveryPlan();
        if (existingLineItemStatus == null) {
            LineItemStatus lineItemStatus = this.createLineItemStatus(lineItem.getLineItemId());
            lineItemStatus.getDeliveryPlans().add(activeDeliveryPlan);
            this.lineItemStatuses.put(lineItemId, lineItemStatus);
        } else {
            this.updateLineItemStatusWithActiveDeliveryPlan(existingLineItemStatus, activeDeliveryPlan);
        }
    }

    public void mergePlanFromLineItem(LineItem lineItem) {
        LineItemStatus currentLineItemStatus = this.lineItemStatuses.computeIfAbsent(lineItem.getLineItemId(), arg_0 -> this.createLineItemStatus(arg_0));
        DeliveryPlan updatedDeliveryPlan = lineItem.getActiveDeliveryPlan();
        Set deliveryPlans = currentLineItemStatus.getDeliveryPlans();
        DeliveryPlan currentPlan = deliveryPlans.stream().filter(plan -> Objects.equals(plan.getPlanId(), updatedDeliveryPlan.getPlanId())).findFirst().orElse(null);
        if (currentPlan == null) {
            deliveryPlans.add(updatedDeliveryPlan.withoutSpentTokens());
        } else if (currentPlan.isUpdated(updatedDeliveryPlan.getDeliverySchedule())) {
            DeliveryPlan updatedPlan = currentPlan.mergeWithNextDeliveryPlan(updatedDeliveryPlan);
            deliveryPlans.remove(currentPlan);
            deliveryPlans.add(updatedPlan);
        }
    }

    public void cleanLineItemStatuses(ZonedDateTime now, long lineItemStatusTtl, int maxPlanNumberInDeliveryProgress) {
        this.lineItemStatuses.entrySet().removeIf(entry -> this.isLineItemStatusExpired((String)entry.getKey(), now, lineItemStatusTtl));
        this.lineItemStatuses.values().forEach(lineItemStatus -> this.cutCachedDeliveryPlans(lineItemStatus, maxPlanNumberInDeliveryProgress));
    }

    private boolean isLineItemStatusExpired(String lineItemId, ZonedDateTime now, long lineItemStatusTtl) {
        LineItem lineItem = this.lineItemService.getLineItemById(lineItemId);
        return lineItem == null || ChronoUnit.MILLIS.between(lineItem.getEndTimeStamp(), now) > lineItemStatusTtl;
    }

    private void cutCachedDeliveryPlans(LineItemStatus lineItemStatus, int maxPlanNumberInDeliveryProgress) {
        Set deliveryPlans = lineItemStatus.getDeliveryPlans();
        if (deliveryPlans.size() > maxPlanNumberInDeliveryProgress) {
            Set<DeliveryPlan> plansToRemove = deliveryPlans.stream().sorted(Comparator.comparing(DeliveryPlan::getEndTimeStamp)).limit(deliveryPlans.size() - maxPlanNumberInDeliveryProgress).collect(Collectors.toSet());
            plansToRemove.forEach(deliveryPlans::remove);
        }
    }

    private void updateLineItemStatusWithActiveDeliveryPlan(LineItemStatus lineItemStatus, DeliveryPlan updatedDeliveryPlan) {
        Set deliveryPlans = lineItemStatus.getDeliveryPlans();
        DeliveryPlan currentPlan = deliveryPlans.stream().filter(plan -> Objects.equals(plan.getPlanId(), updatedDeliveryPlan.getPlanId())).filter(plan -> plan.isUpdated(updatedDeliveryPlan.getDeliverySchedule())).findAny().orElse(null);
        if (currentPlan != null) {
            if (!Objects.equals(currentPlan.getUpdatedTimeStamp(), updatedDeliveryPlan.getUpdatedTimeStamp())) {
                deliveryPlans.add(updatedDeliveryPlan);
                deliveryPlans.remove(currentPlan);
            }
        } else {
            deliveryPlans.add(updatedDeliveryPlan);
        }
    }

    public void updateWithActiveLineItems(Collection<LineItem> lineItems) {
        lineItems.forEach(lineItem -> this.lineItemStatuses.putIfAbsent(lineItem.getLineItemId(), this.createLineItemStatus(lineItem.getLineItemId())));
    }

    public Map<String, LineItemStatus> getLineItemStatuses() {
        return this.lineItemStatuses;
    }

    public Map<String, LongAdder> getRequestsPerAccount() {
        return this.requestsPerAccount;
    }

    public Map<String, Map<String, LostToLineItem>> getLineItemIdToLost() {
        return this.lineItemIdToLost;
    }

    public LongAdder getRequests() {
        return this.requests;
    }

    public ZonedDateTime getStartTimeStamp() {
        return this.startTimeStamp;
    }

    public void setStartTimeStamp(ZonedDateTime startTimeStamp) {
        this.startTimeStamp = startTimeStamp;
    }

    public void setEndTimeStamp(ZonedDateTime endTimeStamp) {
        this.endTimeStamp = endTimeStamp;
    }

    public ZonedDateTime getEndTimeStamp() {
        return this.endTimeStamp;
    }

    private LongAdder accountRequests(String account) {
        return this.requestsPerAccount.computeIfAbsent(account, ignored -> new LongAdder());
    }

    private void increment(String lineItemId, Consumer<LineItemStatus> inc) {
        inc.accept(this.lineItemStatuses.computeIfAbsent(lineItemId, arg_0 -> this.createLineItemStatus(arg_0)));
    }

    private void incToken(String lineItemId, Map<String, Integer> planIdToTokenPriority) {
        LineItemStatus lineItemStatus = (LineItemStatus)this.lineItemStatuses.get(lineItemId);
        LineItem lineItem = this.lineItemService.getLineItemById(lineItemId);
        DeliveryPlan lineItemActivePlan = lineItem.getActiveDeliveryPlan();
        if (lineItemActivePlan != null) {
            Integer tokenPriority;
            DeliveryPlan reportActivePlan = lineItemStatus.getDeliveryPlans().stream().filter(plan -> Objects.equals(plan.getPlanId(), lineItemActivePlan.getPlanId())).findFirst().orElse(null);
            if (reportActivePlan == null) {
                reportActivePlan = lineItemActivePlan.withoutSpentTokens();
                lineItemStatus.getDeliveryPlans().add(reportActivePlan);
            }
            if ((tokenPriority = planIdToTokenPriority.get(reportActivePlan.getPlanId())) != null) {
                reportActivePlan.incTokenWithPriority(tokenPriority);
            }
        }
    }

    private void updateLostToEachLineItem(String lineItemId, Set<String> lostToLineItemsIds, Map<String, Map<String, LostToLineItem>> lostToLineItemTimes) {
        Map lostToLineItemsTimes = lostToLineItemTimes.computeIfAbsent(lineItemId, key -> new ConcurrentHashMap());
        lostToLineItemsIds.forEach(lostToLineItemId -> this.incLostToLineItemTimes(lostToLineItemId, lostToLineItemsTimes));
    }

    private void incLostToLineItemTimes(String lostToLineItemId, Map<String, LostToLineItem> lostToLineItemsTimes) {
        LostToLineItem lostToLineItem = lostToLineItemsTimes.computeIfAbsent(lostToLineItemId, ignored -> LostToLineItem.of((String)lostToLineItemId, (LongAdder)new LongAdder()));
        lostToLineItem.getCount().increment();
    }

    private void mergeRequestsCount(String accountId, LongAdder requestsCount, Map<String, LongAdder> requestsPerAccount) {
        requestsPerAccount.computeIfPresent(accountId, (key, oldValue) -> {
            oldValue.add(requestsCount.sum());
            return oldValue;
        });
        requestsPerAccount.putIfAbsent(accountId, requestsCount);
    }

    private void mergeCurrentLineItemLostReportToOverall(String lineItemId, Map<String, LostToLineItem> currentLineItemLost, Map<String, Map<String, LostToLineItem>> overallLineItemIdToLost) {
        Map overallLineItemLost = overallLineItemIdToLost.computeIfAbsent(lineItemId, ignored -> new ConcurrentHashMap());
        currentLineItemLost.forEach((lineItemIdLostTo, currentLostToLineItem) -> overallLineItemLost.merge(lineItemIdLostTo, currentLostToLineItem, (arg_0, arg_1) -> this.addToCount(arg_0, arg_1)));
    }

    private LostToLineItem addToCount(LostToLineItem mergeTo, LostToLineItem mergeFrom) {
        mergeTo.getCount().add(mergeFrom.getCount().sum());
        return mergeTo;
    }
}

