/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals.lineitem;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.SetUtils;
import org.prebid.server.deals.lineitem.DeliveryToken;
import org.prebid.server.deals.proto.DeliverySchedule;
import org.prebid.server.deals.proto.Token;

/*
 * Exception performing whole class analysis ignored.
 */
public class DeliveryPlan {
    private final DeliverySchedule deliverySchedule;
    private final Set<DeliveryToken> deliveryTokens;

    private DeliveryPlan(DeliverySchedule deliverySchedule) {
        this(Objects.requireNonNull(deliverySchedule), DeliveryPlan.toDeliveryTokens((Set)deliverySchedule.getTokens()));
    }

    private DeliveryPlan(DeliverySchedule deliverySchedule, Set<DeliveryToken> deliveryTokens) {
        this.deliverySchedule = Objects.requireNonNull(deliverySchedule);
        this.deliveryTokens = Objects.requireNonNull(deliveryTokens);
    }

    public static DeliveryPlan of(DeliverySchedule deliverySchedule) {
        return new DeliveryPlan(deliverySchedule);
    }

    public int getUnspentTokens() {
        return this.deliveryTokens.stream().mapToInt(DeliveryToken::getUnspent).sum();
    }

    public long getSpentTokens() {
        return this.deliveryTokens.stream().map(DeliveryToken::getSpent).mapToLong(LongAdder::sum).sum();
    }

    public long getTotalTokens() {
        return this.deliveryTokens.stream().mapToLong(DeliveryToken::getTotal).sum();
    }

    public Integer getHighestUnspentTokensClass() {
        return this.deliveryTokens.stream().filter(token -> token.getUnspent() > 0).map(DeliveryToken::getPriorityClass).findFirst().orElse(null);
    }

    public Integer incSpentToken() {
        DeliveryToken unspentToken = this.deliveryTokens.stream().filter(token -> token.getUnspent() > 0).findFirst().orElse(null);
        if (unspentToken != null) {
            unspentToken.inc();
            return unspentToken.getPriorityClass();
        }
        return null;
    }

    public DeliveryPlan mergeWithNextDeliverySchedule(DeliverySchedule nextDeliverySchedule, boolean sumTotal) {
        Map nextTokensByClass = nextDeliverySchedule.getTokens().stream().collect(Collectors.toMap(Token::getPriorityClass, Function.identity()));
        TreeSet<DeliveryToken> mergedTokens = new TreeSet<DeliveryToken>();
        for (DeliveryToken expiredToken : this.deliveryTokens) {
            Integer priorityClass = expiredToken.getPriorityClass();
            Token nextToken = (Token)nextTokensByClass.get(priorityClass);
            mergedTokens.add(expiredToken.mergeWithToken(nextToken, sumTotal));
            nextTokensByClass.remove(priorityClass);
        }
        nextTokensByClass.values().stream().map(DeliveryToken::of).forEach(mergedTokens::add);
        return new DeliveryPlan(nextDeliverySchedule, mergedTokens);
    }

    public DeliveryPlan mergeWithNextDeliveryPlan(DeliveryPlan anotherPlan) {
        return this.mergeWithNextDeliverySchedule(anotherPlan.deliverySchedule, false);
    }

    public DeliveryPlan withoutSpentTokens() {
        return new DeliveryPlan(this.deliverySchedule, this.deliveryTokens.stream().map(DeliveryToken::of).collect(Collectors.toSet()));
    }

    public void incTokenWithPriority(Integer tokenPriority) {
        this.deliveryTokens.stream().filter(token -> Objects.equals(token.getPriorityClass(), tokenPriority)).findAny().ifPresent(DeliveryToken::inc);
    }

    public ZonedDateTime calculateReadyAt() {
        ZonedDateTime planStartTime = this.deliverySchedule.getStartTimeStamp();
        long spentTokens = this.getSpentTokens();
        long unspentTokens = this.getUnspentTokens();
        long timeShift = spentTokens * ((this.deliverySchedule.getEndTimeStamp().toInstant().toEpochMilli() - planStartTime.toInstant().toEpochMilli()) / this.getTotalTokens());
        return unspentTokens > 0L ? ZonedDateTime.ofInstant(planStartTime.toInstant().plusMillis(timeShift), ZoneOffset.UTC) : null;
    }

    public Long getDeliveryRateInMilliseconds() {
        return this.getUnspentTokens() > 0 ? Long.valueOf((this.deliverySchedule.getEndTimeStamp().toInstant().toEpochMilli() - this.deliverySchedule.getStartTimeStamp().toInstant().toEpochMilli()) / this.getTotalTokens()) : null;
    }

    public boolean isUpdated(DeliverySchedule deliverySchedule) {
        ZonedDateTime currentPlanUpdatedDate = this.deliverySchedule.getUpdatedTimeStamp();
        ZonedDateTime newPlanUpdatedDate = deliverySchedule.getUpdatedTimeStamp();
        return !(currentPlanUpdatedDate == null && newPlanUpdatedDate == null || currentPlanUpdatedDate != null && newPlanUpdatedDate != null && !currentPlanUpdatedDate.isBefore(newPlanUpdatedDate));
    }

    public String getPlanId() {
        return this.deliverySchedule.getPlanId();
    }

    public ZonedDateTime getStartTimeStamp() {
        return this.deliverySchedule.getStartTimeStamp();
    }

    public ZonedDateTime getEndTimeStamp() {
        return this.deliverySchedule.getEndTimeStamp();
    }

    public ZonedDateTime getUpdatedTimeStamp() {
        return this.deliverySchedule.getUpdatedTimeStamp();
    }

    public Set<DeliveryToken> getDeliveryTokens() {
        return this.deliveryTokens;
    }

    public DeliverySchedule getDeliverySchedule() {
        return this.deliverySchedule;
    }

    private static Set<DeliveryToken> toDeliveryTokens(Set<Token> tokens) {
        return SetUtils.emptyIfNull(tokens).stream().map(DeliveryToken::of).collect(Collectors.toCollection(TreeSet::new));
    }
}

