/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Data;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Geo;
import com.iab.openrtb.request.User;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.Clock;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.WeekFields;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.auction.model.AuctionContext;
import org.prebid.server.auction.model.Tuple3;
import org.prebid.server.deals.LineItemService;
import org.prebid.server.deals.UserService;
import org.prebid.server.deals.deviceinfo.DeviceInfoService;
import org.prebid.server.deals.model.DeviceInfo;
import org.prebid.server.deals.model.Segment;
import org.prebid.server.deals.model.UserDetails;
import org.prebid.server.execution.Timeout;
import org.prebid.server.geolocation.GeoLocationService;
import org.prebid.server.geolocation.model.GeoInfo;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.log.CriteriaLogManager;
import org.prebid.server.proto.openrtb.ext.request.ExtDevice;
import org.prebid.server.proto.openrtb.ext.request.ExtDeviceVendor;
import org.prebid.server.proto.openrtb.ext.request.ExtGeo;
import org.prebid.server.proto.openrtb.ext.request.ExtGeoVendor;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.ExtUserTime;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class UserAdditionalInfoService {
    private static final Logger logger = LoggerFactory.getLogger(UserAdditionalInfoService.class);
    private final LineItemService lineItemService;
    private final DeviceInfoService deviceInfoService;
    private final GeoLocationService geoLocationService;
    private final UserService userService;
    private final Clock clock;
    private final JacksonMapper mapper;
    private final CriteriaLogManager criteriaLogManager;

    public UserAdditionalInfoService(LineItemService lineItemService, DeviceInfoService deviceInfoService, GeoLocationService geoLocationService, UserService userService, Clock clock, JacksonMapper mapper, CriteriaLogManager criteriaLogManager) {
        this.lineItemService = Objects.requireNonNull(lineItemService);
        this.deviceInfoService = deviceInfoService;
        this.geoLocationService = geoLocationService;
        this.userService = Objects.requireNonNull(userService);
        this.clock = Objects.requireNonNull(clock);
        this.mapper = Objects.requireNonNull(mapper);
        this.criteriaLogManager = Objects.requireNonNull(criteriaLogManager);
    }

    public Future<AuctionContext> populate(AuctionContext context) {
        boolean accountHasDeals = this.lineItemService.accountHasDeals(context);
        String accountId = context.getAccount().getId();
        if (!accountHasDeals) {
            this.criteriaLogManager.log(logger, accountId, (Object)"Account %s does not have deals".formatted(accountId), arg_0 -> ((Logger)logger).debug(arg_0));
            return Future.succeededFuture((Object)context);
        }
        Device device = context.getBidRequest().getDevice();
        Timeout timeout = context.getTimeout();
        GeoInfo geoInfo = context.getGeoInfo();
        CompositeFuture compositeFuture = CompositeFuture.join((Future)this.lookupDeviceInfo(device), (Future)(geoInfo != null ? Future.succeededFuture((Object)geoInfo) : this.lookupGeoInfo(device, timeout)), (Future)this.userService.getUserDetails(context, timeout));
        Promise promise = Promise.promise();
        compositeFuture.onComplete(ignored -> this.handleInfos(compositeFuture, promise, context.getAccount().getId()));
        return promise.future().map(tuple -> this.enrichAuctionContext(context, tuple));
    }

    private Future<DeviceInfo> lookupDeviceInfo(Device device) {
        return this.deviceInfoService != null ? this.deviceInfoService.getDeviceInfo(device.getUa()) : Future.failedFuture((String)"Device info is disabled by configuration");
    }

    private Future<GeoInfo> lookupGeoInfo(Device device, Timeout timeout) {
        return this.geoLocationService != null ? this.geoLocationService.lookup((String)ObjectUtils.defaultIfNull((Object)device.getIp(), (Object)device.getIpv6()), timeout) : Future.failedFuture((String)"Geo location is disabled by configuration");
    }

    private void handleInfos(CompositeFuture compositeFuture, Promise<Tuple3<DeviceInfo, GeoInfo, UserDetails>> resultPromise, String account) {
        DeviceInfo deviceInfo = null;
        GeoInfo geoInfo = null;
        UserDetails userDetails = null;
        for (int i = 0; i < compositeFuture.list().size(); ++i) {
            Object o = compositeFuture.resultAt(i);
            if (o == null) {
                this.criteriaLogManager.log(logger, account, (Object)("Deals processing error: " + compositeFuture.cause(i)), arg_0 -> ((Logger)logger).warn(arg_0));
                continue;
            }
            if (o instanceof DeviceInfo) {
                deviceInfo = (DeviceInfo)o;
                continue;
            }
            if (o instanceof GeoInfo) {
                geoInfo = (GeoInfo)o;
                continue;
            }
            if (!(o instanceof UserDetails)) continue;
            userDetails = (UserDetails)o;
        }
        resultPromise.complete((Object)Tuple3.of(deviceInfo, geoInfo, userDetails));
    }

    private AuctionContext enrichAuctionContext(AuctionContext auctionContext, Tuple3<DeviceInfo, GeoInfo, UserDetails> tuple) {
        DeviceInfo deviceInfo = (DeviceInfo)tuple.getLeft();
        GeoInfo geoInfo = (GeoInfo)tuple.getMiddle();
        UserDetails userDetails = (UserDetails)tuple.getRight();
        BidRequest bidRequest = auctionContext.getBidRequest();
        Device originalDevice = bidRequest.getDevice();
        BidRequest enrichedBidRequest = bidRequest.toBuilder().device(deviceInfo != null || geoInfo != null ? this.updateDevice(originalDevice, deviceInfo, geoInfo) : originalDevice).user(this.updateUser(bidRequest.getUser(), userDetails, geoInfo)).build();
        return auctionContext.toBuilder().bidRequest(enrichedBidRequest).geoInfo(geoInfo).build();
    }

    private Device updateDevice(Device device, DeviceInfo deviceInfo, GeoInfo geoInfo) {
        ExtDevice updatedExtDevice = this.fillExtDeviceWith(this.fillExtDeviceWith((ExtDevice)ObjectUtil.getIfNotNull((Object)device, Device::getExt), (String)ObjectUtil.getIfNotNull((Object)deviceInfo, DeviceInfo::getVendor), UserAdditionalInfoService.extDeviceVendorFrom((DeviceInfo)deviceInfo)), (String)ObjectUtil.getIfNotNull((Object)geoInfo, GeoInfo::getVendor), UserAdditionalInfoService.extDeviceVendorFrom((GeoInfo)geoInfo));
        Geo updatedGeo = this.updateDeviceGeo((Geo)ObjectUtil.getIfNotNull((Object)device, Device::getGeo), geoInfo);
        Device.DeviceBuilder deviceBuilder = device != null ? device.toBuilder() : Device.builder();
        return deviceBuilder.geo(updatedGeo).ext(updatedExtDevice).build();
    }

    private ExtDevice fillExtDeviceWith(ExtDevice extDevice, String vendor, ExtDeviceVendor extDeviceVendor) {
        if (extDeviceVendor.equals((Object)ExtDeviceVendor.EMPTY)) {
            return extDevice;
        }
        ExtDevice effectiveExtDevice = extDevice != null ? extDevice : ExtDevice.empty();
        effectiveExtDevice.addProperty(vendor, this.mapper.mapper().valueToTree((Object)extDeviceVendor));
        return effectiveExtDevice;
    }

    private static ExtDeviceVendor extDeviceVendorFrom(DeviceInfo deviceInfo) {
        return deviceInfo != null ? ExtDeviceVendor.builder().type(deviceInfo.getDeviceTypeRaw()).osfamily(null).os(deviceInfo.getOs()).osver(deviceInfo.getOsVersion()).browser(deviceInfo.getBrowser()).browserver(deviceInfo.getBrowserVersion()).make(deviceInfo.getManufacturer()).model(deviceInfo.getModel()).language(deviceInfo.getLanguage()).carrier(deviceInfo.getCarrier()).build() : ExtDeviceVendor.EMPTY;
    }

    private static ExtDeviceVendor extDeviceVendorFrom(GeoInfo geoInfo) {
        return geoInfo != null ? ExtDeviceVendor.builder().connspeed(geoInfo.getConnectionSpeed()).build() : ExtDeviceVendor.EMPTY;
    }

    private Geo updateDeviceGeo(Geo geo, GeoInfo geoInfo) {
        if (geoInfo == null) {
            return geo;
        }
        ExtGeo updatedExtGeo = this.fillExtGeoWith((ExtGeo)ObjectUtil.getIfNotNull((Object)geo, Geo::getExt), geoInfo.getVendor(), UserAdditionalInfoService.extGeoVendorFrom((GeoInfo)geoInfo));
        Geo.GeoBuilder geoBuilder = geo != null ? geo.toBuilder() : Geo.builder();
        return geoBuilder.country(geoInfo.getCountry()).region(geoInfo.getRegion()).metro(geoInfo.getMetroGoogle()).lat(geoInfo.getLat()).lon(geoInfo.getLon()).ext(updatedExtGeo).build();
    }

    private ExtGeo fillExtGeoWith(ExtGeo extGeo, String vendor, ExtGeoVendor extGeoVendor) {
        if (extGeoVendor.equals((Object)ExtGeoVendor.EMPTY)) {
            return extGeo;
        }
        ExtGeo effectiveExtGeo = extGeo != null ? extGeo : ExtGeo.of();
        effectiveExtGeo.addProperty(vendor, this.mapper.mapper().valueToTree((Object)extGeoVendor));
        return effectiveExtGeo;
    }

    private static ExtGeoVendor extGeoVendorFrom(GeoInfo geoInfo) {
        return ExtGeoVendor.builder().continent(geoInfo.getContinent()).country(geoInfo.getCountry()).region(geoInfo.getRegionCode()).metro(geoInfo.getMetroNielsen()).city(geoInfo.getCity()).zip(geoInfo.getZip()).build();
    }

    private User updateUser(User user, UserDetails userDetails, GeoInfo geoInfo) {
        User.UserBuilder userBuilder = user != null ? user.toBuilder() : User.builder();
        return userBuilder.data(userDetails != null ? UserAdditionalInfoService.makeData((UserDetails)userDetails) : null).ext(this.updateExtUser((ExtUser)ObjectUtil.getIfNotNull((Object)user, User::getExt), userDetails, geoInfo)).build();
    }

    private static List<Data> makeData(UserDetails userDetails) {
        List userData = userDetails.getUserData();
        return userData != null ? userData.stream().map(userDataElement -> Data.builder().id(userDataElement.getName()).segment(UserAdditionalInfoService.makeSegments((List)userDataElement.getSegment())).build()).toList() : null;
    }

    private static List<com.iab.openrtb.request.Segment> makeSegments(List<Segment> segments) {
        return segments != null ? segments.stream().map(segment -> com.iab.openrtb.request.Segment.builder().id(segment.getId()).build()).toList() : null;
    }

    private ExtUser updateExtUser(ExtUser extUser, UserDetails userDetails, GeoInfo geoInfo) {
        ExtUser.ExtUserBuilder extUserBuilder = extUser != null ? extUser.toBuilder() : ExtUser.builder();
        return extUserBuilder.fcapIds((List)ObjectUtils.defaultIfNull((Object)UserAdditionalInfoService.resolveFcapIds((UserDetails)userDetails), (Object)((List)ObjectUtil.getIfNotNull((Object)extUser, ExtUser::getFcapIds)))).time(this.resolveExtUserTime(geoInfo)).build();
    }

    private static List<String> resolveFcapIds(UserDetails userDetails) {
        return userDetails != null ? ListUtils.emptyIfNull((List)userDetails.getFcapIds()) : null;
    }

    private ExtUserTime resolveExtUserTime(GeoInfo geoInfo) {
        ZoneId timeZone = (ZoneId)ObjectUtils.firstNonNull((Object[])new ZoneId[]{(ZoneId)ObjectUtil.getIfNotNull((Object)geoInfo, GeoInfo::getTimeZone), this.clock.getZone()});
        ZonedDateTime dateTime = ZonedDateTime.now(this.clock).withZoneSameInstant(timeZone);
        return ExtUserTime.of((Integer)dateTime.getDayOfWeek().get(WeekFields.SUNDAY_START.dayOfWeek()), (Integer)dateTime.getHour());
    }
}

