/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.deals;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.deals.DeliveryProgressReportFactory;
import org.prebid.server.deals.LineItemService;
import org.prebid.server.deals.lineitem.DeliveryPlan;
import org.prebid.server.deals.lineitem.DeliveryProgress;
import org.prebid.server.deals.lineitem.DeliveryToken;
import org.prebid.server.deals.lineitem.LineItem;
import org.prebid.server.deals.lineitem.LineItemStatus;
import org.prebid.server.deals.lineitem.LostToLineItem;
import org.prebid.server.deals.model.DeploymentProperties;
import org.prebid.server.deals.proto.report.DeliveryProgressReport;
import org.prebid.server.deals.proto.report.DeliveryProgressReportBatch;
import org.prebid.server.deals.proto.report.DeliverySchedule;
import org.prebid.server.deals.proto.report.Token;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class DeliveryProgressReportFactory {
    private static final Logger logger = LoggerFactory.getLogger(DeliveryProgressReportFactory.class);
    private static final LostToLineItemComparator LOST_TO_LINE_ITEM_COMPARATOR = new LostToLineItemComparator();
    private final DeploymentProperties deploymentProperties;
    private final int competitorsNumber;
    private final LineItemService lineItemService;
    private static final DateTimeFormatter UTC_MILLIS_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").toFormatter();

    public DeliveryProgressReportFactory(DeploymentProperties deploymentProperties, int competitorsNumber, LineItemService lineItemService) {
        this.deploymentProperties = Objects.requireNonNull(deploymentProperties);
        this.competitorsNumber = competitorsNumber;
        this.lineItemService = Objects.requireNonNull(lineItemService);
    }

    public DeliveryProgressReport fromDeliveryProgress(DeliveryProgress deliveryProgress, ZonedDateTime now, boolean isOverall) {
        ArrayList lineItemStatuses = new ArrayList(deliveryProgress.getLineItemStatuses().values());
        return DeliveryProgressReport.builder().reportId(UUID.randomUUID().toString()).reportTimeStamp(now != null ? DeliveryProgressReportFactory.formatTimeStamp((ZonedDateTime)now) : null).dataWindowStartTimeStamp(isOverall ? null : DeliveryProgressReportFactory.formatTimeStamp((ZonedDateTime)deliveryProgress.getStartTimeStamp())).dataWindowEndTimeStamp(isOverall ? null : DeliveryProgressReportFactory.formatTimeStamp((ZonedDateTime)deliveryProgress.getEndTimeStamp())).instanceId(this.deploymentProperties.getPbsHostId()).region(this.deploymentProperties.getPbsRegion()).vendor(this.deploymentProperties.getPbsVendor()).clientAuctions(Long.valueOf(deliveryProgress.getRequests().sum())).lineItemStatus(this.makeLineItemStatusReports(deliveryProgress, lineItemStatuses, deliveryProgress.getLineItemStatuses(), isOverall)).build();
    }

    public DeliveryProgressReportBatch batchFromDeliveryProgress(DeliveryProgress deliveryProgress, Map<String, LineItemStatus> overallLineItemStatuses, ZonedDateTime now, int batchSize, boolean isOverall) {
        ArrayList lineItemStatuses = new ArrayList(deliveryProgress.getLineItemStatuses().values());
        String reportId = UUID.randomUUID().toString();
        String reportTimeStamp = now != null ? DeliveryProgressReportFactory.formatTimeStamp((ZonedDateTime)now) : null;
        String dataWindowStartTimeStamp = isOverall ? null : DeliveryProgressReportFactory.formatTimeStamp((ZonedDateTime)deliveryProgress.getStartTimeStamp());
        String dataWindowEndTimeStamp = isOverall ? null : DeliveryProgressReportFactory.formatTimeStamp((ZonedDateTime)deliveryProgress.getEndTimeStamp());
        long clientAuctions = deliveryProgress.getRequests().sum();
        int lineItemsCount = lineItemStatuses.size();
        int batchesNumber = lineItemsCount / batchSize + (lineItemsCount % batchSize > 0 ? 1 : 0);
        Set reportsBatch = IntStream.range(0, batchesNumber).mapToObj(batchNumber -> this.updateReportWithLineItems(deliveryProgress, lineItemStatuses, overallLineItemStatuses, lineItemsCount, batchNumber, batchSize, isOverall)).map(deliveryProgressReport -> deliveryProgressReport.reportId(reportId).reportTimeStamp(reportTimeStamp).dataWindowStartTimeStamp(dataWindowStartTimeStamp).dataWindowEndTimeStamp(dataWindowEndTimeStamp).clientAuctions(Long.valueOf(clientAuctions)).instanceId(this.deploymentProperties.getPbsHostId()).region(this.deploymentProperties.getPbsRegion()).vendor(this.deploymentProperties.getPbsVendor()).build()).collect(Collectors.toSet());
        DeliveryProgressReportFactory.logNotDeliveredLineItems((DeliveryProgress)deliveryProgress, reportsBatch);
        return DeliveryProgressReportBatch.of(reportsBatch, (String)reportId, (String)dataWindowEndTimeStamp);
    }

    private DeliveryProgressReport.DeliveryProgressReportBuilder updateReportWithLineItems(DeliveryProgress deliveryProgress, List<LineItemStatus> lineItemStatuses, Map<String, LineItemStatus> overallLineItemStatuses, int lineItemsCount, int batchNumber, int batchSize, boolean isOverall) {
        int startBatchIndex = batchNumber * batchSize;
        int endBatchIndex = (batchNumber + 1) * batchSize;
        List<LineItemStatus> batchList = lineItemStatuses.subList(startBatchIndex, Math.min(endBatchIndex, lineItemsCount));
        return DeliveryProgressReport.builder().lineItemStatus(this.makeLineItemStatusReports(deliveryProgress, batchList, overallLineItemStatuses, isOverall));
    }

    private Set<org.prebid.server.deals.proto.report.LineItemStatus> makeLineItemStatusReports(DeliveryProgress deliveryProgress, List<LineItemStatus> lineItemStatuses, Map<String, LineItemStatus> overallLineItemStatuses, boolean isOverall) {
        return lineItemStatuses.stream().map(lineItemStatus -> this.toLineItemStatusReport(lineItemStatus, overallLineItemStatuses != null ? (LineItemStatus)overallLineItemStatuses.get(lineItemStatus.getLineItemId()) : null, deliveryProgress, isOverall)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static void logNotDeliveredLineItems(DeliveryProgress deliveryProgress, Set<DeliveryProgressReport> reportsBatch) {
        Set reportedLineItems = reportsBatch.stream().map(DeliveryProgressReport::getLineItemStatus).flatMap(Collection::stream).map(org.prebid.server.deals.proto.report.LineItemStatus::getLineItemId).collect(Collectors.toSet());
        String notDeliveredLineItems = deliveryProgress.getLineItemStatuses().keySet().stream().filter(id -> !reportedLineItems.contains(id)).collect(Collectors.joining(", "));
        if (StringUtils.isNotBlank((CharSequence)notDeliveredLineItems)) {
            logger.info((Object)"Line item with id {0} will not be reported, as it does not have active delivery schedules during report window.", new Object[]{notDeliveredLineItems});
        }
    }

    DeliveryProgressReport updateReportTimeStamp(DeliveryProgressReport deliveryProgressReport, ZonedDateTime now) {
        return deliveryProgressReport.toBuilder().reportTimeStamp(DeliveryProgressReportFactory.formatTimeStamp((ZonedDateTime)now)).build();
    }

    private org.prebid.server.deals.proto.report.LineItemStatus toLineItemStatusReport(LineItemStatus lineItemStatus, LineItemStatus overallLineItemStatus, DeliveryProgress deliveryProgress, boolean isOverall) {
        String lineItemId = lineItemStatus.getLineItemId();
        LineItem lineItem = this.lineItemService.getLineItemById(lineItemId);
        if (isOverall && lineItem == null) {
            return null;
        }
        DeliveryPlan activeDeliveryPlan = (DeliveryPlan)ObjectUtil.getIfNotNull((Object)lineItem, LineItem::getActiveDeliveryPlan);
        Set deliverySchedules = DeliveryProgressReportFactory.deliverySchedule((LineItemStatus)lineItemStatus, (LineItemStatus)overallLineItemStatus, (DeliveryPlan)activeDeliveryPlan);
        if (CollectionUtils.isEmpty((Collection)deliverySchedules) && !isOverall) {
            return null;
        }
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = () -> ((LineItemStatus)lineItemStatus).getSource();
        supplierArray[1] = () -> (String)ObjectUtil.getIfNotNull((Object)lineItem, LineItem::getSource);
        Supplier[] supplierArray2 = new Supplier[2];
        supplierArray2[0] = () -> ((LineItemStatus)lineItemStatus).getDealId();
        supplierArray2[1] = () -> (String)ObjectUtil.getIfNotNull((Object)lineItem, LineItem::getDealId);
        Supplier[] supplierArray3 = new Supplier[2];
        supplierArray3[0] = () -> ((LineItemStatus)lineItemStatus).getExtLineItemId();
        supplierArray3[1] = () -> (String)ObjectUtil.getIfNotNull((Object)lineItem, LineItem::getExtLineItemId);
        Supplier[] supplierArray4 = new Supplier[2];
        supplierArray4[0] = () -> ((LineItemStatus)lineItemStatus).getAccountId();
        supplierArray4[1] = () -> (String)ObjectUtil.getIfNotNull((Object)lineItem, LineItem::getAccountId);
        return org.prebid.server.deals.proto.report.LineItemStatus.builder().lineItemSource((String)ObjectUtil.firstNonNull((Supplier[])supplierArray)).lineItemId(lineItemId).dealId((String)ObjectUtil.firstNonNull((Supplier[])supplierArray2)).extLineItemId((String)ObjectUtil.firstNonNull((Supplier[])supplierArray3)).accountAuctions(this.accountRequests((String)ObjectUtil.firstNonNull((Supplier[])supplierArray4), deliveryProgress)).domainMatched(Long.valueOf(lineItemStatus.getDomainMatched().sum())).targetMatched(Long.valueOf(lineItemStatus.getTargetMatched().sum())).targetMatchedButFcapped(Long.valueOf(lineItemStatus.getTargetMatchedButFcapped().sum())).targetMatchedButFcapLookupFailed(Long.valueOf(lineItemStatus.getTargetMatchedButFcapLookupFailed().sum())).pacingDeferred(Long.valueOf(lineItemStatus.getPacingDeferred().sum())).sentToBidder(Long.valueOf(lineItemStatus.getSentToBidder().sum())).sentToBidderAsTopMatch(Long.valueOf(lineItemStatus.getSentToBidderAsTopMatch().sum())).receivedFromBidder(Long.valueOf(lineItemStatus.getReceivedFromBidder().sum())).receivedFromBidderInvalidated(Long.valueOf(lineItemStatus.getReceivedFromBidderInvalidated().sum())).sentToClient(Long.valueOf(lineItemStatus.getSentToClient().sum())).sentToClientAsTopMatch(Long.valueOf(lineItemStatus.getSentToClientAsTopMatch().sum())).lostToLineItems(this.lostToLineItems(lineItemStatus, deliveryProgress)).events(lineItemStatus.getEvents()).deliverySchedule(deliverySchedules).readyAt(isOverall ? this.toReadyAt(lineItem) : null).spentTokens(isOverall && activeDeliveryPlan != null ? Long.valueOf(activeDeliveryPlan.getSpentTokens()) : null).pacingFrequency(isOverall && activeDeliveryPlan != null ? activeDeliveryPlan.getDeliveryRateInMilliseconds() : null).build();
    }

    private String toReadyAt(LineItem lineItem) {
        ZonedDateTime readyAt = (ZonedDateTime)ObjectUtil.getIfNotNull((Object)lineItem, LineItem::getReadyAt);
        return readyAt != null ? UTC_MILLIS_FORMATTER.format(readyAt) : null;
    }

    private Long accountRequests(String accountId, DeliveryProgress deliveryProgress) {
        LongAdder accountRequests = accountId != null ? (LongAdder)deliveryProgress.getRequestsPerAccount().get(accountId) : null;
        return accountRequests != null ? Long.valueOf(accountRequests.sum()) : null;
    }

    private Set<org.prebid.server.deals.proto.report.LostToLineItem> lostToLineItems(LineItemStatus lineItemStatus, DeliveryProgress deliveryProgress) {
        Map lostTo = (Map)deliveryProgress.getLineItemIdToLost().get(lineItemStatus.getLineItemId());
        if (lostTo != null) {
            return lostTo.values().stream().sorted(LOST_TO_LINE_ITEM_COMPARATOR.reversed()).map(arg_0 -> this.toLostToLineItems(arg_0)).limit(this.competitorsNumber).collect(Collectors.toSet());
        }
        return null;
    }

    private org.prebid.server.deals.proto.report.LostToLineItem toLostToLineItems(LostToLineItem lostToLineItem) {
        String lineItemId = lostToLineItem.getLineItemId();
        return org.prebid.server.deals.proto.report.LostToLineItem.of((String)((String)ObjectUtil.getIfNotNull((Object)this.lineItemService.getLineItemById(lineItemId), LineItem::getSource)), (String)lineItemId, (Long)lostToLineItem.getCount().sum());
    }

    private static Set<DeliverySchedule> deliverySchedule(LineItemStatus lineItemStatus, LineItemStatus overallLineItemStatus, DeliveryPlan activeDeliveryPlan) {
        Map idToDeliveryPlan = overallLineItemStatus != null ? overallLineItemStatus.getDeliveryPlans().stream().collect(Collectors.toMap(DeliveryPlan::getPlanId, Function.identity())) : Collections.emptyMap();
        Set<DeliverySchedule> deliverySchedules = lineItemStatus.getDeliveryPlans().stream().map(deliveryPlan -> DeliveryProgressReportFactory.toDeliverySchedule((DeliveryPlan)deliveryPlan, (DeliveryPlan)((DeliveryPlan)idToDeliveryPlan.get(deliveryPlan.getPlanId())))).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(deliverySchedules) && activeDeliveryPlan != null) {
            deliverySchedules.add(DeliveryProgressReportFactory.toDeliverySchedule((DeliveryPlan)activeDeliveryPlan.withoutSpentTokens()));
        }
        return deliverySchedules;
    }

    static DeliverySchedule toDeliverySchedule(DeliveryPlan deliveryPlan) {
        return DeliveryProgressReportFactory.toDeliverySchedule((DeliveryPlan)deliveryPlan, null);
    }

    private static DeliverySchedule toDeliverySchedule(DeliveryPlan plan, DeliveryPlan overallPlan) {
        Map priorityClassToTotalSpent = overallPlan != null ? overallPlan.getDeliveryTokens().stream().collect(Collectors.toMap(DeliveryToken::getPriorityClass, deliveryToken -> deliveryToken.getSpent().sum())) : Collections.emptyMap();
        Set tokens = plan.getDeliveryTokens().stream().map(token -> Token.of((Integer)token.getPriorityClass(), (Integer)token.getTotal(), (Long)token.getSpent().sum(), (Long)((Long)priorityClassToTotalSpent.get(token.getPriorityClass())))).collect(Collectors.toSet());
        return DeliverySchedule.builder().planId(plan.getPlanId()).planStartTimeStamp(DeliveryProgressReportFactory.formatTimeStamp((ZonedDateTime)plan.getStartTimeStamp())).planExpirationTimeStamp(DeliveryProgressReportFactory.formatTimeStamp((ZonedDateTime)plan.getEndTimeStamp())).planUpdatedTimeStamp(DeliveryProgressReportFactory.formatTimeStamp((ZonedDateTime)plan.getUpdatedTimeStamp())).tokens(tokens).build();
    }

    private static String formatTimeStamp(ZonedDateTime zonedDateTime) {
        return zonedDateTime != null ? UTC_MILLIS_FORMATTER.format(zonedDateTime) : null;
    }
}

