/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.currency;

import com.iab.openrtb.request.BidRequest;
import io.vertx.core.Vertx;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.currency.proto.CurrencyConversionRates;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestCurrency;
import org.prebid.server.proto.openrtb.ext.request.ExtRequestPrebid;
import org.prebid.server.spring.config.model.ExternalConversionProperties;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.vertx.Initializable;
import org.prebid.server.vertx.http.HttpClient;
import org.prebid.server.vertx.http.model.HttpClientResponse;

/*
 * Exception performing whole class analysis ignored.
 */
public class CurrencyConversionService
implements Initializable {
    private static final Logger logger = LoggerFactory.getLogger(CurrencyConversionService.class);
    private static final String DEFAULT_BID_CURRENCY = "USD";
    private static final int DEFAULT_PRICE_PRECISION = 3;
    private final String currencyServerUrl;
    private final ExternalConversionProperties externalConversionProperties;
    private final JacksonMapper mapper;
    private Map<String, Map<String, BigDecimal>> externalCurrencyRates;
    private ZonedDateTime lastUpdated;

    public CurrencyConversionService(ExternalConversionProperties externalConversionProperties) {
        this.externalConversionProperties = externalConversionProperties;
        if (externalConversionProperties != null) {
            this.currencyServerUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(externalConversionProperties.getCurrencyServerUrl()));
            this.mapper = Objects.requireNonNull(externalConversionProperties.getMapper());
        } else {
            this.currencyServerUrl = null;
            this.mapper = null;
        }
    }

    public void initialize() {
        if (this.externalConversionProperties != null) {
            Long refreshPeriod = this.externalConversionProperties.getRefreshPeriodMs();
            Long defaultTimeout = this.externalConversionProperties.getDefaultTimeoutMs();
            HttpClient httpClient = this.externalConversionProperties.getHttpClient();
            Vertx vertx = this.externalConversionProperties.getVertx();
            vertx.setPeriodic(refreshPeriod.longValue(), ignored -> this.populatesLatestCurrencyRates(this.currencyServerUrl, defaultTimeout, httpClient));
            this.populatesLatestCurrencyRates(this.currencyServerUrl, defaultTimeout, httpClient);
            this.externalConversionProperties.getMetrics().createCurrencyRatesGauge(() -> this.isRatesStale());
        }
    }

    private void populatesLatestCurrencyRates(String currencyServerUrl, Long defaultTimeout, HttpClient httpClient) {
        httpClient.get(currencyServerUrl, defaultTimeout.longValue()).map(arg_0 -> this.processResponse(arg_0)).map(arg_0 -> this.updateCurrencyRates(arg_0)).otherwise(arg_0 -> this.handleErrorResponse(arg_0));
    }

    private CurrencyConversionRates processResponse(HttpClientResponse response) {
        int statusCode = response.getStatusCode();
        if (statusCode != 200) {
            throw new PreBidException("HTTP status code " + statusCode);
        }
        String body = response.getBody();
        try {
            return (CurrencyConversionRates)this.mapper.mapper().readValue(body, CurrencyConversionRates.class);
        }
        catch (IOException e) {
            throw new PreBidException("Cannot parse response: " + body, (Throwable)e);
        }
    }

    private Void updateCurrencyRates(CurrencyConversionRates currencyConversionRates) {
        Map receivedCurrencyRates = currencyConversionRates.getConversions();
        if (receivedCurrencyRates != null) {
            this.externalCurrencyRates = receivedCurrencyRates;
            this.lastUpdated = this.now();
        }
        return null;
    }

    private Void handleErrorResponse(Throwable exception) {
        logger.warn((Object)"Error occurred while request to currency service", exception);
        if (this.externalRatesAreStale()) {
            this.externalCurrencyRates = null;
        }
        return null;
    }

    private boolean externalRatesAreStale() {
        Long stalePeriodMs = this.externalConversionProperties.getStalePeriodMs();
        return stalePeriodMs != null && Duration.between(this.lastUpdated, this.now()).toMillis() > stalePeriodMs;
    }

    private ZonedDateTime now() {
        return ZonedDateTime.now(this.externalConversionProperties.getClock());
    }

    public boolean isExternalRatesActive() {
        return this.externalConversionProperties != null;
    }

    public String getCurrencyServerUrl() {
        return this.currencyServerUrl;
    }

    public Long getRefreshPeriod() {
        return this.externalConversionProperties != null ? this.externalConversionProperties.getRefreshPeriodMs() : null;
    }

    public ZonedDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public Map<String, Map<String, BigDecimal>> getExternalCurrencyRates() {
        return this.externalCurrencyRates;
    }

    public BigDecimal convertCurrency(BigDecimal price, BidRequest bidRequest, String fromCurrency, String toCurrency) {
        return this.convertCurrency(price, CurrencyConversionService.currencyRates((BidRequest)bidRequest), fromCurrency, toCurrency, CurrencyConversionService.usepbsrates((BidRequest)bidRequest));
    }

    public BigDecimal convertCurrency(BigDecimal price, Map<String, Map<String, BigDecimal>> requestCurrencyRates, String fromCurrency, String toCurrency, Boolean usepbsrates) {
        Map secondPriorityRates;
        Map firstPriorityRates;
        String effectiveToCurrency;
        String effectiveFromCurrency = fromCurrency != null ? fromCurrency : "USD";
        String string = effectiveToCurrency = toCurrency != null ? toCurrency : "USD";
        if (Objects.equals(effectiveToCurrency, effectiveFromCurrency)) {
            return price;
        }
        if (BooleanUtils.isFalse((Boolean)usepbsrates)) {
            firstPriorityRates = requestCurrencyRates;
            secondPriorityRates = this.externalCurrencyRates;
        } else {
            firstPriorityRates = this.externalCurrencyRates;
            secondPriorityRates = requestCurrencyRates;
        }
        BigDecimal conversionRate = CurrencyConversionService.getConversionRateByPriority((Map)firstPriorityRates, (Map)secondPriorityRates, (String)effectiveFromCurrency, (String)effectiveToCurrency);
        if (conversionRate == null) {
            throw new PreBidException("Unable to convert from currency %s to desired ad server currency %s".formatted(effectiveFromCurrency, effectiveToCurrency));
        }
        return price.multiply(conversionRate).setScale(3, RoundingMode.HALF_EVEN);
    }

    private static Map<String, Map<String, BigDecimal>> currencyRates(BidRequest bidRequest) {
        ExtRequestPrebid prebid = CurrencyConversionService.extRequestPrebid((BidRequest)bidRequest);
        ExtRequestCurrency currency = prebid != null ? prebid.getCurrency() : null;
        return currency != null ? currency.getRates() : null;
    }

    private static ExtRequestPrebid extRequestPrebid(BidRequest bidRequest) {
        ExtRequest requestExt = bidRequest.getExt();
        return requestExt != null ? requestExt.getPrebid() : null;
    }

    private static Boolean usepbsrates(BidRequest bidRequest) {
        ExtRequestPrebid prebid = CurrencyConversionService.extRequestPrebid((BidRequest)bidRequest);
        ExtRequestCurrency currency = prebid != null ? prebid.getCurrency() : null;
        return currency != null ? currency.getUsepbsrates() : null;
    }

    private static BigDecimal getConversionRateByPriority(Map<String, Map<String, BigDecimal>> firstPriorityRates, Map<String, Map<String, BigDecimal>> secondPriorityRates, String fromCurrency, String toCurrency) {
        return (BigDecimal)ObjectUtils.defaultIfNull((Object)CurrencyConversionService.getConversionRate(firstPriorityRates, (String)fromCurrency, (String)toCurrency), (Object)CurrencyConversionService.getConversionRate(secondPriorityRates, (String)fromCurrency, (String)toCurrency));
    }

    private static BigDecimal getConversionRate(Map<String, Map<String, BigDecimal>> currencyConversionRates, String fromCurrency, String toCurrency) {
        BigDecimal conversionRate;
        if (MapUtils.isEmpty(currencyConversionRates)) {
            return null;
        }
        Map<String, BigDecimal> directCurrencyRates = currencyConversionRates.get(fromCurrency);
        BigDecimal bigDecimal = conversionRate = directCurrencyRates != null ? directCurrencyRates.get(toCurrency) : null;
        if (conversionRate != null) {
            return conversionRate;
        }
        Map<String, BigDecimal> reverseCurrencyRates = currencyConversionRates.get(toCurrency);
        conversionRate = CurrencyConversionService.findReverseConversionRate(reverseCurrencyRates, (String)fromCurrency);
        if (conversionRate != null) {
            return conversionRate;
        }
        return CurrencyConversionService.findIntermediateConversionRate(directCurrencyRates, reverseCurrencyRates);
    }

    private static BigDecimal findReverseConversionRate(Map<String, BigDecimal> currencyRates, String currency) {
        BigDecimal reverseConversionRate = currencyRates != null ? currencyRates.get(currency) : null;
        return reverseConversionRate != null ? BigDecimal.ONE.divide(reverseConversionRate, reverseConversionRate.precision(), RoundingMode.HALF_EVEN) : null;
    }

    private static BigDecimal findIntermediateConversionRate(Map<String, BigDecimal> directCurrencyRates, Map<String, BigDecimal> reverseCurrencyRates) {
        BigDecimal conversionRate = null;
        if (MapUtils.isNotEmpty(directCurrencyRates) && MapUtils.isNotEmpty(reverseCurrencyRates)) {
            ArrayList<String> sharedCurrencies = new ArrayList<String>(directCurrencyRates.keySet());
            sharedCurrencies.retainAll(reverseCurrencyRates.keySet());
            if (!sharedCurrencies.isEmpty()) {
                BigDecimal reverseCurrencyRateIntermediate;
                String sharedCurrency = (String)sharedCurrencies.get(0);
                BigDecimal directCurrencyRateIntermediate = directCurrencyRates.get(sharedCurrency);
                conversionRate = directCurrencyRateIntermediate.divide(reverseCurrencyRateIntermediate, (reverseCurrencyRateIntermediate = reverseCurrencyRates.get(sharedCurrency)).compareTo(directCurrencyRateIntermediate) > 0 ? reverseCurrencyRateIntermediate.precision() : directCurrencyRateIntermediate.precision(), RoundingMode.HALF_EVEN);
            }
        }
        return conversionRate;
    }

    private boolean isRatesStale() {
        if (this.lastUpdated == null) {
            return false;
        }
        ZonedDateTime stalenessBoundary = ZonedDateTime.now(this.externalConversionProperties.getClock()).minus(Duration.ofMillis(this.externalConversionProperties.getStaleAfterMs()));
        return this.lastUpdated.isBefore(stalenessBoundary);
    }
}

