/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.cookie;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.prebid.server.bidder.BidderCatalog;
import org.prebid.server.cookie.PrioritizedCoopSyncProvider;
import org.prebid.server.cookie.model.CookieSyncContext;
import org.prebid.server.proto.request.CookieSyncRequest;
import org.prebid.server.settings.model.Account;
import org.prebid.server.settings.model.AccountCookieSyncConfig;
import org.prebid.server.settings.model.AccountCoopSyncConfig;

public class CoopSyncProvider {
    private final Set<String> coopSyncBidders;
    private final PrioritizedCoopSyncProvider prioritizedCoopSyncProvider;
    private final boolean defaultCoopSync;

    public CoopSyncProvider(BidderCatalog bidderCatalog, PrioritizedCoopSyncProvider prioritizedCoopSyncProvider, boolean defaultCoopSync) {
        this.coopSyncBidders = Objects.requireNonNull(bidderCatalog).usersyncReadyBidders();
        this.prioritizedCoopSyncProvider = Objects.requireNonNull(prioritizedCoopSyncProvider);
        this.defaultCoopSync = defaultCoopSync;
    }

    public Set<String> coopSyncBidders(CookieSyncContext cookieSyncContext) {
        Account account;
        CookieSyncRequest cookieSyncRequest = cookieSyncContext.getCookieSyncRequest();
        return this.coopSyncAllowed(cookieSyncRequest, account = cookieSyncContext.getAccount()) ? this.prepareCoopSyncBidders(account) : Collections.emptySet();
    }

    private boolean coopSyncAllowed(CookieSyncRequest cookieSyncRequest, Account account) {
        return Optional.ofNullable(cookieSyncRequest.getCoopSync()).or(() -> Optional.ofNullable(account).map(Account::getCookieSync).map(AccountCookieSyncConfig::getCoopSync).map(AccountCoopSyncConfig::getEnabled)).orElse(this.defaultCoopSync);
    }

    private Set<String> prepareCoopSyncBidders(Account account) {
        ArrayList shuffledCoopSyncBidders = new ArrayList(this.coopSyncBidders);
        Collections.shuffle(shuffledCoopSyncBidders);
        return Stream.of(this.prioritizedCoopSyncProvider.prioritizedBidders(account), shuffledCoopSyncBidders).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

