/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.yahooads;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Regs;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.auction.versionconverter.BidRequestOrtbVersionConversionManager;
import org.prebid.server.auction.versionconverter.OrtbVersion;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtRegs;
import org.prebid.server.proto.openrtb.ext.request.yahooads.ExtImpYahooAds;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class YahooAdsBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpYahooAds>> YAHOO_ADVERTISING_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final BidRequestOrtbVersionConversionManager conversionManager;
    private final JacksonMapper mapper;

    public YahooAdsBidder(String endpointUrl, BidRequestOrtbVersionConversionManager conversionManager, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
        this.conversionManager = Objects.requireNonNull(conversionManager);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList<HttpRequest> bidRequests = new ArrayList<HttpRequest>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        Regs regs = bidRequest.getRegs();
        BidRequest bidRequestOpenRtb25 = this.conversionManager.convertFromAuctionSupportedVersion(bidRequest, OrtbVersion.ORTB_2_5);
        List impList = bidRequestOpenRtb25.getImp();
        for (int i = 0; i < impList.size(); ++i) {
            try {
                Imp imp = (Imp)impList.get(i);
                ExtImpYahooAds extImpYahooAds = this.parseAndValidateImpExt(imp.getExt(), i);
                BidRequest modifiedRequest = this.modifyRequest(bidRequestOpenRtb25, imp, extImpYahooAds, regs);
                bidRequests.add(this.makeHttpRequest(modifiedRequest));
                continue;
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return Result.of(bidRequests, errors);
    }

    private ExtImpYahooAds parseAndValidateImpExt(ObjectNode impExtNode, int index) {
        ExtImpYahooAds extImpYahooAds;
        try {
            extImpYahooAds = (ExtImpYahooAds)((ExtPrebid)this.mapper.mapper().convertValue((Object)impExtNode, YAHOO_ADVERTISING_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("imp #%s: %s".formatted(index, e.getMessage()));
        }
        String dcn = extImpYahooAds.getDcn();
        if (StringUtils.isBlank((CharSequence)dcn)) {
            throw new PreBidException("imp #%s: missing param dcn".formatted(index));
        }
        String pos = extImpYahooAds.getPos();
        if (StringUtils.isBlank((CharSequence)pos)) {
            throw new PreBidException("imp #%s: missing param pos".formatted(index));
        }
        return extImpYahooAds;
    }

    private BidRequest modifyRequest(BidRequest request, Imp imp, ExtImpYahooAds extImpYahooAds, Regs regs) {
        BidRequest.BidRequestBuilder requestBuilder = request.toBuilder();
        Site site = request.getSite();
        App app = request.getApp();
        if (site != null) {
            requestBuilder.site(site.toBuilder().id(extImpYahooAds.getDcn()).build());
        } else if (app != null) {
            requestBuilder.app(app.toBuilder().id(extImpYahooAds.getDcn()).build());
        }
        if (regs != null) {
            requestBuilder.regs(this.modifyRegs(regs));
        }
        return requestBuilder.imp(Collections.singletonList(YahooAdsBidder.modifyImp((Imp)imp, (ExtImpYahooAds)extImpYahooAds))).build();
    }

    private static Imp modifyImp(Imp imp, ExtImpYahooAds extImpYahooAds) {
        Banner banner = imp.getBanner();
        return imp.toBuilder().tagid(extImpYahooAds.getPos()).banner(banner != null ? YahooAdsBidder.modifyBanner((Banner)imp.getBanner()) : null).build();
    }

    private static void validateBanner(Banner banner) {
        boolean hasBannerWidthAndHeight;
        Integer bannerWidth = banner.getW();
        Integer bannerHeight = banner.getH();
        boolean bl = hasBannerWidthAndHeight = bannerWidth != null && bannerHeight != null;
        if (hasBannerWidthAndHeight && (bannerWidth == 0 || bannerHeight == 0)) {
            throw new PreBidException("Invalid sizes provided for Banner %sx%s".formatted(bannerWidth, bannerHeight));
        }
    }

    private static Banner modifyBanner(Banner banner) {
        YahooAdsBidder.validateBanner((Banner)banner);
        if (banner.getH() != null && banner.getW() != null) {
            return banner;
        }
        List bannerFormats = banner.getFormat();
        if (CollectionUtils.isEmpty((Collection)bannerFormats)) {
            throw new PreBidException("No sizes provided for Banner");
        }
        Format firstFormat = (Format)bannerFormats.get(0);
        return banner.toBuilder().w(firstFormat.getW()).h(firstFormat.getH()).build();
    }

    private Regs modifyRegs(Regs regs) {
        ExtRegs extRegs = this.resolveExtRegs(regs);
        return Regs.builder().ext(extRegs).build();
    }

    private ExtRegs resolveExtRegs(Regs regs) {
        Integer gdpr = YahooAdsBidder.resolveGdpr((Regs)regs);
        String usPrivacy = YahooAdsBidder.resolveUsPrivacy((Regs)regs);
        String gpp = regs.getGpp();
        List gppSid = regs.getGppSid();
        String gpc = Optional.ofNullable(regs.getExt()).map(ExtRegs::getGpc).orElse(null);
        ExtRegs extRegs = ExtRegs.of((Integer)gdpr, (String)usPrivacy, (String)gpc);
        extRegs.addProperty("gpp", (JsonNode)TextNode.valueOf((String)gpp));
        if (!CollectionUtils.isEmpty((Collection)gppSid)) {
            ArrayNode gppArrayNode = this.mapper.mapper().createArrayNode();
            gppSid.forEach(arg_0 -> ((ArrayNode)gppArrayNode).add(arg_0));
            extRegs.addProperty("gpp_sid", (JsonNode)gppArrayNode);
        }
        if (regs.getCoppa() != null) {
            extRegs.addProperty("coppa", (JsonNode)IntNode.valueOf((int)regs.getCoppa()));
        }
        Optional.ofNullable(regs.getExt()).map(FlexibleExtension::getProperties).ifPresent(arg_0 -> ((ExtRegs)extRegs).addProperties(arg_0));
        return extRegs;
    }

    private static Integer resolveGdpr(Regs regs) {
        return regs.getGdpr() != null ? regs.getGdpr() : (regs.getExt() != null ? regs.getExt().getGdpr() : null);
    }

    private static String resolveUsPrivacy(Regs regs) {
        return regs.getUsPrivacy() != null ? regs.getUsPrivacy() : (regs.getExt() != null ? regs.getExt().getUsPrivacy() : null);
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest outgoingRequest) {
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).body(this.mapper.encodeToBytes((Object)outgoingRequest)).headers(YahooAdsBidder.makeHeaders((Device)outgoingRequest.getDevice())).payload((Object)outgoingRequest).build();
    }

    private static MultiMap makeHeaders(Device device) {
        MultiMap headers = HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        String deviceUa = device != null ? device.getUa() : null;
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)deviceUa);
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)YahooAdsBidder.extractBids((BidResponse)bidResponse, (BidRequest)((BidRequest)httpCall.getRequest().getPayload())), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest) {
        List seatBids;
        List list = seatBids = bidResponse != null ? bidResponse.getSeatbid() : null;
        if (seatBids == null) {
            return Collections.emptyList();
        }
        if (seatBids.isEmpty()) {
            throw new PreBidException("Invalid SeatBids count: 0");
        }
        return YahooAdsBidder.bidsFromResponse((BidResponse)bidResponse, (List)bidRequest.getImp());
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse, List<Imp> imps) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> YahooAdsBidder.makeBidderBid((Bid)bid, (List)imps, (String)bidResponse.getCur())).filter(Objects::nonNull).toList();
    }

    private static BidderBid makeBidderBid(Bid bid, List<Imp> imps, String currency) {
        BidType bidType = YahooAdsBidder.getBidType((Bid)bid, imps);
        return bidType != null ? BidderBid.of((Bid)bid, (BidType)bidType, (String)currency) : null;
    }

    private static BidType getBidType(Bid bid, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(bid.getImpid())) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            return null;
        }
        throw new PreBidException("Unknown ad unit code '%s'".formatted(bid.getImpid()));
    }
}

