/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.vidoomy;

import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class VidoomyBidder
implements Bidder<BidRequest> {
    private static final String OPENRTB_VERSION = "2.5";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public VidoomyBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest> requests = new ArrayList<HttpRequest>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : request.getImp()) {
            try {
                Imp modifiedImp = VidoomyBidder.modifyImp((Imp)imp);
                requests.add(this.createRequest(request, modifiedImp));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return Result.of(requests, errors);
    }

    private static Imp modifyImp(Imp imp) {
        Banner banner = imp.getBanner();
        if (banner == null) {
            return imp;
        }
        Integer width = banner.getW();
        Integer height = banner.getH();
        List formats = banner.getFormat();
        VidoomyBidder.validateBannerSizes((Integer)width, (Integer)height, (List)formats);
        boolean useFormatSize = width == null || height == null;
        Format firstFormat = useFormatSize ? (Format)formats.get(0) : null;
        return imp.toBuilder().banner(banner.toBuilder().w(useFormatSize ? VidoomyBidder.zeroIfFormatMeasureNull((Format)firstFormat, Format::getW) : width).h(useFormatSize ? VidoomyBidder.zeroIfFormatMeasureNull((Format)firstFormat, Format::getH) : height).build()).build();
    }

    private static void validateBannerSizes(Integer width, Integer height, List<Format> formats) {
        boolean sizePresent;
        boolean bl = sizePresent = width != null && height != null;
        if (sizePresent && (width == 0 || height == 0)) {
            throw new PreBidException("invalid sizes provided for Banner %s x %s".formatted(width, height));
        }
        if (!sizePresent && CollectionUtils.isEmpty(formats)) {
            throw new PreBidException("no sizes provided for Banner []");
        }
    }

    private static Integer zeroIfFormatMeasureNull(Format format, Function<Format, Integer> measureExtractor) {
        return (Integer)ObjectUtils.defaultIfNull((Object)((Integer)ObjectUtil.getIfNotNull((Object)format, measureExtractor)), (Object)0);
    }

    private HttpRequest<BidRequest> createRequest(BidRequest bidRequest, Imp imp) {
        BidRequest outgoingRequest = bidRequest.toBuilder().imp(Collections.singletonList(imp)).build();
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(VidoomyBidder.headers((Device)bidRequest.getDevice())).payload((Object)outgoingRequest).body(this.mapper.encodeToBytes((Object)outgoingRequest)).build();
    }

    private static MultiMap headers(Device device) {
        MultiMap headers = HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIpv6());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
        }
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)VidoomyBidder.extractBids((BidResponse)bidResponse, (BidRequest)bidRequest));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)VidoomyBidder.getBidType((String)bid.getImpid(), (List)bidRequest.getImp()), (String)bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!Objects.equals(impId, imp.getId())) continue;
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getBanner() == null) continue;
            return BidType.banner;
        }
        throw new PreBidException("Unknown ad unit code '%s'".formatted(impId));
    }
}

