/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.trafficgate;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.trafficgate.ExtImpTrafficGate;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class TrafficGateBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpTrafficGate>> TAPX_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String SUBDOMAIN_MACRO = "{{subdomain}}";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public TrafficGateBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)endpointUrl);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        for (Imp imp : request.getImp()) {
            ExtImpTrafficGate extImpTrafficGate;
            try {
                extImpTrafficGate = this.parseImpExt(imp);
            }
            catch (PreBidException e) {
                return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
            }
            httpRequests.add(this.createSingleRequest(extImpTrafficGate, request));
        }
        return Result.withValues(httpRequests);
    }

    private HttpRequest<BidRequest> createSingleRequest(ExtImpTrafficGate extImpTrafficGate, BidRequest request) {
        return BidderUtil.defaultRequest((BidRequest)request, (String)this.resolveHost(extImpTrafficGate), (JacksonMapper)this.mapper);
    }

    private String resolveHost(ExtImpTrafficGate extImpTrafficGate) {
        return this.endpointUrl.replace("{{subdomain}}", extImpTrafficGate.getHost());
    }

    private ExtImpTrafficGate parseImpExt(Imp imp) {
        try {
            return (ExtImpTrafficGate)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), TAPX_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), (Throwable)e);
        }
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)TrafficGateBidder.extractBids((BidResponse)bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse) {
        return bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid()) ? Collections.emptyList() : TrafficGateBidder.bidsFromResponse((BidResponse)bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)TrafficGateBidder.getBidType((ObjectNode)bid.getExt()), (String)bidResponse.getCur())).toList();
    }

    private static BidType getBidType(ObjectNode bidExt) {
        return Optional.ofNullable(bidExt).map(ext -> ext.get("prebid")).map(prebid -> prebid.get("type")).filter(JsonNode::isTextual).map(JsonNode::asText).map(BidType::fromString).orElse(BidType.banner);
    }
}

