/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.taboola;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.taboola.TaboolaBidder;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.model.UpdateResult;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.taboola.ExtImpTaboola;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.spring.config.bidder.model.MediaType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class TaboolaBidder
implements Bidder<BidRequest> {
    private static final String DISPLAY_ENDPOINT_PREFIX = "display";
    private static final String NATIVE_ENDPOINT_PREFIX = "native";
    private static final String PRICE_MACRO = "${AUCTION_PRICE}";
    private static final TypeReference<ExtPrebid<?, ExtImpTaboola>> TABOOLA_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointTemplate;
    private final String gvlId;
    private final JacksonMapper mapper;

    public TaboolaBidder(String endpointTemplate, Integer gvlId, JacksonMapper mapper) {
        this.endpointTemplate = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointTemplate));
        this.gvlId = gvlId != null ? String.valueOf(gvlId) : "";
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        HashMap<MediaType, List> mediaTypeToImps = new HashMap<MediaType, List>();
        ExtImpTaboola extImpTaboola = null;
        for (Imp imp : request.getImp()) {
            try {
                extImpTaboola = this.parseImpExt(imp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
                continue;
            }
            MediaType impMediaType = TaboolaBidder.getMediaType((Imp)imp);
            if (impMediaType == null) continue;
            Imp modifiedImp = TaboolaBidder.modifyImp((Imp)imp, (ExtImpTaboola)extImpTaboola);
            mediaTypeToImps.computeIfAbsent(impMediaType, key -> new ArrayList()).add(modifiedImp);
        }
        if (!errors.isEmpty()) {
            return Result.withErrors(errors);
        }
        ExtImpTaboola lastExtImp = extImpTaboola != null ? extImpTaboola : ExtImpTaboola.empty();
        List<HttpRequest> httpRequests = mediaTypeToImps.entrySet().stream().map(entry -> this.createHttpRequest((MediaType)entry.getKey(), this.createRequest(request, (List)entry.getValue(), lastExtImp))).toList();
        return Result.withValues(httpRequests);
    }

    private static MediaType getMediaType(Imp imp) {
        if (imp.getBanner() != null) {
            return MediaType.BANNER;
        }
        if (imp.getXNative() != null) {
            return MediaType.NATIVE;
        }
        return null;
    }

    private ExtImpTaboola parseImpExt(Imp imp) throws PreBidException {
        try {
            return (ExtImpTaboola)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), TABOOLA_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private static Imp modifyImp(Imp imp, ExtImpTaboola impExt) {
        String impExtTagId = impExt.getTagId();
        UpdateResult resolvedTagId = StringUtils.length((CharSequence)impExtTagId) < 1 ? UpdateResult.updated((Object)impExt.getLowerCaseTagId()) : UpdateResult.updated((Object)impExtTagId);
        BigDecimal impExtBidFloor = impExt.getBidFloor();
        UpdateResult resolvedBidFloor = BidderUtil.isValidPrice((BigDecimal)impExtBidFloor) ? UpdateResult.updated((Object)impExtBidFloor) : UpdateResult.unaltered((Object)imp.getBidfloor());
        Banner impBanner = imp.getBanner();
        Integer impExtPos = impExt.getPosition();
        UpdateResult resolvedBanner = impBanner != null && impExtPos != null ? UpdateResult.updated((Object)impBanner.toBuilder().pos(impExtPos).build()) : UpdateResult.unaltered((Object)impBanner);
        return resolvedTagId.isUpdated() || resolvedBidFloor.isUpdated() || resolvedBanner.isUpdated() ? imp.toBuilder().tagid((String)resolvedTagId.getValue()).bidfloor((BigDecimal)resolvedBidFloor.getValue()).banner((Banner)resolvedBanner.getValue()).build() : imp;
    }

    private BidRequest createRequest(BidRequest request, List<Imp> imps, ExtImpTaboola impExt) {
        String impExtPublisherId = StringUtils.defaultString((String)impExt.getPublisherId());
        List impExtBAdv = impExt.getBAdv();
        List impExtBCat = impExt.getBCat();
        String impExtPageType = impExt.getPageType();
        Site site = Optional.ofNullable(request.getSite()).map(Site::toBuilder).orElseGet(Site::builder).id(impExtPublisherId).name(impExtPublisherId).domain(this.resolveDomain(impExt.getPublisherDomain(), request)).publisher(Publisher.builder().id(impExtPublisherId).build()).build();
        ExtRequest extRequest = StringUtils.isNotEmpty((CharSequence)impExtPageType) ? this.createExtRequest(impExtPageType) : request.getExt();
        return request.toBuilder().imp(imps).site(site).badv(CollectionUtils.isNotEmpty((Collection)impExtBAdv) ? impExtBAdv : request.getBadv()).bcat(CollectionUtils.isNotEmpty((Collection)impExtBCat) ? impExtBCat : request.getBcat()).ext(extRequest).build();
    }

    private String resolveDomain(String impExtPublisherDomain, BidRequest request) {
        return StringUtils.isNotEmpty((CharSequence)impExtPublisherDomain) ? impExtPublisherDomain : Optional.ofNullable(request.getSite()).map(Site::getDomain).orElse("");
    }

    private ExtRequest createExtRequest(String pageType) {
        ExtRequest extRequest = ExtRequest.empty();
        ObjectNode objectNode = this.mapper.mapper().createObjectNode().put("pageType", pageType);
        return (ExtRequest)this.mapper.fillExtension((FlexibleExtension)extRequest, (Object)objectNode);
    }

    private HttpRequest<BidRequest> createHttpRequest(MediaType type, BidRequest outgoingRequest) {
        return BidderUtil.defaultRequest((BidRequest)outgoingRequest, (String)this.buildEndpointUrl(outgoingRequest.getSite().getId(), type), (JacksonMapper)this.mapper);
    }

    private String buildEndpointUrl(String publisherId, MediaType mediaType) {
        String type = switch (2.$SwitchMap$org$prebid$server$spring$config$bidder$model$MediaType[mediaType.ordinal()]) {
            case 1 -> "display";
            case 2 -> "native";
            default -> throw new AssertionError();
        };
        return this.endpointTemplate.replace("{{GvlID}}", this.gvlId).replace("{{MediaType}}", type).replace("{{PublisherID}}", HttpUtil.encodeUrl((String)publisherId));
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        BidResponse bidResponse;
        try {
            bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
        ArrayList errors = new ArrayList();
        List bids = this.extractBids((BidRequest)httpCall.getRequest().getPayload(), bidResponse, errors);
        return Result.of((Object)bids, errors);
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidRequest, bidResponse, errors);
    }

    private List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse, List<BidderError> errors) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> this.resolveBidderBid(bidResponse.getCur(), bidRequest.getImp(), bid, errors)).filter(Objects::nonNull).toList();
    }

    private BidderBid resolveBidderBid(String currency, List<Imp> imps, Bid bid, List<BidderError> errors) {
        try {
            return BidderBid.of((Bid)TaboolaBidder.resolveMacros((Bid)bid), (BidType)this.resolveBidType(bid.getImpid(), imps), (String)currency);
        }
        catch (PreBidException e) {
            errors.add(BidderError.badServerResponse((String)e.getMessage()));
            return null;
        }
    }

    private BidType resolveBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getXNative() == null) continue;
            return BidType.xNative;
        }
        throw new PreBidException("Failed to find banner/native impression \"%s\"".formatted(impId));
    }

    private static Bid resolveMacros(Bid bid) {
        BigDecimal price = bid.getPrice();
        String priceAsString = price != null ? price.toPlainString() : "0";
        return bid.toBuilder().nurl(StringUtils.replace((String)bid.getNurl(), (String)"${AUCTION_PRICE}", (String)priceAsString)).adm(StringUtils.replace((String)bid.getAdm(), (String)"${AUCTION_PRICE}", (String)priceAsString)).build();
    }
}

