/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.smarthub;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.smarthub.ExtImpSmarthub;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

public class SmarthubBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpSmarthub>> SMARTHUB_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointTemplate;
    private final JacksonMapper mapper;

    public SmarthubBidder(String endpointTemplate, JacksonMapper mapper) {
        this.endpointTemplate = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointTemplate));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ExtImpSmarthub extImpSmarthub;
        Imp firstImp = (Imp)request.getImp().get(0);
        try {
            extImpSmarthub = (ExtImpSmarthub)((ExtPrebid)this.mapper.mapper().convertValue((Object)firstImp.getExt(), SMARTHUB_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        return Result.withValue((Object)HttpRequest.builder().method(HttpMethod.POST).body(this.mapper.encodeToBytes((Object)request)).uri(this.buildEndpointUrl(extImpSmarthub)).payload((Object)request).headers(this.resolveHeaders()).build());
    }

    private MultiMap resolveHeaders() {
        return HttpUtil.headers().add("Prebid-Adapter-Ver", "1.0.0");
    }

    private String buildEndpointUrl(ExtImpSmarthub extImpSmarthub) {
        return this.endpointTemplate.replace("{{Host}}", extImpSmarthub.getPartnerName()).replace("{{AccountID}}", extImpSmarthub.getSeat()).replace("{{SourceId}}", extImpSmarthub.getToken());
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)this.extractBids(bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse) {
        Bid firstBid;
        List seatBid = bidResponse != null ? bidResponse.getSeatbid() : null;
        SeatBid firstSeatBid = CollectionUtils.isNotEmpty((Collection)seatBid) ? (SeatBid)seatBid.get(0) : null;
        List bids = firstSeatBid != null ? firstSeatBid.getBid() : null;
        Bid bid = firstBid = CollectionUtils.isNotEmpty((Collection)bids) ? (Bid)bids.get(0) : null;
        if (firstBid == null) {
            throw new PreBidException("SeatBid[0].Bid[0] cannot be empty");
        }
        return Collections.singletonList(this.toBidderBid(bidResponse, firstBid));
    }

    private BidderBid toBidderBid(BidResponse bidResponse, Bid bid) {
        try {
            return BidderBid.of((Bid)bid, (BidType)this.getBidType(bid.getExt()), (String)bidResponse.getCur());
        }
        catch (IllegalArgumentException | PreBidException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private BidType getBidType(ObjectNode bidExt) {
        JsonNode typeNode;
        JsonNode jsonNode = typeNode = bidExt != null && !bidExt.isEmpty() ? bidExt.get("mediaType") : null;
        if (typeNode == null || !typeNode.isTextual()) {
            throw new PreBidException("missing bid ext");
        }
        return (BidType)this.mapper.mapper().convertValue((Object)typeNode.asText(), BidType.class);
    }
}

