/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.silverpush;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.node.TextNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Eid;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Uid;
import com.iab.openrtb.request.User;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.silverpush.SilverPushDeviceTypeResolver;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.silverpush.ExtImpSilverPush;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class SilverPushBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpSilverPush>> TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String X_OPENRTB_VERSION = "2.5";
    private static final BigDecimal BANNER_BIDFLOOR = BigDecimal.valueOf(0.05);
    private static final BigDecimal VIDEO_BIDFLOOR = BigDecimal.valueOf(0.1);
    private static final int DEFAULT_MAX_DURATION = 120;
    private static final int DEFAULT_MIN_DURATION = 0;
    private static final String BIDDER_CONFIG = "sp_pb_ortb";
    private static final String BIDDER_VERSION = "1.0.0";
    private static final String BIDDER_CONFIG_PROPERTY = "bc";
    private static final String PUBLISHER_ID_PROPERTY = "publisherId";
    private static final String EIDS_NODE_PATH = "eids";
    private final String endpointUrl;
    private final JacksonMapper mapper;
    private final ObjectReader reader;

    public SilverPushBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
        this.reader = mapper.mapper().readerFor((TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest> requests = new ArrayList<HttpRequest>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpSilverPush impExt = this.parseImpExt(imp);
                if (StringUtils.isBlank((CharSequence)impExt.getPublisherId())) {
                    throw new PreBidException("Missing publisherId parameter.");
                }
                BidRequest resolvedBidRequest = this.resolveBidRequest(request, imp, impExt);
                requests.add(this.createRequest(resolvedBidRequest));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return Result.of(requests, errors);
    }

    private ExtImpSilverPush parseImpExt(Imp imp) {
        try {
            return (ExtImpSilverPush)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private BidRequest resolveBidRequest(BidRequest bidRequest, Imp imp, ExtImpSilverPush extImpSilverPush) {
        String publisherId = extImpSilverPush.getPublisherId();
        return bidRequest.toBuilder().user(this.resolveUser(bidRequest.getUser())).device(SilverPushBidder.resolveDevice((Device)bidRequest.getDevice())).site(SilverPushBidder.resolveSite((Site)bidRequest.getSite(), (String)publisherId)).app(SilverPushBidder.resolveApp((App)bidRequest.getApp(), (String)publisherId)).ext(SilverPushBidder.resolveExtRequest((String)publisherId)).imp(Collections.singletonList(SilverPushBidder.resolveImp((Imp)imp, (ExtImpSilverPush)extImpSilverPush))).build();
    }

    private User resolveUser(User user) {
        ExtUser extUser;
        ExtUser extUser2 = extUser = user != null ? user.getExt() : null;
        if (extUser == null) {
            return user;
        }
        List dataEids = Optional.ofNullable(extUser.getData()).map(dataNode -> dataNode.get("eids")).filter(node -> !node.isMissingNode()).map(arg_0 -> this.castEids(arg_0)).orElse(null);
        if (!SilverPushBidder.isValidEids((List)dataEids)) {
            return user;
        }
        ExtUser resolvedExtUser = ExtUser.builder().eids(dataEids).build();
        return user.toBuilder().ext(resolvedExtUser).build();
    }

    private List<Eid> castEids(JsonNode eidsNode) {
        try {
            return (List)this.reader.readValue(eidsNode);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static boolean isValidEids(List<Eid> eids) {
        if (CollectionUtils.isEmpty(eids)) {
            return true;
        }
        for (Eid eid : eids) {
            List uids = eid.getUids();
            if (!CollectionUtils.isNotEmpty((Collection)uids) || !StringUtils.isNotBlank((CharSequence)((Uid)uids.get(0)).getId())) continue;
            return true;
        }
        return false;
    }

    private static Device resolveDevice(Device device) {
        String userAgent;
        String string = userAgent = device != null ? device.getUa() : null;
        if (StringUtils.isBlank((CharSequence)userAgent)) {
            return device;
        }
        return device.toBuilder().os(SilverPushDeviceTypeResolver.resolveOs((String)userAgent)).devicetype(SilverPushDeviceTypeResolver.resolveDeviceType((String)userAgent)).build();
    }

    private static Site resolveSite(Site site, String publisherId) {
        if (site == null) {
            return null;
        }
        return site.toBuilder().publisher(SilverPushBidder.resolvePublisher((Publisher)site.getPublisher(), (String)publisherId)).build();
    }

    private static Publisher resolvePublisher(Publisher publisher, String publisherId) {
        return publisher != null ? publisher.toBuilder().id(publisherId).build() : Publisher.builder().id(publisherId).build();
    }

    private static App resolveApp(App app, String publisherId) {
        if (app == null) {
            return null;
        }
        return app.toBuilder().publisher(SilverPushBidder.resolvePublisher((Publisher)app.getPublisher(), (String)publisherId)).build();
    }

    private static ExtRequest resolveExtRequest(String publisherId) {
        ExtRequest extRequest = ExtRequest.empty();
        extRequest.addProperty("bc", (JsonNode)TextNode.valueOf((String)"sp_pb_ortb_1.0.0"));
        extRequest.addProperty("publisherId", (JsonNode)TextNode.valueOf((String)publisherId));
        return extRequest;
    }

    private static Imp resolveImp(Imp imp, ExtImpSilverPush extImpSilverPush) {
        Banner banner = SilverPushBidder.resolveBanner((Banner)imp.getBanner());
        boolean bannerPresent = banner != null;
        Video video = bannerPresent ? null : SilverPushBidder.resolveVideo((Video)imp.getVideo());
        BigDecimal extBidFloor = extImpSilverPush.getBidFloor();
        BigDecimal bidFloorFallback = bannerPresent ? BANNER_BIDFLOOR : VIDEO_BIDFLOOR;
        return imp.toBuilder().banner(banner).video(video).bidfloor(BidderUtil.isValidPrice((BigDecimal)extBidFloor) ? extBidFloor : bidFloorFallback).build();
    }

    private static Banner resolveBanner(Banner banner) {
        if (banner == null || SilverPushBidder.isNonNegative((Integer)banner.getW()) && SilverPushBidder.isNonNegative((Integer)banner.getH())) {
            return banner;
        }
        if (CollectionUtils.isEmpty((Collection)banner.getFormat())) {
            throw new PreBidException("No sizes provided for Banner.");
        }
        Format firstFormat = (Format)banner.getFormat().get(0);
        return banner.toBuilder().w(firstFormat.getW()).h(firstFormat.getH()).build();
    }

    private static Video resolveVideo(Video video) {
        if (video == null) {
            return null;
        }
        Integer minDuration = video.getMinduration();
        Integer maxDuration = video.getMaxduration();
        if (CollectionUtils.isEmpty((Collection)video.getApi()) || CollectionUtils.isEmpty((Collection)video.getMimes()) || CollectionUtils.isEmpty((Collection)video.getProtocols()) || !SilverPushBidder.isNonNegative((Integer)minDuration)) {
            throw new PreBidException("Invalid or missing video field(s)");
        }
        boolean validMaxDuration = SilverPushBidder.isNonNegative((Integer)maxDuration);
        if (validMaxDuration && maxDuration > minDuration) {
            return video;
        }
        Integer resolvedMaxDuration = validMaxDuration && maxDuration != 0 ? maxDuration : 120;
        return video.toBuilder().maxduration(resolvedMaxDuration).minduration(Integer.valueOf(resolvedMaxDuration > minDuration ? minDuration : 0)).build();
    }

    private static boolean isNonNegative(Integer value) {
        return value != null && value >= 0;
    }

    private HttpRequest<BidRequest> createRequest(BidRequest request) {
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).headers(SilverPushBidder.makeHeaders()).impIds(BidderUtil.impIds((BidRequest)request)).body(this.mapper.encodeToBytes((Object)request)).payload((Object)request).build();
    }

    private static MultiMap makeHeaders() {
        MultiMap headers = HttpUtil.headers();
        headers.set(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)SilverPushBidder.extractBids((BidResponse)bidResponse));
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)"Bad Server Response"));
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            throw new PreBidException("Empty SeatBid array");
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)SilverPushBidder.getBidMediaType((Bid)bid), (String)bidResponse.getCur())).toList();
    }

    private static BidType getBidMediaType(Bid bid) {
        Integer markupType = bid.getMtype();
        if (markupType == null) {
            throw new PreBidException("Missing MType for bid: " + bid.getId());
        }
        return switch (markupType) {
            case 1 -> BidType.banner;
            case 2 -> BidType.video;
            default -> throw new PreBidException("Unable to resolve mediaType " + bid.getMtype() + " for bid: " + bid.getId());
        };
    }
}

