/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.screencore;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.screencore.ScreencoreImpExt;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScreencoreBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ScreencoreImpExt>> TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String ACCOUNT_ID_MACRO = "{{AccountId}}";
    private static final String SOURCE_ID_MACRO = "{{SourceId}}";
    private static final String X_OPENRTB_VERSION = "2.5";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public ScreencoreBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ScreencoreImpExt impExt;
        Imp firstImp = (Imp)request.getImp().get(0);
        try {
            impExt = this.parseImpExt(firstImp);
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        BidRequest bidRequest = ScreencoreBidder.cleanUpFirstImpExt((BidRequest)request);
        HttpRequest httpRequest = this.makeHttpRequest(request, impExt, bidRequest);
        return Result.withValue((Object)httpRequest);
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest request, ScreencoreImpExt impExt, BidRequest bidRequest) {
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.resolveEndpoint(impExt)).headers(ScreencoreBidder.makeHeaders((BidRequest)request)).impIds(BidderUtil.impIds((BidRequest)bidRequest)).body(this.mapper.encodeToBytes((Object)bidRequest)).payload((Object)bidRequest).build();
    }

    private ScreencoreImpExt parseImpExt(Imp imp) {
        try {
            return (ScreencoreImpExt)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private static BidRequest cleanUpFirstImpExt(BidRequest request) {
        ArrayList<Imp> imps = new ArrayList<Imp>(request.getImp());
        imps.set(0, ((Imp)request.getImp().get(0)).toBuilder().ext(null).build());
        return request.toBuilder().imp(imps).build();
    }

    private String resolveEndpoint(ScreencoreImpExt impExt) {
        return this.endpointUrl.replace("{{AccountId}}", HttpUtil.encodeUrl((String)impExt.getAccountId())).replace("{{SourceId}}", HttpUtil.encodeUrl((String)impExt.getPlacementId()));
    }

    private static MultiMap makeHeaders(BidRequest bidRequest) {
        Device device = bidRequest.getDevice();
        MultiMap headers = HttpUtil.headers();
        headers.set(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)((CharSequence)ObjectUtil.getIfNotNull((Object)device, Device::getUa)));
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)((CharSequence)ObjectUtil.getIfNotNull((Object)device, Device::getIpv6)));
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)((CharSequence)ObjectUtil.getIfNotNull((Object)device, Device::getIp)));
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)ScreencoreBidder.extractBids((BidResponse)bidResponse));
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)"Bad Server Response"));
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            throw new PreBidException("Empty SeatBid array");
        }
        return bidResponse.getSeatbid().stream().flatMap(seatBid -> Optional.ofNullable(seatBid.getBid()).orElse(List.of()).stream()).map(bid -> BidderBid.of((Bid)bid, (BidType)ScreencoreBidder.getBidMediaType((Bid)bid), (String)bidResponse.getCur())).toList();
    }

    private static BidType getBidMediaType(Bid bid) {
        Integer markupType = bid.getMtype();
        if (markupType == null) {
            throw new PreBidException("Missing MType for bid: " + bid.getId());
        }
        return switch (markupType) {
            case 1 -> BidType.banner;
            case 2 -> BidType.video;
            case 4 -> BidType.xNative;
            default -> throw new PreBidException("Unable to fetch mediaType " + bid.getMtype() + " in multi-format: " + bid.getImpid());
        };
    }
}

