/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.pubnative;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.pubnative.ExtImpPubnative;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class PubnativeBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpPubnative>> PUBNATIVE_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String PUBNATIVE_CURRENCY = "USD";
    private final String endpointUrl;
    private final JacksonMapper mapper;
    private final CurrencyConversionService currencyConversionService;

    public PubnativeBidder(String endpointUrl, JacksonMapper mapper, CurrencyConversionService currencyConversionService) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
        this.currencyConversionService = Objects.requireNonNull(currencyConversionService);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        Device device = bidRequest.getDevice();
        if (device == null || StringUtils.isBlank((CharSequence)device.getOs())) {
            return Result.withError((BidderError)BidderError.badInput((String)"Impression is missing device OS information"));
        }
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (Imp imp : bidRequest.getImp()) {
            try {
                PubnativeBidder.validateImp((Imp)imp);
                ExtImpPubnative extImpPubnative = this.parseImpExt(imp.getExt());
                BidRequest outgoingRequest = this.createRequest(bidRequest, imp);
                httpRequests.add(this.createHttpRequest(outgoingRequest, extImpPubnative));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return Result.of(httpRequests, errors);
    }

    private static void validateImp(Imp imp) {
        if (imp.getBanner() == null && imp.getVideo() == null && imp.getXNative() == null) {
            throw new PreBidException("Pubnative only supports banner, video or native ads.");
        }
    }

    private ExtImpPubnative parseImpExt(ObjectNode impExt) {
        try {
            return (ExtImpPubnative)((ExtPrebid)this.mapper.mapper().convertValue((Object)impExt, PUBNATIVE_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private BidRequest createRequest(BidRequest bidRequest, Imp imp) {
        return bidRequest.toBuilder().cur(Collections.singletonList("USD")).imp(Collections.singletonList(this.resolveImp(bidRequest, imp))).build();
    }

    private Imp resolveImp(BidRequest bidRequest, Imp imp) {
        Banner resolvedBanner = PubnativeBidder.resolveBanner((Banner)imp.getBanner());
        BigDecimal resolvedBidFloor = this.resolveBidFloor(bidRequest, imp);
        return resolvedBanner == null && resolvedBidFloor == null ? imp : imp.toBuilder().banner((Banner)ObjectUtils.defaultIfNull((Object)resolvedBanner, (Object)imp.getBanner())).bidfloor((BigDecimal)ObjectUtils.defaultIfNull((Object)resolvedBidFloor, (Object)imp.getBidfloor())).bidfloorcur(resolvedBidFloor == null ? imp.getBidfloorcur() : "USD").build();
    }

    private static Banner resolveBanner(Banner banner) {
        if (banner != null) {
            Integer width = banner.getW();
            Integer height = banner.getH();
            if (width == null || width == 0 || height == null || height == 0) {
                List formats = banner.getFormat();
                if (CollectionUtils.isEmpty((Collection)formats)) {
                    throw new PreBidException("Size information missing for banner");
                }
                Format firstFormat = (Format)formats.get(0);
                return banner.toBuilder().w(firstFormat.getW()).h(firstFormat.getH()).build();
            }
        }
        return null;
    }

    private BigDecimal resolveBidFloor(BidRequest bidRequest, Imp imp) {
        BigDecimal bidFloor = imp.getBidfloor();
        String bidFloorCur = PubnativeBidder.resolveBidFloorCurrency((BidRequest)bidRequest, (String)imp.getBidfloorcur());
        if (!BidderUtil.isValidPrice((BigDecimal)bidFloor) || StringUtils.equals((CharSequence)bidFloorCur, (CharSequence)"USD") || StringUtils.isEmpty((CharSequence)bidFloorCur)) {
            return null;
        }
        return this.currencyConversionService.convertCurrency(bidFloor, bidRequest, bidFloorCur, "USD");
    }

    private static String resolveBidFloorCurrency(BidRequest bidRequest, String bidFloorCurrency) {
        if (StringUtils.isNotEmpty((CharSequence)bidFloorCurrency)) {
            return bidFloorCurrency;
        }
        List bidRequestCurrencies = bidRequest.getCur();
        return CollectionUtils.isNotEmpty((Collection)bidRequestCurrencies) ? (String)bidRequestCurrencies.get(0) : null;
    }

    private HttpRequest<BidRequest> createHttpRequest(BidRequest outgoingRequest, ExtImpPubnative impExt) {
        String requestUri = "%s?apptoken=%s&zoneid=%s".formatted(this.endpointUrl, impExt.getAppAuthToken(), impExt.getZoneId());
        return BidderUtil.defaultRequest((BidRequest)outgoingRequest, (String)requestUri, (JacksonMapper)this.mapper);
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)PubnativeBidder.extractBids((BidResponse)bidResponse, (BidRequest)((BidRequest)httpCall.getRequest().getPayload())), Collections.emptyList());
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest) {
        return bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid()) ? Collections.emptyList() : PubnativeBidder.bidsFromResponse((List)bidResponse.getSeatbid(), (List)bidRequest.getImp(), (String)bidResponse.getCur());
    }

    private static List<BidderBid> bidsFromResponse(List<SeatBid> seatbid, List<Imp> imps, String currency) {
        return seatbid.stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> PubnativeBidder.createBidderBid((List)imps, (String)currency, (Bid)bid)).toList();
    }

    private static BidderBid createBidderBid(List<Imp> imps, String currency, Bid bid) {
        Imp imp = PubnativeBidder.findImpById((String)bid.getImpid(), imps);
        return BidderBid.of((Bid)PubnativeBidder.updateBidWithSize((Bid)bid, (Imp)imp), (BidType)PubnativeBidder.resolveBidType((Imp)imp), (String)currency);
    }

    private static Bid updateBidWithSize(Bid bid, Imp imp) {
        if (bid.getW() != null && bid.getH() != null) {
            return bid;
        }
        Format format = imp != null && imp.getBanner() != null ? PubnativeBidder.resolveBidSizeFromBanner((Banner)imp.getBanner()) : null;
        return format != null ? bid.toBuilder().w(format.getW()).h(format.getH()).build() : bid;
    }

    private static Imp findImpById(String impId, List<Imp> imps) {
        return imps.stream().filter(imp -> imp.getId().equals(impId)).findFirst().orElse(null);
    }

    private static BidType resolveBidType(Imp imp) {
        if (imp == null) {
            return BidType.banner;
        }
        if (imp.getVideo() != null) {
            return BidType.video;
        }
        if (imp.getXNative() != null) {
            return BidType.xNative;
        }
        return BidType.banner;
    }

    private static Format resolveBidSizeFromBanner(Banner banner) {
        Format result = null;
        Integer width = banner.getW();
        Integer height = banner.getH();
        List formats = banner.getFormat();
        if (width != null && height != null) {
            result = PubnativeBidder.isOnlyOneSize((Integer)width, (Integer)height, (List)formats) ? Format.builder().w(width).h(height).build() : null;
        } else if (formats.size() == 1) {
            result = (Format)formats.get(0);
        }
        return result;
    }

    private static boolean isOnlyOneSize(Integer width, Integer height, List<Format> formats) {
        return CollectionUtils.isEmpty(formats) || formats.size() == 1 && PubnativeBidder.isSameFormat((Integer)width, (Integer)height, (Format)formats.get(0));
    }

    private static boolean isSameFormat(Integer width, Integer height, Format format) {
        return width.equals(format.getW()) && height.equals(format.getH());
    }
}

