/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.openx;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.CompositeBidderResponse;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.bidder.openx.model.OpenxImpType;
import org.prebid.server.bidder.openx.proto.OpenxBidResponse;
import org.prebid.server.bidder.openx.proto.OpenxBidResponseExt;
import org.prebid.server.bidder.openx.proto.OpenxRequestExt;
import org.prebid.server.bidder.openx.proto.OpenxVideoExt;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtImpPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtRequest;
import org.prebid.server.proto.openrtb.ext.request.openx.ExtImpOpenx;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.proto.openrtb.ext.response.FledgeAuctionConfig;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class OpenxBidder
implements Bidder<BidRequest> {
    private static final String OPENX_CONFIG = "hb_pbs_1.0.0";
    private static final String DEFAULT_BID_CURRENCY = "USD";
    private static final String CUSTOM_PARAMS_KEY = "customParams";
    private static final String BIDDER_EXT = "bidder";
    private static final String PREBID_EXT = "prebid";
    private static final Set<String> IMP_EXT_SKIP_FIELDS = Set.of("bidder", "prebid");
    private static final TypeReference<ExtPrebid<ExtImpPrebid, ExtImpOpenx>> OPENX_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public OpenxBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        Map<OpenxImpType, List<Imp>> differentiatedImps = bidRequest.getImp().stream().collect(Collectors.groupingBy(OpenxBidder::resolveImpType));
        ArrayList processingErrors = new ArrayList();
        List outgoingRequests = this.makeRequests(bidRequest, differentiatedImps.get(OpenxImpType.banner), differentiatedImps.get(OpenxImpType.video), processingErrors);
        List errors = this.errors(differentiatedImps.get(OpenxImpType.other), processingErrors);
        return Result.of((Object)this.createHttpRequests(outgoingRequests), (List)errors);
    }

    public CompositeBidderResponse makeBidderResponse(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            OpenxBidResponse bidResponse = (OpenxBidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), OpenxBidResponse.class);
            return CompositeBidderResponse.withBids((List)OpenxBidder.extractBids((BidRequest)bidRequest, (OpenxBidResponse)bidResponse), (List)OpenxBidder.extractFledge((OpenxBidResponse)bidResponse));
        }
        catch (DecodeException e) {
            return CompositeBidderResponse.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    @Deprecated(forRemoval=true)
    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        return Result.withError((BidderError)BidderError.generic((String)"Deprecated adapter method invoked"));
    }

    private List<BidRequest> makeRequests(BidRequest bidRequest, List<Imp> bannerImps, List<Imp> videoImps, List<BidderError> errors) {
        ArrayList<BidRequest> bidRequests = new ArrayList<BidRequest>();
        BidRequest bannerRequest = this.createSingleRequest(bannerImps, bidRequest, errors);
        if (bannerRequest != null) {
            bidRequests.add(bannerRequest);
        }
        if (CollectionUtils.isNotEmpty(videoImps)) {
            bidRequests.addAll(videoImps.stream().map(Collections::singletonList).map(imps -> this.createSingleRequest(imps, bidRequest, errors)).filter(Objects::nonNull).toList());
        }
        return bidRequests;
    }

    private static OpenxImpType resolveImpType(Imp imp) {
        if (imp.getBanner() != null) {
            return OpenxImpType.banner;
        }
        if (imp.getVideo() != null) {
            return OpenxImpType.video;
        }
        return OpenxImpType.other;
    }

    private List<BidderError> errors(List<Imp> notSupportedImps, List<BidderError> processingErrors) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        if (CollectionUtils.isNotEmpty(notSupportedImps)) {
            errors.addAll(notSupportedImps.stream().map(imp -> "OpenX only supports banner and video imps. Ignoring imp id=" + imp.getId()).map(BidderError::badInput).toList());
        }
        errors.addAll(processingErrors);
        return errors;
    }

    private List<HttpRequest<BidRequest>> createHttpRequests(List<BidRequest> bidRequests) {
        return bidRequests.stream().filter(Objects::nonNull).map(singleBidRequest -> BidderUtil.defaultRequest((BidRequest)singleBidRequest, (String)this.endpointUrl, (JacksonMapper)this.mapper)).toList();
    }

    private BidRequest createSingleRequest(List<Imp> imps, BidRequest bidRequest, List<BidderError> errors) {
        if (CollectionUtils.isEmpty(imps)) {
            return null;
        }
        List<Imp> processedImps = null;
        try {
            processedImps = imps.stream().map(arg_0 -> this.makeImp(arg_0)).toList();
        }
        catch (PreBidException e) {
            errors.add(BidderError.badInput((String)e.getMessage()));
        }
        return CollectionUtils.isNotEmpty(processedImps) ? bidRequest.toBuilder().imp(processedImps).ext(this.makeReqExt(imps.get(0))).build() : null;
    }

    private Imp makeImp(Imp imp) {
        ExtPrebid impExt = this.parseOpenxExt(imp);
        ExtImpOpenx openxImpExt = (ExtImpOpenx)impExt.getBidder();
        ExtImpPrebid prebidImpExt = (ExtImpPrebid)impExt.getPrebid();
        Imp.ImpBuilder impBuilder = imp.toBuilder().tagid(openxImpExt.getUnit()).bidfloor(OpenxBidder.resolveBidFloor((BigDecimal)imp.getBidfloor(), (BigDecimal)openxImpExt.getCustomFloor())).ext(this.makeImpExt(imp.getExt(), MapUtils.isNotEmpty((Map)openxImpExt.getCustomParams())));
        if (OpenxBidder.resolveImpType((Imp)imp) == OpenxImpType.video && prebidImpExt != null && Objects.equals(prebidImpExt.getIsRewardedInventory(), 1)) {
            impBuilder.video(imp.getVideo().toBuilder().ext((ObjectNode)this.mapper.mapper().valueToTree((Object)OpenxVideoExt.of((Integer)1))).build());
        }
        return impBuilder.build();
    }

    private static BigDecimal resolveBidFloor(BigDecimal impBidFloor, BigDecimal customFloor) {
        return !BidderUtil.isValidPrice((BigDecimal)impBidFloor) && BidderUtil.isValidPrice((BigDecimal)customFloor) ? customFloor : impBidFloor;
    }

    private ExtRequest makeReqExt(Imp imp) {
        ExtImpOpenx openxImpExt = (ExtImpOpenx)this.parseOpenxExt(imp).getBidder();
        return (ExtRequest)this.mapper.fillExtension((FlexibleExtension)ExtRequest.empty(), (Object)OpenxRequestExt.of((String)openxImpExt.getDelDomain(), (String)openxImpExt.getPlatform(), (String)"hb_pbs_1.0.0"));
    }

    private ExtPrebid<ExtImpPrebid, ExtImpOpenx> parseOpenxExt(Imp imp) {
        ExtImpOpenx impExtOpenx;
        ExtPrebid impExt;
        ObjectNode impExtRaw = imp.getExt();
        if (impExtRaw == null) {
            throw new PreBidException("openx parameters section is missing");
        }
        try {
            impExt = (ExtPrebid)this.mapper.mapper().convertValue((Object)impExtRaw, OPENX_EXT_TYPE_REFERENCE);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
        ExtImpOpenx extImpOpenx = impExtOpenx = impExt != null ? (ExtImpOpenx)impExt.getBidder() : null;
        if (impExtOpenx == null) {
            throw new PreBidException("openx parameters section is missing");
        }
        return impExt;
    }

    private ObjectNode makeImpExt(ObjectNode impExt, boolean addCustomParams) {
        ObjectNode openxImpExt = impExt.deepCopy();
        openxImpExt.remove((Collection)IMP_EXT_SKIP_FIELDS);
        if (addCustomParams) {
            openxImpExt.set("customParams", impExt.get("bidder").get("customParams").deepCopy());
        }
        return openxImpExt;
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, OpenxBidResponse bidResponse) {
        return bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid()) ? Collections.emptyList() : OpenxBidder.bidsFromResponse((BidRequest)bidRequest, (OpenxBidResponse)bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, OpenxBidResponse bidResponse) {
        Map impIdToBidType = OpenxBidder.impIdToBidType((BidRequest)bidRequest);
        String bidCurrency = StringUtils.isNotBlank((CharSequence)bidResponse.getCur()) ? bidResponse.getCur() : "USD";
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)OpenxBidder.getBidType((Bid)bid, (Map)impIdToBidType), (String)bidCurrency)).toList();
    }

    private static Map<String, BidType> impIdToBidType(BidRequest bidRequest) {
        return bidRequest.getImp().stream().collect(Collectors.toMap(Imp::getId, imp -> imp.getBanner() != null ? BidType.banner : BidType.video));
    }

    private static BidType getBidType(Bid bid, Map<String, BidType> impIdToBidType) {
        return impIdToBidType.getOrDefault(bid.getImpid(), BidType.banner);
    }

    private static List<FledgeAuctionConfig> extractFledge(OpenxBidResponse bidResponse) {
        return Optional.ofNullable(bidResponse).map(OpenxBidResponse::getExt).map(OpenxBidResponseExt::getFledgeAuctionConfigs).orElse(Collections.emptyMap()).entrySet().stream().map(e -> FledgeAuctionConfig.builder().impId((String)e.getKey()).config((ObjectNode)e.getValue()).build()).toList();
    }
}

