/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.motorik;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.motoril.ExtImpMotorik;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class MotorikBidder
implements Bidder<BidRequest> {
    private static final String X_OPENRTB_VERSION = "2.5";
    private static final TypeReference<ExtPrebid<?, ExtImpMotorik>> MOTORIK_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public MotorikBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ExtImpMotorik firstImpExt;
        try {
            firstImpExt = this.parseImpExt((Imp)request.getImp().get(0));
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        return Result.withValue((Object)this.makeHttpRequest(MotorikBidder.createRequest((BidRequest)request), firstImpExt));
    }

    private ExtImpMotorik parseImpExt(Imp imp) {
        try {
            return (ExtImpMotorik)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), MOTORIK_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Error parsing motorikExt %s".formatted(e.getMessage()));
        }
    }

    private static BidRequest createRequest(BidRequest request) {
        return request.toBuilder().imp(MotorikBidder.prepareFirstImp((List)request.getImp())).build();
    }

    private static List<Imp> prepareFirstImp(List<Imp> imps) {
        Imp firstImp = imps.get(0);
        ArrayList<Imp> updatedImps = new ArrayList<Imp>(imps);
        updatedImps.set(0, firstImp.toBuilder().ext(null).build());
        return updatedImps;
    }

    private HttpRequest<BidRequest> makeHttpRequest(BidRequest bidRequest, ExtImpMotorik extImpMotorik) {
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.makeUrl(extImpMotorik)).headers(this.makeRequestHeaders(bidRequest.getDevice())).body(this.mapper.encodeToBytes((Object)bidRequest)).payload((Object)bidRequest).build();
    }

    private String makeUrl(ExtImpMotorik extImpMotorik) {
        return this.endpointUrl.replace("{{AccountID}}", extImpMotorik.getAccountId()).replace("{{SourceId}}", extImpMotorik.getPlacementId());
    }

    private MultiMap makeRequestHeaders(Device device) {
        MultiMap headers = HttpUtil.headers();
        headers.set(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)((CharSequence)ObjectUtil.getIfNotNull((Object)device, Device::getUa)));
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)((CharSequence)ObjectUtil.getIfNotNull((Object)device, Device::getIpv6)));
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)((CharSequence)ObjectUtil.getIfNotNull((Object)device, Device::getIp)));
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)MotorikBidder.extractBids((BidRequest)((BidRequest)httpCall.getRequest().getPayload()), (BidResponse)bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)MotorikBidder.getBidType((String)bid.getImpid(), (List)bidRequest.getImp()), (String)bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) break;
            return BidType.xNative;
        }
        throw new PreBidException("Failed to find impression for ID: '%s'".formatted(impId));
    }
}

