/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.mobilefuse;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.mobilefuse.ExtImpMobilefuse;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class MobilefuseBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpMobilefuse>> MOBILEFUSE_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String SKADN_PROPERTY_NAME = "skadn";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public MobilefuseBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        String endpoint = request.getImp().stream().map(arg_0 -> this.parseImpExt(arg_0)).filter(Objects::nonNull).findFirst().map(arg_0 -> this.makeUrl(arg_0)).orElse(null);
        if (endpoint == null) {
            return Result.withError((BidderError)BidderError.badInput((String)"Invalid ExtImpMobilefuse value"));
        }
        List<Imp> modifiedImps = request.getImp().stream().map(arg_0 -> this.modifyImp(arg_0)).filter(Objects::nonNull).toList();
        if (modifiedImps.isEmpty()) {
            return Result.withError((BidderError)BidderError.badInput((String)"No valid imps"));
        }
        BidRequest modifiedRequest = request.toBuilder().imp(modifiedImps).build();
        return Result.withValue((Object)BidderUtil.defaultRequest((BidRequest)modifiedRequest, (String)endpoint, (JacksonMapper)this.mapper));
    }

    private Imp modifyImp(Imp imp) {
        if (imp.getBanner() == null && imp.getVideo() == null && imp.getXNative() == null) {
            return null;
        }
        ExtImpMobilefuse impExt = this.parseImpExt(imp);
        ObjectNode skadn = this.parseSkadn(imp.getExt());
        return imp.toBuilder().tagid(Objects.toString(impExt.getPlacementId(), "0")).ext(skadn != null ? (ObjectNode)this.mapper.mapper().createObjectNode().set(SKADN_PROPERTY_NAME, (JsonNode)skadn) : null).build();
    }

    private ExtImpMobilefuse parseImpExt(Imp imp) {
        try {
            return (ExtImpMobilefuse)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), MOBILEFUSE_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private ObjectNode parseSkadn(ObjectNode impExt) {
        try {
            return (ObjectNode)this.mapper.mapper().convertValue((Object)impExt.get(SKADN_PROPERTY_NAME), ObjectNode.class);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private String makeUrl(ExtImpMobilefuse extImp) {
        String baseUrl = this.endpointUrl + Objects.toString(extImp.getPublisherId(), "0");
        return "ext".equals(extImp.getTagidSrc()) ? baseUrl + "&tagid_src=ext" : baseUrl;
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)this.extractBids(bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return this.bidsFromResponse(bidResponse);
    }

    private List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid.toBuilder().ext(null).build(), (BidType)this.getBidType(bid), (String)bidResponse.getCur())).toList();
    }

    private BidType getBidType(Bid bid) {
        if (bid.getExt() == null) {
            return BidType.banner;
        }
        return switch (this.parseBidExtMediaType(bid.getExt())) {
            case "video" -> BidType.video;
            case "native" -> BidType.xNative;
            default -> BidType.banner;
        };
    }

    private String parseBidExtMediaType(ObjectNode bidExt) {
        try {
            return (String)this.mapper.mapper().convertValue((Object)bidExt.get("mf").get("media_type"), String.class);
        }
        catch (IllegalArgumentException e) {
            return "banner";
        }
    }
}

