/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.madvertise;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.madvertise.ExtImpMadvertise;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class MadvertiseBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpMadvertise>> MADVERTISE_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final int ZONE_ID_MIN_LENGTH = 7;
    private static final String X_OPENRTB_VERSION = "2.5";
    private static final String ZONE_ID_MACRO = "{{ZoneID}}";
    private static final Set<Integer> VIDEO_BID_ATTRS = Set.of(Integer.valueOf(16), Integer.valueOf(6), Integer.valueOf(7));
    private final JacksonMapper mapper;
    private final String endpointUrl;

    public MadvertiseBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        String zoneId = null;
        for (Imp imp : request.getImp()) {
            String impZoneId;
            try {
                impZoneId = this.parseImpExt(imp).getZoneId();
            }
            catch (PreBidException e) {
                return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
            }
            if (zoneId == null) {
                zoneId = impZoneId;
                continue;
            }
            if (zoneId.equals(impZoneId)) continue;
            return Result.withError((BidderError)BidderError.badInput((String)"There must be only one zone ID"));
        }
        return Result.withValue((Object)this.createRequest(request, zoneId));
    }

    private ExtImpMadvertise parseImpExt(Imp imp) {
        ExtImpMadvertise extImpMadvertise;
        String impId = imp.getId();
        try {
            extImpMadvertise = (ExtImpMadvertise)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), MADVERTISE_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Missing bidder ext in impression with id: " + impId);
        }
        if (StringUtils.length((CharSequence)extImpMadvertise.getZoneId()) < 7) {
            throw new PreBidException("The minLength of zone ID is 7; ImpID=" + impId);
        }
        return extImpMadvertise;
    }

    private HttpRequest<BidRequest> createRequest(BidRequest request, String zoneID) {
        String url = this.endpointUrl.replace("{{ZoneID}}", HttpUtil.encodeUrl((String)zoneID));
        return HttpRequest.builder().method(HttpMethod.POST).uri(url).headers(MadvertiseBidder.resolveHeaders((Device)request.getDevice())).payload((Object)request).body(this.mapper.encodeToBytes((Object)request)).build();
    }

    private static MultiMap resolveHeaders(Device device) {
        MultiMap headers = HttpUtil.headers();
        headers.add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
        }
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)MadvertiseBidder.extractBids((BidResponse)bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)MadvertiseBidder.getBidMediaType((List)bid.getAttr()), (String)bidResponse.getCur())).toList();
    }

    private static BidType getBidMediaType(List<Integer> bidAttrs) {
        return CollectionUtils.emptyIfNull(bidAttrs).stream().anyMatch(VIDEO_BID_ATTRS::contains) ? BidType.video : BidType.banner;
    }
}

