/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.lunamedia;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.lunamedia.ExtImpLunamedia;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class LunamediaBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpLunamedia>> IMP_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public LunamediaBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList errors = new ArrayList();
        ArrayList httpRequests = new ArrayList();
        try {
            Map impToExtImp = this.impExtToImps(request.getImp(), errors);
            httpRequests.addAll(this.buildBidderRequests(request, impToExtImp));
        }
        catch (PreBidException e) {
            return Result.withErrors(errors);
        }
        return Result.of(httpRequests, errors);
    }

    private Map<ExtImpLunamedia, List<Imp>> impExtToImps(List<Imp> imps, List<BidderError> errors) {
        HashMap<ExtImpLunamedia, List<Imp>> extToListOfUpdatedImp = new HashMap<ExtImpLunamedia, List<Imp>>();
        for (Imp imp : imps) {
            try {
                ExtImpLunamedia extImpLunamedia = this.parseAndValidateImpExt(imp);
                Imp updatedImp = LunamediaBidder.updateImp((Imp)imp);
                extToListOfUpdatedImp.computeIfAbsent(extImpLunamedia, ext -> new ArrayList()).add(updatedImp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        if (extToListOfUpdatedImp.isEmpty()) {
            throw new PreBidException("No appropriate impressions");
        }
        return extToListOfUpdatedImp;
    }

    private ExtImpLunamedia parseAndValidateImpExt(Imp imp) {
        ExtImpLunamedia extImpLunamedia;
        try {
            extImpLunamedia = (ExtImpLunamedia)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), IMP_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)extImpLunamedia.getPubid())) {
            throw new PreBidException("No pubid value provided");
        }
        return extImpLunamedia;
    }

    private static Imp updateImp(Imp imp) {
        Imp.ImpBuilder impBuilder = imp.toBuilder().ext(null);
        Video video = imp.getVideo();
        if (video != null) {
            return impBuilder.banner(null).audio(null).xNative(null).build();
        }
        Banner banner = imp.getBanner();
        if (banner != null) {
            return impBuilder.banner(LunamediaBidder.modifyImpBanner((Banner)banner)).build();
        }
        throw new PreBidException("Unsupported impression has been received");
    }

    private static Banner modifyImpBanner(Banner banner) {
        if (banner.getW() == null || banner.getH() == null) {
            Banner.BannerBuilder bannerBuilder = banner.toBuilder();
            List originalFormat = banner.getFormat();
            if (CollectionUtils.isEmpty((Collection)originalFormat)) {
                throw new PreBidException("Expected at least one banner.format entry or explicit w/h");
            }
            List formatSkipFirst = originalFormat.subList(1, originalFormat.size());
            bannerBuilder.format(formatSkipFirst);
            Format firstFormat = (Format)originalFormat.get(0);
            bannerBuilder.w(firstFormat.getW());
            bannerBuilder.h(firstFormat.getH());
            return bannerBuilder.build();
        }
        return banner;
    }

    private List<HttpRequest<BidRequest>> buildBidderRequests(BidRequest bidRequest, Map<ExtImpLunamedia, List<Imp>> impExtToListOfImps) {
        ArrayList<HttpRequest<BidRequest>> httpRequests = new ArrayList<HttpRequest<BidRequest>>();
        for (Map.Entry<ExtImpLunamedia, List<Imp>> impExtAndListOfImps : impExtToListOfImps.entrySet()) {
            ExtImpLunamedia extImpLunamedia = impExtAndListOfImps.getKey();
            List<Imp> imps = impExtAndListOfImps.getValue();
            BidRequest updatedBidRequest = LunamediaBidder.makeBidRequest((BidRequest)bidRequest, (ExtImpLunamedia)extImpLunamedia, imps);
            String url = this.endpointUrl + extImpLunamedia.getPubid();
            HttpRequest createdBidRequest = HttpRequest.builder().method(HttpMethod.POST).uri(url).body(this.mapper.encodeToBytes((Object)updatedBidRequest)).headers(LunamediaBidder.headers()).payload((Object)updatedBidRequest).build();
            httpRequests.add((HttpRequest<BidRequest>)createdBidRequest);
        }
        return httpRequests;
    }

    private static BidRequest makeBidRequest(BidRequest preBidRequest, ExtImpLunamedia extImpLunamedia, List<Imp> imps) {
        App app;
        BidRequest.BidRequestBuilder bidRequestBuilder = preBidRequest.toBuilder();
        List<Imp> modifiedImps = imps.stream().map(imp -> imp.toBuilder().tagid(extImpLunamedia.getPlacement()).build()).toList();
        bidRequestBuilder.imp(modifiedImps);
        Site site = preBidRequest.getSite();
        if (site != null) {
            bidRequestBuilder.site(site.toBuilder().publisher(null).domain("").build());
        }
        if ((app = preBidRequest.getApp()) != null) {
            bidRequestBuilder.app(app.toBuilder().publisher(null).build());
        }
        return bidRequestBuilder.build();
    }

    private static MultiMap headers() {
        return HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)LunamediaBidder.extractBids((BidRequest)((BidRequest)httpCall.getRequest().getPayload()), (BidResponse)bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || bidResponse.getSeatbid() == null) {
            return Collections.emptyList();
        }
        if (bidResponse.getSeatbid().size() != 1) {
            throw new PreBidException("Invalid SeatBids count: " + bidResponse.getSeatbid().size());
        }
        return LunamediaBidder.bidsFromResponse((BidRequest)bidRequest, (BidResponse)bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)LunamediaBidder.getBidType((String)bid.getImpid(), (List)bidRequest.getImp()), (String)bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            return imp.getVideo() != null ? BidType.video : BidType.banner;
        }
        return BidType.banner;
    }
}

