/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.globalsun;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.globalsun.model.GlobalsunImpExtBidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.globalsun.ExtImpGlobalsun;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class GlobalsunBidder
implements Bidder<BidRequest> {
    private static final String TYPE_PUBLISHER = "publisher";
    private static final TypeReference<ExtPrebid<?, ExtImpGlobalsun>> GLOBALSUN_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public GlobalsunBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public final Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ArrayList<HttpRequest> outgoingRequests = new ArrayList<HttpRequest>();
        for (Imp imp : request.getImp()) {
            ExtImpGlobalsun extImpGlobalsun;
            try {
                extImpGlobalsun = this.parseImpExt(imp);
            }
            catch (PreBidException e) {
                return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
            }
            outgoingRequests.add(this.createSingleRequest(this.modifyImp(imp, extImpGlobalsun), request));
        }
        return Result.withValues(outgoingRequests);
    }

    private ExtImpGlobalsun parseImpExt(Imp imp) {
        try {
            return (ExtImpGlobalsun)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), GLOBALSUN_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private HttpRequest<BidRequest> createSingleRequest(Imp imp, BidRequest request) {
        BidRequest outgoingRequest = request.toBuilder().imp(Collections.singletonList(imp)).build();
        return BidderUtil.defaultRequest((BidRequest)outgoingRequest, (String)this.endpointUrl, (JacksonMapper)this.mapper);
    }

    private Imp modifyImp(Imp imp, ExtImpGlobalsun extImpAndGlobalsun) {
        GlobalsunImpExtBidder globalsunImpExtBidder = GlobalsunBidder.resolveOutgoingImpExt((ExtImpGlobalsun)extImpAndGlobalsun);
        ObjectNode modifiedImpExtBidder = this.mapper.mapper().createObjectNode();
        modifiedImpExtBidder.set("bidder", this.mapper.mapper().valueToTree((Object)globalsunImpExtBidder));
        return imp.toBuilder().ext(modifiedImpExtBidder).build();
    }

    private static GlobalsunImpExtBidder resolveOutgoingImpExt(ExtImpGlobalsun extImpAndGlobalsun) {
        return GlobalsunImpExtBidder.of((String)"publisher", (String)extImpAndGlobalsun.getPlacementId());
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)GlobalsunBidder.extractBids((BidRequest)((BidRequest)httpCall.getRequest().getPayload()), (BidResponse)bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)GlobalsunBidder.getBidType((String)bid.getImpid(), (List)bidRequest.getImp()), (String)bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getBanner() != null) {
                return BidType.banner;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() == null) break;
            return BidType.xNative;
        }
        throw new PreBidException("Failed to find impression for ID: '%s'".formatted(impId));
    }
}

