/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.evolution;

import com.fasterxml.jackson.databind.JsonNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class EvolutionBidder
implements Bidder<BidRequest> {
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public EvolutionBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        HttpRequest internalRequest = BidderUtil.defaultRequest((BidRequest)request, (String)this.endpointUrl, (JacksonMapper)this.mapper);
        return Result.withValue((Object)internalRequest);
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)this.extractBids(bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            throw new PreBidException("Empty seatbid");
        }
        return this.bidsFromResponse(bidResponse);
    }

    private List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        SeatBid firstSeatBid = (SeatBid)bidResponse.getSeatbid().get(0);
        return CollectionUtils.emptyIfNull((Collection)firstSeatBid.getBid()).stream().filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)this.getBidMediaType((JsonNode)bid.getExt()), (String)bidResponse.getCur())).toList();
    }

    private BidType getBidMediaType(JsonNode bidExt) {
        JsonNode mediaTypeNode = bidExt != null ? bidExt.get("mediaType") : null;
        try {
            return (BidType)ObjectUtils.defaultIfNull((Object)((BidType)this.mapper.mapper().convertValue((Object)mediaTypeNode, BidType.class)), (Object)BidType.banner);
        }
        catch (IllegalArgumentException e) {
            return BidType.banner;
        }
    }
}

