/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.datablocks;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.datablocks.ExtImpDatablocks;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class DatablocksBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpDatablocks>> DATABLOCKS_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointTemplate;
    private final JacksonMapper mapper;

    public DatablocksBidder(String endpointTemplate, JacksonMapper mapper) {
        this.endpointTemplate = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointTemplate));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        HashMap<ExtImpDatablocks, List> extToImps = new HashMap<ExtImpDatablocks, List>();
        for (Imp imp : bidRequest.getImp()) {
            try {
                ExtImpDatablocks extImpDatablocks = this.parseAndValidateImpExt(imp.getExt());
                extToImps.computeIfAbsent(extImpDatablocks, ext -> new ArrayList()).add(imp);
            }
            catch (PreBidException e) {
                return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
            }
        }
        List<HttpRequest> httpRequests = extToImps.entrySet().stream().map(entry -> this.makeHttpRequest(entry, bidRequest)).toList();
        return Result.withValues(httpRequests);
    }

    private ExtImpDatablocks parseAndValidateImpExt(ObjectNode extNode) {
        ExtImpDatablocks extImpDatablocks;
        try {
            extImpDatablocks = (ExtImpDatablocks)((ExtPrebid)this.mapper.mapper().convertValue((Object)extNode, DATABLOCKS_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage());
        }
        Integer sourceId = extImpDatablocks.getSourceId();
        if (sourceId == null || sourceId < 1) {
            throw new PreBidException("Invalid/Missing SourceId");
        }
        return extImpDatablocks;
    }

    private HttpRequest<BidRequest> makeHttpRequest(Map.Entry<ExtImpDatablocks, List<Imp>> extToImps, BidRequest bidRequest) {
        ExtImpDatablocks extImpDatablocks = extToImps.getKey();
        String uri = this.endpointTemplate.replace("{{SourceId}}", extImpDatablocks.getSourceId().toString());
        BidRequest outgoingRequest = bidRequest.toBuilder().imp(extToImps.getValue()).build();
        return BidderUtil.defaultRequest((BidRequest)outgoingRequest, (String)uri, (JacksonMapper)this.mapper);
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)DatablocksBidder.extractBids((BidResponse)bidResponse, (BidRequest)((BidRequest)httpCall.getRequest().getPayload())));
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse, BidRequest bidRequest) {
        return bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid()) ? Collections.emptyList() : DatablocksBidder.bidsFromResponse((BidResponse)bidResponse, (List)bidRequest.getImp());
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse, List<Imp> imps) {
        return bidResponse.getSeatbid().stream().map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)DatablocksBidder.getBidType((String)bid.getImpid(), (List)imps), (String)bidResponse.getCur())).toList();
    }

    private static BidType getBidType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId)) continue;
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            if (imp.getXNative() != null) {
                return BidType.xNative;
            }
            return BidType.banner;
        }
        return BidType.banner;
    }
}

