/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.consumable;

import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Regs;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import com.iab.openrtb.response.Bid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.consumable.model.ConsumableAdType;
import org.prebid.server.bidder.consumable.model.ConsumableBidGdpr;
import org.prebid.server.bidder.consumable.model.ConsumableBidRequest;
import org.prebid.server.bidder.consumable.model.ConsumableBidResponse;
import org.prebid.server.bidder.consumable.model.ConsumableContents;
import org.prebid.server.bidder.consumable.model.ConsumableDecision;
import org.prebid.server.bidder.consumable.model.ConsumablePlacement;
import org.prebid.server.bidder.consumable.model.ConsumablePricing;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.request.ExtRegs;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.consumable.ExtImpConsumable;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConsumableBidder
implements Bidder<ConsumableBidRequest> {
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public ConsumableBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<ConsumableBidRequest>>> makeHttpRequests(BidRequest request) {
        String gdprConsent;
        String usPrivacy;
        List gppSid;
        Regs regs;
        String gpp;
        ConsumableBidRequest.ConsumableBidRequestBuilder requestBuilder = ConsumableBidRequest.builder().time(Long.valueOf(Instant.now().getEpochSecond())).includePricingData(Boolean.valueOf(true)).enableBotFiltering(Boolean.valueOf(true)).parallel(Boolean.valueOf(true));
        Site site = request.getSite();
        if (site != null) {
            requestBuilder.referrer(site.getRef()).url(site.getPage());
        }
        String string = gpp = (regs = request.getRegs()) != null ? regs.getGpp() : null;
        if (gpp != null) {
            requestBuilder.gpp(gpp);
        }
        List list = gppSid = regs != null ? regs.getGppSid() : null;
        if (CollectionUtils.isNotEmpty((Collection)gppSid)) {
            requestBuilder.gppSid(gppSid);
        }
        ExtRegs extRegs = regs != null ? regs.getExt() : null;
        String string2 = usPrivacy = extRegs != null ? extRegs.getUsPrivacy() : null;
        if (usPrivacy != null) {
            requestBuilder.usPrivacy(usPrivacy);
        }
        Integer gdpr = extRegs != null ? extRegs.getGdpr() : null;
        User user = request.getUser();
        ExtUser extUser = user != null ? user.getExt() : null;
        String string3 = gdprConsent = extUser != null ? extUser.getConsent() : null;
        if (gdpr != null || gdprConsent != null) {
            ConsumableBidGdpr.ConsumableBidGdprBuilder bidGdprBuilder = ConsumableBidGdpr.builder();
            if (gdpr != null) {
                bidGdprBuilder.applies(Boolean.valueOf(gdpr != 0));
            }
            if (gdprConsent != null) {
                bidGdprBuilder.consent(gdprConsent).build();
            }
            requestBuilder.gdpr(bidGdprBuilder.build());
        }
        try {
            this.resolveRequestFields(requestBuilder, request.getImp());
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        ConsumableBidRequest outgoingRequest = requestBuilder.build();
        return Result.withValue((Object)HttpRequest.builder().method(HttpMethod.POST).uri(this.endpointUrl).body(this.mapper.encodeToBytes((Object)outgoingRequest)).headers(ConsumableBidder.resolveHeaders((BidRequest)request)).payload((Object)outgoingRequest).build());
    }

    private void resolveRequestFields(ConsumableBidRequest.ConsumableBidRequestBuilder requestBuilder, List<Imp> imps) {
        ArrayList<ConsumablePlacement> placements = new ArrayList<ConsumablePlacement>();
        for (int i = 0; i < imps.size(); ++i) {
            Imp currentImp = imps.get(i);
            ExtImpConsumable extImpConsumable = this.parseImpExt(currentImp);
            if (i == 0) {
                requestBuilder.networkId(extImpConsumable.getNetworkId()).siteId(extImpConsumable.getSiteId()).unitId(extImpConsumable.getUnitId()).unitName(extImpConsumable.getUnitName());
            }
            placements.add(ConsumablePlacement.builder().divName(currentImp.getId()).networkId(extImpConsumable.getNetworkId()).siteId(extImpConsumable.getSiteId()).unitId(extImpConsumable.getUnitId()).unitName(extImpConsumable.getUnitName()).adTypes(ConsumableAdType.getSizeCodes((List)currentImp.getBanner().getFormat())).build());
        }
        requestBuilder.placements(placements);
    }

    private ExtImpConsumable parseImpExt(Imp imp) {
        try {
            return (ExtImpConsumable)this.mapper.mapper().convertValue((Object)imp.getExt().get("bidder"), ExtImpConsumable.class);
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), (Throwable)e);
        }
    }

    private static MultiMap resolveHeaders(BidRequest request) {
        Site site;
        String page;
        User user;
        MultiMap headers = HttpUtil.headers();
        Device device = request.getDevice();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
            String ip = device.getIp();
            if (StringUtils.isNotBlank((CharSequence)ip)) {
                headers.add(HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)ip);
                headers.add("Forwarded", "for=" + ip);
            }
        }
        if ((user = request.getUser()) != null && StringUtils.isNotBlank((CharSequence)user.getBuyeruid())) {
            headers.add(HttpUtil.COOKIE_HEADER, (CharSequence)("azk=" + user.getBuyeruid().trim()));
        }
        String string = page = (site = request.getSite()) != null ? site.getPage() : null;
        if (StringUtils.isNotBlank((CharSequence)page)) {
            headers.set(HttpUtil.REFERER_HEADER, (CharSequence)page);
            try {
                headers.set(HttpUtil.ORIGIN_HEADER, (CharSequence)HttpUtil.validateUrl((String)page));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<ConsumableBidRequest> httpCall, BidRequest bidRequest) {
        ConsumableBidResponse consumableResponse;
        try {
            consumableResponse = (ConsumableBidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), ConsumableBidResponse.class);
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
        ArrayList errors = new ArrayList();
        List bidderBids = ConsumableBidder.extractBids((BidRequest)bidRequest, (Map)consumableResponse.getDecisions());
        return Result.of((Object)bidderBids, errors);
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, Map<String, ConsumableDecision> impIdToDecisions) {
        ArrayList<BidderBid> bidderBids = new ArrayList<BidderBid>();
        for (Map.Entry<String, ConsumableDecision> entry : impIdToDecisions.entrySet()) {
            ConsumablePricing pricing;
            ConsumableDecision decision = entry.getValue();
            if (decision == null || (pricing = decision.getPricing()) == null || pricing.getClearPrice() == null) continue;
            String impId = entry.getKey();
            Bid bid = Bid.builder().id(bidRequest.getId()).impid(impId).price(BigDecimal.valueOf(pricing.getClearPrice())).adm(CollectionUtils.isNotEmpty((Collection)decision.getContents()) ? ((ConsumableContents)decision.getContents().get(0)).getBody() : "").w(decision.getWidth()).h(decision.getHeight()).crid(String.valueOf(decision.getAdId())).exp(Integer.valueOf(30)).build();
            bidderBids.add(BidderBid.of((Bid)bid, (BidType)BidType.banner, null));
        }
        return bidderBids;
    }
}

