/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.between;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.between.ExtImpBetween;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class BetweenBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpBetween>> BETWEEN_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String URL_HOST_MACRO = "{{Host}}";
    private static final String PUBLISHER_ID_MACRO = "{{PublisherId}}";
    private final String endpointUrl;
    private final JacksonMapper mapper;
    private final boolean endpointContainsHostMacro;

    public BetweenBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.endpointContainsHostMacro = endpointUrl.contains("{{Host}}");
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        Integer secure = BetweenBidder.resolveSecure((Site)request.getSite());
        ArrayList<Imp> modifiedImps = new ArrayList<Imp>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        ExtImpBetween extImpBetween = null;
        for (Imp imp : request.getImp()) {
            try {
                extImpBetween = this.parseImpExt(imp);
                this.validateImp(imp, extImpBetween);
                modifiedImps.add(BetweenBidder.modifyImp((Imp)imp, (Integer)secure));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        if (!errors.isEmpty()) {
            return Result.withErrors(errors);
        }
        return Result.withValue((Object)this.createRequest(extImpBetween, request, modifiedImps));
    }

    private static Integer resolveSecure(Site site) {
        return site != null && StringUtils.isNotBlank((CharSequence)site.getPage()) && site.getPage().startsWith("https") ? 1 : 0;
    }

    private void validateImp(Imp imp, ExtImpBetween extImp) {
        Banner banner = imp.getBanner();
        if (imp.getBanner() == null) {
            throw new PreBidException("Request needs to include a Banner object");
        }
        if (banner.getW() == null && banner.getH() == null && CollectionUtils.isEmpty((Collection)banner.getFormat())) {
            throw new PreBidException("Need at least one size to build request");
        }
        String missingParamErrorMessage = "required BetweenSSP parameter %s is missing in impression with id: %s";
        if (StringUtils.isBlank((CharSequence)extImp.getPublisherId())) {
            throw new PreBidException("required BetweenSSP parameter %s is missing in impression with id: %s".formatted("publisher_id", imp.getId()));
        }
        if (this.endpointContainsHostMacro && StringUtils.isBlank((CharSequence)extImp.getHost())) {
            throw new PreBidException("required BetweenSSP parameter %s is missing in impression with id: %s".formatted("host", imp.getId()));
        }
    }

    private ExtImpBetween parseImpExt(Imp imp) {
        ExtImpBetween extImpBetween;
        try {
            extImpBetween = (ExtImpBetween)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), BETWEEN_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Missing bidder ext in impression with id: " + imp.getId());
        }
        return extImpBetween;
    }

    private static Imp modifyImp(Imp imp, Integer secure) {
        Banner resolvedBanner = BetweenBidder.resolveBanner((Banner)imp.getBanner());
        return imp.toBuilder().banner(resolvedBanner).secure(secure).build();
    }

    private static Banner resolveBanner(Banner banner) {
        if (banner.getW() == null && banner.getH() == null) {
            List bannerFormat = banner.getFormat();
            Format firstFormat = (Format)bannerFormat.get(0);
            List formatSkipFirst = bannerFormat.subList(1, bannerFormat.size());
            return banner.toBuilder().format(formatSkipFirst).w(firstFormat.getW()).h(firstFormat.getH()).build();
        }
        return banner;
    }

    private HttpRequest<BidRequest> createRequest(ExtImpBetween extImpBetween, BidRequest request, List<Imp> imps) {
        String url = this.endpointUrl.replace("{{Host}}", StringUtils.defaultString((String)extImpBetween.getHost())).replace("{{PublisherId}}", HttpUtil.encodeUrl((String)extImpBetween.getPublisherId()));
        BidRequest outgoingRequest = request.toBuilder().imp(imps).build();
        return HttpRequest.builder().method(HttpMethod.POST).uri(url).headers(BetweenBidder.resolveHeaders((Device)request.getDevice(), (Site)request.getSite())).impIds(BidderUtil.impIds((BidRequest)outgoingRequest)).payload((Object)outgoingRequest).body(this.mapper.encodeToBytes((Object)outgoingRequest)).build();
    }

    private static MultiMap resolveHeaders(Device device, Site site) {
        MultiMap headers = HttpUtil.headers();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.ACCEPT_LANGUAGE_HEADER, (CharSequence)device.getLanguage());
            Integer dnt = device.getDnt();
            if (dnt != null) {
                headers.add(HttpUtil.DNT_HEADER, (CharSequence)dnt.toString());
            }
        }
        if (site != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.REFERER_HEADER, (CharSequence)site.getPage());
        }
        return headers;
    }

    public final Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)BetweenBidder.extractBids((BidResponse)bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return BetweenBidder.bidsFromResponse((BidResponse)bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).map(bid -> BidderBid.of((Bid)bid, (BidType)BidType.banner, (String)bidResponse.getCur())).toList();
    }
}

