/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.beachfront;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Source;
import com.iab.openrtb.request.SupplyChain;
import com.iab.openrtb.request.User;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.beachfront.BeachfrontFloorResolver;
import org.prebid.server.bidder.beachfront.model.BeachfrontBannerRequest;
import org.prebid.server.bidder.beachfront.model.BeachfrontResponseSlot;
import org.prebid.server.bidder.beachfront.model.BeachfrontSize;
import org.prebid.server.bidder.beachfront.model.BeachfrontSlot;
import org.prebid.server.bidder.beachfront.model.BeachfrontVideoRequest;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Price;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.currency.CurrencyConversionService;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtSource;
import org.prebid.server.proto.openrtb.ext.request.beachfront.ExtImpBeachfront;
import org.prebid.server.proto.openrtb.ext.request.beachfront.ExtImpBeachfrontAppIds;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebid;
import org.prebid.server.proto.openrtb.ext.response.ExtBidPrebidVideo;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class BeachfrontBidder
implements Bidder<Void> {
    private static final String NURL_VIDEO_TYPE = "nurl";
    private static final String ADM_VIDEO_TYPE = "adm";
    private static final String BEACHFRONT_NAME = "BF_PREBID_S2S";
    private static final String BEACHFRONT_VERSION = "1.0.0";
    private static final String NURL_VIDEO_ENDPOINT_SUFFIX = "&prebidserver";
    private static final String FAKE_IP = "255.255.255.255";
    private static final int DEFAULT_VIDEO_WIDTH = 300;
    private static final int DEFAULT_VIDEO_HEIGHT = 250;
    private static final TypeReference<ExtPrebid<?, ExtImpBeachfront>> BEACHFRONT_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String bannerEndpointUrl;
    private final String videoEndpointUrl;
    private final BeachfrontFloorResolver beachfrontFloorResolver;
    private final JacksonMapper mapper;

    public BeachfrontBidder(String bannerEndpointUrl, String videoEndpointUrl, CurrencyConversionService currencyConversionService, JacksonMapper mapper) {
        this.bannerEndpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(bannerEndpointUrl));
        this.videoEndpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(videoEndpointUrl));
        this.beachfrontFloorResolver = new BeachfrontFloorResolver(currencyConversionService);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<Void>>> makeHttpRequests(BidRequest bidRequest) {
        String buyerUid;
        ArrayList<Imp> bannerImps = new ArrayList<Imp>();
        ArrayList<Imp> videoImps = new ArrayList<Imp>();
        for (Imp imp : bidRequest.getImp()) {
            Banner banner = imp.getBanner();
            if (BeachfrontBidder.checkFormats((Banner)banner)) {
                bannerImps.add(imp);
            }
            if (imp.getVideo() == null) continue;
            videoImps.add(imp);
        }
        if (bannerImps.isEmpty() && videoImps.isEmpty()) {
            return Result.withError((BidderError)BidderError.badInput((String)"no valid impressions were found in the request"));
        }
        ArrayList errors = new ArrayList();
        BeachfrontBannerRequest bannerRequest = this.getBannerRequest(bidRequest, bannerImps, errors);
        List videoRequests = this.getVideoRequests(bidRequest, videoImps, errors);
        MultiMap headers = HttpUtil.headers();
        Device device = bidRequest.getDevice();
        if (device != null) {
            BeachfrontBidder.addDeviceHeaders((MultiMap)headers, (Device)device);
        }
        ArrayList<HttpRequest> requests = new ArrayList<HttpRequest>();
        if (bannerRequest != null) {
            requests.add(HttpRequest.builder().method(HttpMethod.POST).uri(this.bannerEndpointUrl).body(this.mapper.encodeToBytes((Object)bannerRequest)).headers(headers).build());
        }
        MultiMap videoHeaders = MultiMap.caseInsensitiveMultiMap().addAll(headers);
        User user = bidRequest.getUser();
        String string = buyerUid = user != null ? user.getBuyeruid() : null;
        if (!videoRequests.isEmpty() && StringUtils.isNotBlank((CharSequence)buyerUid)) {
            videoHeaders.add("Cookie", "__io_cid=" + buyerUid);
        }
        videoRequests.stream().map(videoRequest -> HttpRequest.builder().method(HttpMethod.POST).uri(this.resolveVideoUri(videoRequest.getAppId(), videoRequest.getIsPrebid())).body(this.mapper.encodeToBytes(videoRequest)).headers(videoHeaders).build()).forEach(requests::add);
        return Result.of(requests, errors);
    }

    private String resolveVideoUri(String appId, Boolean isPrebid) {
        String videoWithId = this.videoEndpointUrl + appId;
        return BooleanUtils.toBoolean((Boolean)isPrebid) ? videoWithId + "&prebidserver" : videoWithId;
    }

    private static boolean checkFormats(Banner banner) {
        List formats = banner != null ? banner.getFormat() : null;
        Format firstFormat = CollectionUtils.isNotEmpty((Collection)formats) ? (Format)formats.get(0) : null;
        boolean isHeightNonZero = firstFormat != null && !Objects.equals(firstFormat.getH(), 0);
        boolean isWidthNonZero = firstFormat != null && !Objects.equals(firstFormat.getW(), 0);
        return isHeightNonZero && isWidthNonZero;
    }

    private BeachfrontBannerRequest getBannerRequest(BidRequest bidRequest, List<Imp> bannerImps, List<BidderError> errors) {
        Device device;
        ArrayList<BeachfrontSlot> slots = new ArrayList<BeachfrontSlot>();
        for (Imp imp : bannerImps) {
            String appId;
            ExtImpBeachfront extImpBeachfront;
            try {
                extImpBeachfront = this.parseImpExt(imp);
                appId = BeachfrontBidder.getAppId((ExtImpBeachfront)extImpBeachfront, (boolean)true);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
                continue;
            }
            BeachfrontFloorResolver.BidFloorResult bidFloorResult = this.beachfrontFloorResolver.resolveBidFloor(extImpBeachfront.getBidfloor(), imp, bidRequest);
            BeachfrontBidder.storeBidFloorConversionResultLog((BeachfrontFloorResolver.BidFloorResult)bidFloorResult, errors);
            if (bidFloorResult.isError()) continue;
            BeachfrontSlot beachfrontSlot = BeachfrontSlot.of((String)imp.getId(), (String)appId, (BigDecimal)bidFloorResult.getPrice().getValue(), (List)BeachfrontBidder.makeBeachfrontSizes((Banner)imp.getBanner()));
            slots.add(beachfrontSlot);
        }
        if (slots.isEmpty()) {
            return null;
        }
        BeachfrontBannerRequest.BeachfrontBannerRequestBuilder requestBuilder = BeachfrontBannerRequest.builder().adapterName("BF_PREBID_S2S").adapterVersion("1.0.0").requestId(bidRequest.getId()).real204(Boolean.valueOf(true)).slots(slots);
        User user = bidRequest.getUser();
        if (user != null) {
            requestBuilder.user(BeachfrontBidder.makeUser((User)user));
        }
        if ((device = bidRequest.getDevice()) != null) {
            BeachfrontBidder.populateDeviceFields((BeachfrontBannerRequest.BeachfrontBannerRequestBuilder)requestBuilder, (Device)device);
        }
        Site site = bidRequest.getSite();
        Integer firstImpSecure = bannerImps.get(0).getSecure();
        if (site != null) {
            String page = site.getPage();
            requestBuilder.page(page);
            requestBuilder.domain(StringUtils.isBlank((CharSequence)site.getDomain()) ? HttpUtil.getHostFromUrl((String)page) : site.getDomain());
            requestBuilder.isMobile(Integer.valueOf(0));
            requestBuilder.secure(Integer.valueOf(firstImpSecure != null ? firstImpSecure : BeachfrontBidder.getSecure((String)page)));
        } else {
            App app = bidRequest.getApp();
            String bundle = app.getBundle();
            requestBuilder.page(bundle);
            requestBuilder.domain(app.getDomain());
            requestBuilder.isMobile(Integer.valueOf(1));
            requestBuilder.secure(Integer.valueOf(firstImpSecure != null ? firstImpSecure : BeachfrontBidder.getSecure((String)bundle)));
        }
        SupplyChain schain = BeachfrontBidder.getSchain((BidRequest)bidRequest);
        if (schain != null) {
            requestBuilder.schain(schain);
        }
        return requestBuilder.build();
    }

    private ExtImpBeachfront parseImpExt(Imp imp) {
        try {
            return (ExtImpBeachfront)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), BEACHFRONT_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("ignoring imp id=%s, error while decoding extImpBeachfront, err: %s".formatted(imp.getId(), e.getMessage()));
        }
    }

    private static String getAppId(ExtImpBeachfront extImpBeachfront, boolean isBanner) {
        String videoAppId;
        String bannerAppId;
        String appId = extImpBeachfront.getAppId();
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            return appId;
        }
        ExtImpBeachfrontAppIds appIds = extImpBeachfront.getAppIds();
        String string = bannerAppId = appIds != null ? appIds.getBanner() : null;
        if (isBanner && StringUtils.isNotBlank((CharSequence)bannerAppId)) {
            return bannerAppId;
        }
        String string2 = videoAppId = appIds != null ? appIds.getVideo() : null;
        if (StringUtils.isNotBlank((CharSequence)videoAppId)) {
            return videoAppId;
        }
        throw new PreBidException("unable to determine the appId(s) from the supplied extension");
    }

    private static List<BeachfrontSize> makeBeachfrontSizes(Banner banner) {
        ArrayList<BeachfrontSize> beachfrontSizes = new ArrayList<BeachfrontSize>();
        if (banner.getFormat() != null) {
            for (Format format : banner.getFormat()) {
                beachfrontSizes.add(BeachfrontSize.of((Integer)format.getW(), (Integer)format.getH()));
            }
        }
        return beachfrontSizes;
    }

    private static User makeUser(User user) {
        String userId = user.getId();
        String buyerId = user.getBuyeruid();
        return User.builder().id(StringUtils.isNotEmpty((CharSequence)userId) ? userId : null).buyeruid(StringUtils.isNotEmpty((CharSequence)buyerId) ? buyerId : null).build();
    }

    private static void populateDeviceFields(BeachfrontBannerRequest.BeachfrontBannerRequestBuilder builder, Device device) {
        builder.ip(device.getIp());
        builder.deviceModel(device.getModel());
        builder.deviceOs(device.getOs());
        if (device.getDnt() != null) {
            builder.dnt(device.getDnt());
        }
        if (StringUtils.isNotEmpty((CharSequence)device.getUa())) {
            builder.ua(device.getUa());
        }
    }

    private static int getSecure(String page) {
        return StringUtils.contains((CharSequence)page, (CharSequence)"https") ? 1 : 0;
    }

    private static SupplyChain getSchain(BidRequest bidRequest) {
        Source source = bidRequest.getSource();
        ExtSource extSource = source != null ? source.getExt() : null;
        return extSource != null ? extSource.getSchain() : null;
    }

    private List<BeachfrontVideoRequest> getVideoRequests(BidRequest bidRequest, List<Imp> videoImps, List<BidderError> errors) {
        ArrayList<BeachfrontVideoRequest> videoRequests = new ArrayList<BeachfrontVideoRequest>();
        for (Imp imp : videoImps) {
            String trimmedBundle;
            String[] split;
            App app;
            Device device;
            String responseType;
            String appId;
            ExtImpBeachfront extImpBeachfront;
            try {
                extImpBeachfront = this.parseImpExt(imp);
                appId = BeachfrontBidder.getAppId((ExtImpBeachfront)extImpBeachfront, (boolean)false);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
                continue;
            }
            String videoResponseType = extImpBeachfront.getVideoResponseType();
            BeachfrontVideoRequest.BeachfrontVideoRequestBuilder requestBuilder = BeachfrontVideoRequest.builder().appId(appId);
            if (videoResponseType != null && videoResponseType.equals("nurl")) {
                requestBuilder.isPrebid(Boolean.valueOf(true));
                responseType = "nurl";
            } else {
                responseType = "adm";
            }
            requestBuilder.videoResponseType(responseType);
            BidRequest.BidRequestBuilder bidRequestBuilder = bidRequest.toBuilder();
            int secure = 0;
            Site site = bidRequest.getSite();
            if (site != null && StringUtils.isBlank((CharSequence)site.getDomain()) && StringUtils.isNotBlank((CharSequence)site.getPage())) {
                bidRequestBuilder.site(site.toBuilder().domain(HttpUtil.getHostFromUrl((String)site.getPage())).build());
                secure = BeachfrontBidder.getSecure((String)site.getPage());
            }
            if ((device = bidRequest.getDevice()) != null) {
                Device.DeviceBuilder deviceBuilder = device.toBuilder();
                Integer devicetype = device.getDevicetype();
                if (devicetype == null || devicetype == 0) {
                    deviceBuilder.devicetype(Integer.valueOf(bidRequest.getSite() != null ? 2 : 1));
                }
                if (StringUtils.isBlank((CharSequence)device.getIp()) && responseType.equals("adm")) {
                    deviceBuilder.ip("255.255.255.255");
                }
                bidRequestBuilder.device(deviceBuilder.build());
            }
            if ((app = bidRequest.getApp()) != null && StringUtils.isBlank((CharSequence)app.getDomain()) && StringUtils.isNotBlank((CharSequence)app.getBundle()) && (split = StringUtils.removeEnd((String)(trimmedBundle = StringUtils.removeStart((String)app.getBundle(), (String)"_")), (String)"_").split("\\.")).length > 1) {
                bidRequestBuilder.app(app.toBuilder().domain("%s.%s".formatted(split[1], split[0])).build());
            }
            BeachfrontFloorResolver.BidFloorResult bidFloorResult = this.beachfrontFloorResolver.resolveBidFloor(extImpBeachfront.getBidfloor(), imp, bidRequest);
            BeachfrontBidder.storeBidFloorConversionResultLog((BeachfrontFloorResolver.BidFloorResult)bidFloorResult, errors);
            if (bidFloorResult.isError()) continue;
            Price result = bidFloorResult.getPrice();
            Imp.ImpBuilder impBuilder = imp.toBuilder().banner(null).ext(null).secure(Integer.valueOf(secure)).bidfloor(result.getValue()).bidfloorcur(result.getCurrency());
            Video video = imp.getVideo();
            Integer videoHeight = video.getH();
            Integer videoWidth = video.getW();
            if (!(videoHeight != null && videoHeight != 0 || videoWidth != null && videoWidth != 0)) {
                impBuilder.video(video.toBuilder().h(Integer.valueOf(250)).w(Integer.valueOf(300)).build());
            }
            bidRequestBuilder.imp(Collections.singletonList(impBuilder.build()));
            if (CollectionUtils.isEmpty((Collection)bidRequest.getCur())) {
                bidRequestBuilder.cur(Collections.singletonList("USD"));
            }
            videoRequests.add(requestBuilder.request(bidRequestBuilder.build()).build());
        }
        return videoRequests;
    }

    private static void addDeviceHeaders(MultiMap headers, Device device) {
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.ACCEPT_LANGUAGE_HEADER, (CharSequence)device.getLanguage());
        HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.DNT_HEADER, (CharSequence)Objects.toString(device.getDnt(), null));
    }

    private static void storeBidFloorConversionResultLog(BeachfrontFloorResolver.BidFloorResult result, List<BidderError> log) {
        Stream.of(result.getError(), result.getWarning()).filter(Objects::nonNull).forEach(log::add);
    }

    public Result<List<BidderBid>> makeBids(BidderCall<Void> httpCall, BidRequest bidRequest) {
        String bodyString = httpCall.getResponse().getBody();
        ArrayList processedBidderBids = new ArrayList();
        try {
            processedBidderBids.addAll(this.processVideoResponse(bodyString, httpCall.getRequest()));
        }
        catch (DecodeException ignored) {
            try {
                processedBidderBids.addAll(this.processBannerResponse(bodyString));
            }
            catch (PreBidException e) {
                return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
            }
        }
        return Result.withValues((List)this.postProcessBidderBids(processedBidderBids));
    }

    private List<BidderBid> processBannerResponse(String responseBody) {
        return this.makeBeachfrontResponseSlots(responseBody).stream().filter(Objects::nonNull).map(BeachfrontBidder::makeBidFromBeachfrontSlot).map(bid -> BidderBid.of((Bid)bid, (BidType)BidType.banner, (String)"USD")).toList();
    }

    private List<BeachfrontResponseSlot> makeBeachfrontResponseSlots(String responseBody) {
        try {
            return (List)this.mapper.mapper().readValue(responseBody, (JavaType)this.mapper.mapper().getTypeFactory().constructCollectionType(List.class, BeachfrontResponseSlot.class));
        }
        catch (IOException e) {
            throw new PreBidException("server response failed to unmarshal as valid rtb. Run with request.debug = 1 for more info");
        }
    }

    private static Bid makeBidFromBeachfrontSlot(BeachfrontResponseSlot beachfrontResponseSlot) {
        String slot = beachfrontResponseSlot.getSlot();
        return Bid.builder().crid(beachfrontResponseSlot.getCrid()).impid(slot).price(BigDecimal.valueOf(beachfrontResponseSlot.getPrice().floatValue())).id(slot + "Banner").adm(beachfrontResponseSlot.getAdm()).h(beachfrontResponseSlot.getH()).w(beachfrontResponseSlot.getW()).build();
    }

    private List<BidderBid> processVideoResponse(String responseBody, HttpRequest<Void> httpRequest) {
        BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(responseBody, BidResponse.class);
        BeachfrontVideoRequest videoRequest = (BeachfrontVideoRequest)this.mapper.decodeValue(httpRequest.getBody(), BeachfrontVideoRequest.class);
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        List bids = ((SeatBid)bidResponse.getSeatbid().get(0)).getBid();
        List updatedBids = httpRequest.getUri().contains("&prebidserver") ? BeachfrontBidder.updateNurlVideoBids((List)bids, (List)videoRequest.getRequest().getImp()) : BeachfrontBidder.updateVideoBids((List)bids);
        return updatedBids.stream().map(bid -> BidderBid.of((Bid)bid, (BidType)BidType.video, (String)bidResponse.getCur())).toList();
    }

    private static List<Bid> updateNurlVideoBids(List<Bid> bids, List<Imp> imps) {
        ArrayList<Bid> result = new ArrayList<Bid>();
        for (int i = 0; i < bids.size(); ++i) {
            Bid bid = bids.get(i);
            Imp imp = imps.get(i);
            String impId = imp.getId();
            result.add(bid.toBuilder().crid(BeachfrontBidder.getCrId((String)bid.getNurl())).impid(impId).h(imp.getVideo().getH()).w(imp.getVideo().getW()).id(impId + "NurlVideo").build());
        }
        return result;
    }

    private static List<Bid> updateVideoBids(List<Bid> bids) {
        return bids.stream().map(bid -> bid.toBuilder().id(bid.getImpid() + "AdmVideo").build()).toList();
    }

    private static String getCrId(String nurl) {
        String[] split = nurl.split(":");
        return split.length > 2 ? split[2] : null;
    }

    private List<BidderBid> postProcessBidderBids(List<BidderBid> bidderBids) {
        return bidderBids.stream().map(arg_0 -> this.updateBidderBid(arg_0)).toList();
    }

    private BidderBid updateBidderBid(BidderBid bidderBid) {
        Bid bid = bidderBid.getBid();
        Integer duration = BeachfrontBidder.resolveDuration((ObjectNode)bid.getExt());
        if (duration == null || duration <= 0) {
            return bidderBid;
        }
        List cat = bid.getCat();
        String primaryCategory = CollectionUtils.isNotEmpty((Collection)cat) ? (String)cat.get(0) : null;
        Bid resolvedBid = bid.toBuilder().ext(this.resolveBidExt(duration, primaryCategory)).build();
        return BidderBid.of((Bid)resolvedBid, (BidType)bidderBid.getType(), (String)bidderBid.getBidCurrency());
    }

    private static Integer resolveDuration(ObjectNode bidExt) {
        JsonNode durationNode = bidExt != null ? bidExt.get("duration") : null;
        return durationNode != null && durationNode.isInt() ? Integer.valueOf(durationNode.asInt()) : null;
    }

    private ObjectNode resolveBidExt(Integer duration, String primaryCategory) {
        ExtBidPrebidVideo extBidPrebidVideo = ExtBidPrebidVideo.of((Integer)duration, (String)primaryCategory);
        ExtBidPrebid extBidPrebid = ExtBidPrebid.builder().video(extBidPrebidVideo).build();
        return (ObjectNode)this.mapper.mapper().valueToTree((Object)ExtPrebid.of((Object)extBidPrebid, null));
    }
}

