/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.axonix;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.axonix.ExtImpAxonix;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AxonixBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAxonix>> AXONIX_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    public static final String URL_SUPPLY_ID_MACRO = "{{SupplyId}}";
    private static final String PRICE_MACRO = "${AUCTION_PRICE}";
    private final JacksonMapper mapper;
    private final String endpointUrl;

    public AxonixBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        ExtImpAxonix extImpAxonix;
        try {
            extImpAxonix = this.parseImpExt((Imp)request.getImp().get(0));
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        return Result.withValue((Object)BidderUtil.defaultRequest((BidRequest)request, (String)this.resolveEndpoint(extImpAxonix.getSupplyId()), (JacksonMapper)this.mapper));
    }

    private ExtImpAxonix parseImpExt(Imp imp) {
        try {
            return (ExtImpAxonix)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), AXONIX_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Imp.ext could not be parsed");
        }
    }

    private String resolveEndpoint(String supplyId) {
        return this.endpointUrl.replace("{{SupplyId}}", HttpUtil.encodeUrl((String)supplyId));
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.of((Object)AxonixBidder.extractBids((BidRequest)bidRequest, (BidResponse)bidResponse), Collections.emptyList());
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid())) {
            return Collections.emptyList();
        }
        return bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)AxonixBidder.resolveMacros((Bid)bid), (BidType)AxonixBidder.getMediaType((String)bid.getImpid(), (List)bidRequest.getImp()), (String)bidResponse.getCur())).toList();
    }

    private static Bid resolveMacros(Bid bid) {
        BigDecimal price = bid.getPrice();
        String priceAsString = price != null ? price.toPlainString() : "0";
        return bid.toBuilder().nurl(StringUtils.replace((String)bid.getNurl(), (String)"${AUCTION_PRICE}", (String)priceAsString)).adm(StringUtils.replace((String)bid.getAdm(), (String)"${AUCTION_PRICE}", (String)priceAsString)).build();
    }

    private static BidType getMediaType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!impId.equals(imp.getId())) continue;
            if (imp.getXNative() != null) {
                return BidType.xNative;
            }
            if (imp.getVideo() != null) {
                return BidType.video;
            }
            return BidType.banner;
        }
        return BidType.banner;
    }
}

