/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.avocet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.avocet.model.AvocetBidExtension;
import org.prebid.server.bidder.avocet.model.AvocetResponseExt;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

public class AvocetBidder
implements Bidder<BidRequest> {
    private static final int API_FRAMEWORK_VPAID_1_0 = 1;
    private static final int API_FRAMEWORK_VPAID_2_0 = 2;
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AvocetBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)endpointUrl);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        return Result.of(Collections.singletonList(BidderUtil.defaultRequest((BidRequest)request, (String)this.endpointUrl, (JacksonMapper)this.mapper)), Collections.emptyList());
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        BidResponse bidResponse;
        try {
            bidResponse = this.decodeBodyToBidResponse(httpCall);
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
        ArrayList<BidderBid> bidderBids = new ArrayList<BidderBid>();
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        for (SeatBid seatBid : bidResponse.getSeatbid()) {
            for (Bid bid : seatBid.getBid()) {
                BidType bidType;
                try {
                    bidType = this.getBidType(bid);
                }
                catch (PreBidException e) {
                    errors.add(BidderError.badServerResponse((String)e.getMessage()));
                    continue;
                }
                bidderBids.add(BidderBid.of((Bid)bid, (BidType)bidType, (String)bidResponse.getCur()));
            }
        }
        return Result.of(bidderBids, errors);
    }

    private BidResponse decodeBodyToBidResponse(BidderCall<BidRequest> httpCall) {
        try {
            return (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
        }
        catch (DecodeException e) {
            throw new PreBidException(e.getMessage(), (Throwable)e);
        }
    }

    private BidType getBidType(Bid bid) {
        Integer api = bid.getApi();
        if (api != null && (api == 1 || api == 2)) {
            return BidType.video;
        }
        ObjectNode ext = bid.getExt();
        if (ext != null) {
            Integer duration;
            AvocetResponseExt responseExt = this.parseResponseExt(ext);
            AvocetBidExtension avocetExt = responseExt.getAvocet();
            Integer n = duration = avocetExt != null ? avocetExt.getDuration() : null;
            if (duration != null && duration != 0) {
                return BidType.video;
            }
        }
        return BidType.banner;
    }

    private AvocetResponseExt parseResponseExt(ObjectNode ext) {
        try {
            return (AvocetResponseExt)this.mapper.mapper().treeToValue((TreeNode)ext, AvocetResponseExt.class);
        }
        catch (JsonProcessingException e) {
            throw new PreBidException("Invalid Avocet bidder bid extension", (Throwable)e);
        }
    }
}

