/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adtelligent;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Video;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.adtelligent.proto.AdtelligentImpExt;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.EncodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.adtelligent.ExtImpAdtelligent;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.BidderUtil;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdtelligentBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAdtelligent>> ADTELLIGENT_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private final String endpointUrl;
    private final JacksonMapper mapper;
    private final MultiMap headers;

    public AdtelligentBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
        this.headers = HttpUtil.headers();
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest request) {
        Result sourceIdToImpsResult = this.mapSourceIdToImp(request.getImp());
        return this.createHttpRequests((Map)sourceIdToImpsResult.getValue(), sourceIdToImpsResult.getErrors(), request);
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return AdtelligentBidder.extractBids((BidResponse)bidResponse, (List)bidRequest.getImp());
        }
        catch (DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private Result<Map<Integer, List<Imp>>> mapSourceIdToImp(List<Imp> imps) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        HashMap<Integer, ArrayList<Imp>> sourceToImps = new HashMap<Integer, ArrayList<Imp>>();
        for (Imp imp : imps) {
            ExtImpAdtelligent extImpAdtelligent;
            try {
                this.validateImpression(imp);
                extImpAdtelligent = this.getExtImpAdtelligent(imp);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
                continue;
            }
            Imp updatedImp = this.updateImp(imp, extImpAdtelligent);
            Integer sourceId = extImpAdtelligent.getSourceId();
            List sourceIdImps = (List)sourceToImps.get(sourceId);
            if (sourceIdImps == null) {
                sourceToImps.put(sourceId, new ArrayList<Imp>(Collections.singleton(updatedImp)));
                continue;
            }
            sourceIdImps.add(updatedImp);
        }
        return Result.of(sourceToImps, errors);
    }

    private Result<List<HttpRequest<BidRequest>>> createHttpRequests(Map<Integer, List<Imp>> sourceToImps, List<BidderError> errors, BidRequest request) {
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        for (Map.Entry<Integer, List<Imp>> sourceIdToImps : sourceToImps.entrySet()) {
            byte[] bidRequestBody;
            String url = "%s?aid=%d".formatted(this.endpointUrl, sourceIdToImps.getKey());
            BidRequest bidRequest = request.toBuilder().imp(sourceIdToImps.getValue()).build();
            try {
                bidRequestBody = this.mapper.encodeToBytes((Object)bidRequest);
            }
            catch (EncodeException e) {
                errors.add(BidderError.badInput((String)("error while encoding bidRequest, err: " + e.getMessage())));
                return Result.withErrors(errors);
            }
            httpRequests.add(HttpRequest.builder().method(HttpMethod.POST).uri(url).body(bidRequestBody).headers(this.headers).payload((Object)bidRequest).build());
        }
        return Result.of(httpRequests, errors);
    }

    private ExtImpAdtelligent getExtImpAdtelligent(Imp imp) {
        try {
            return (ExtImpAdtelligent)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADTELLIGENT_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("ignoring imp id=%s, error while decoding impExt, err: %s".formatted(imp.getId(), e.getMessage()));
        }
    }

    private void validateImpression(Imp imp) {
        String impId = imp.getId();
        if (imp.getBanner() == null && imp.getVideo() == null) {
            throw new PreBidException("ignoring imp id=%s, Adtelligent supports only Video and Banner".formatted(impId));
        }
        ObjectNode impExt = imp.getExt();
        if (impExt == null || impExt.size() == 0) {
            throw new PreBidException("ignoring imp id=%s, extImpBidder is empty".formatted(impId));
        }
    }

    private Imp updateImp(Imp imp, ExtImpAdtelligent extImpAdtelligent) {
        AdtelligentImpExt adtelligentImpExt = AdtelligentImpExt.of((ExtImpAdtelligent)extImpAdtelligent);
        BigDecimal bidFloor = extImpAdtelligent.getBidFloor();
        return imp.toBuilder().bidfloor(BidderUtil.isValidPrice((BigDecimal)bidFloor) ? bidFloor : imp.getBidfloor()).ext((ObjectNode)this.mapper.mapper().valueToTree((Object)adtelligentImpExt)).build();
    }

    private static Result<List<BidderBid>> extractBids(BidResponse bidResponse, List<Imp> imps) {
        return bidResponse == null || CollectionUtils.isEmpty((Collection)bidResponse.getSeatbid()) ? Result.empty() : AdtelligentBidder.createBiddersBid((BidResponse)bidResponse, imps);
    }

    private static Result<List<BidderBid>> createBiddersBid(BidResponse bidResponse, List<Imp> imps) {
        Map idToImps = imps.stream().collect(Collectors.toMap(Imp::getId, Function.identity()));
        ArrayList bidderBids = new ArrayList();
        ArrayList errors = new ArrayList();
        bidResponse.getSeatbid().stream().filter(Objects::nonNull).map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).forEach(bid -> AdtelligentBidder.addBidOrError((Bid)bid, (Map)idToImps, (List)bidderBids, (List)errors, (String)bidResponse.getCur()));
        return Result.of(bidderBids, errors);
    }

    private static void addBidOrError(Bid bid, Map<String, Imp> idToImps, List<BidderBid> bidderBids, List<BidderError> errors, String currency) {
        String bidImpId = bid.getImpid();
        if (idToImps.containsKey(bidImpId)) {
            Video video = idToImps.get(bidImpId).getVideo();
            bidderBids.add(BidderBid.of((Bid)bid, (BidType)(video != null ? BidType.video : BidType.banner), (String)currency));
        } else {
            errors.add(BidderError.badServerResponse((String)"ignoring bid id=%s, request doesn't contain any impression with id=%s".formatted(bid.getId(), bidImpId)));
        }
    }
}

