/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adocean;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import com.iab.openrtb.response.Bid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.adocean.model.AdoceanResponseAdUnit;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.adocean.ExtImpAdocean;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdoceanBidder
implements Bidder<Void> {
    private static final TypeReference<ExtPrebid<?, ExtImpAdocean>> ADOCEAN_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String VERSION = "1.3.0";
    private static final int MAX_URI_LENGTH = 8000;
    private static final String MEASUREMENT_CODE_TEMPLATE = " <script> +function() {\nvar wu = \"%s\";\nvar su = \"%s\".replace(/\\[TIMESTAMP\\]/, Date.now());\nif (wu && !(navigator.sendBeacon && navigator.sendBeacon(wu))) { (new Image(1,1)).src = wu }\nif (su && !(navigator.sendBeacon && navigator.sendBeacon(su))) { (new Image(1,1)).src = su } }();\n</script>";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AdoceanBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<Void>>> makeHttpRequests(BidRequest request) {
        ArrayList<BidderError> errors = new ArrayList<BidderError>();
        User user = request.getUser();
        ExtUser extUser = user != null ? user.getExt() : null;
        String consentString = extUser != null ? extUser.getConsent() : "";
        ArrayList<HttpRequest> httpRequests = new ArrayList<HttpRequest>();
        for (Imp imp : request.getImp()) {
            try {
                ExtImpAdocean extImpAdocean = this.parseImpExt(imp);
                AdoceanBidder.validateImpExt((ExtImpAdocean)extImpAdocean);
                HashMap<String, String> slaveSizes = new HashMap<String, String>();
                slaveSizes.put(extImpAdocean.getSlaveId(), this.getImpSizes(imp));
                if (this.addRequestAndCheckIfDuplicates(httpRequests, extImpAdocean, imp.getId(), slaveSizes, request.getTest())) continue;
                httpRequests.add(this.createSingleRequest(request, imp, extImpAdocean, consentString, slaveSizes));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return Result.of(httpRequests, errors);
    }

    private ExtImpAdocean parseImpExt(Imp imp) {
        try {
            return (ExtImpAdocean)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADOCEAN_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Error parsing adOceanExt parameters, in imp with id : " + imp.getId());
        }
    }

    private static void validateImpExt(ExtImpAdocean impExt) {
        if (StringUtils.isEmpty((CharSequence)impExt.getEmitterPrefix())) {
            throw new PreBidException("No emitterPrefix param");
        }
    }

    private boolean addRequestAndCheckIfDuplicates(List<HttpRequest<Void>> httpRequests, ExtImpAdocean extImpAdocean, String impid, Map<String, String> slaveSizes, Integer test) {
        for (HttpRequest<Void> request : httpRequests) {
            try {
                boolean isExistingSlaveId;
                URIBuilder uriBuilder = new URIBuilder(request.getUri());
                List queryParams = uriBuilder.getQueryParams();
                String masterId = queryParams.stream().filter(param -> param.getName().equals("id")).findFirst().map(NameValuePair::getValue).orElse(null);
                if (masterId == null || !masterId.equals(extImpAdocean.getMasterId()) || (isExistingSlaveId = queryParams.stream().filter(param -> param.getName().equals("aid")).map(param -> param.getValue().split(":")[0]).anyMatch(slaveId -> slaveId.equals(extImpAdocean.getSlaveId())))) continue;
                queryParams.add(new BasicNameValuePair("aid", extImpAdocean.getSlaveId() + ":" + impid));
                List sizeValues = this.setSlaveSizesParam(slaveSizes, Objects.equals(test, 1));
                if (CollectionUtils.isNotEmpty((Collection)sizeValues)) {
                    queryParams.add(new BasicNameValuePair("aosspsizes", String.join((CharSequence)"-", sizeValues)));
                }
                uriBuilder.setParameters(queryParams);
                String url = uriBuilder.toString();
                if (url.length() >= 8000) continue;
                HttpRequest updatedRequest = HttpRequest.builder().method(HttpMethod.GET).uri(url).headers(request.getHeaders()).build();
                httpRequests.remove(request);
                httpRequests.add((HttpRequest<Void>)updatedRequest);
                return true;
            }
            catch (URISyntaxException e) {
                throw new PreBidException(e.getMessage());
            }
        }
        return false;
    }

    private String getImpSizes(Imp imp) {
        Banner banner = imp.getBanner();
        if (banner == null) {
            return "";
        }
        List format = banner.getFormat();
        if (CollectionUtils.isNotEmpty((Collection)format)) {
            ArrayList sizes = new ArrayList();
            format.forEach(singleFormat -> sizes.add("%sx%s".formatted(this.getIntOrElseZero(singleFormat.getW()), this.getIntOrElseZero(singleFormat.getH()))));
            return String.join((CharSequence)"_", sizes);
        }
        Integer w = banner.getW();
        Integer h = banner.getH();
        if (w != null && h != null) {
            return "%sx%s".formatted(w, h);
        }
        return "";
    }

    private int getIntOrElseZero(Integer number) {
        return number != null ? number : 0;
    }

    private HttpRequest<Void> createSingleRequest(BidRequest request, Imp imp, ExtImpAdocean extImpAdocean, String consentString, Map<String, String> slaveSizes) {
        return HttpRequest.builder().method(HttpMethod.GET).uri(this.buildUrl(imp.getId(), extImpAdocean, consentString, request, slaveSizes)).headers(AdoceanBidder.getHeaders((BidRequest)request)).build();
    }

    private String buildUrl(String impId, ExtImpAdocean extImpAdocean, String consentString, BidRequest bidRequest, Map<String, String> slaveSizes) {
        List sizeValues;
        Device device;
        App app;
        User user;
        URIBuilder uriBuilder;
        Integer test = bidRequest.getTest();
        String resolvedUrl = this.resolveEndpointUrl(extImpAdocean, test);
        try {
            uriBuilder = new URIBuilder(resolvedUrl);
        }
        catch (URISyntaxException e) {
            throw new PreBidException("Invalid url: %s, error: %s".formatted(resolvedUrl, e.getMessage()));
        }
        uriBuilder.addParameter("pbsrv_v", "1.3.0").addParameter("id", extImpAdocean.getMasterId()).addParameter("nc", "1").addParameter("nosecure", "1").addParameter("aid", extImpAdocean.getSlaveId() + ":" + impId);
        if (StringUtils.isNotEmpty((CharSequence)consentString)) {
            uriBuilder.addParameter("gdpr_consent", consentString);
            uriBuilder.addParameter("gdpr", "1");
        }
        if ((user = bidRequest.getUser()) != null && StringUtils.isNotEmpty((CharSequence)user.getBuyeruid())) {
            uriBuilder.addParameter("hcuserid", user.getBuyeruid());
        }
        if ((app = bidRequest.getApp()) != null) {
            uriBuilder.addParameter("app", "1");
            uriBuilder.addParameter("appname", app.getName());
            uriBuilder.addParameter("appbundle", app.getBundle());
            uriBuilder.addParameter("appdomain", app.getDomain());
        }
        if ((device = bidRequest.getDevice()) != null) {
            if (StringUtils.isNotEmpty((CharSequence)device.getIfa())) {
                uriBuilder.addParameter("ifa", device.getIfa());
            } else {
                uriBuilder.addParameter("dpidmd5", device.getDpidmd5());
            }
            uriBuilder.addParameter("devos", device.getOs());
            uriBuilder.addParameter("devosv", device.getOsv());
            uriBuilder.addParameter("devmodel", device.getModel());
            uriBuilder.addParameter("devmake", device.getMake());
        }
        if (CollectionUtils.isNotEmpty((Collection)(sizeValues = this.setSlaveSizesParam(slaveSizes, Objects.equals(test, 1))))) {
            uriBuilder.addParameter("aosspsizes", String.join((CharSequence)"-", sizeValues));
        }
        return uriBuilder.toString();
    }

    private String resolveEndpointUrl(ExtImpAdocean extImpAdocean, Integer test) {
        String url = this.endpointUrl.replace("{{Host}}", extImpAdocean.getEmitterPrefix());
        int randomizedPart = Objects.equals(test, 1) ? 10000000 : 10000000 + (int)(Math.random() * 8.9999999E7);
        return "%s/_%s/ad.json".formatted(url, randomizedPart);
    }

    private List<String> setSlaveSizesParam(Map<String, String> slaveSizes, boolean orderByKey) {
        Set<String> slaveIDs = orderByKey ? new TreeSet<String>(slaveSizes.keySet()) : slaveSizes.keySet();
        return slaveIDs.stream().filter(slaveId -> StringUtils.isNotEmpty((CharSequence)((CharSequence)slaveSizes.get(slaveId)))).map(rawSlaveID -> "%s~%s".formatted(rawSlaveID.replaceFirst("adocean", ""), slaveSizes.get(rawSlaveID))).toList();
    }

    private static MultiMap getHeaders(BidRequest request) {
        Site site;
        MultiMap headers = HttpUtil.headers();
        Device device = request.getDevice();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIpv6());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
        }
        if ((site = request.getSite()) != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.REFERER_HEADER, (CharSequence)site.getPage());
        }
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<Void> httpCall, BidRequest bidRequest) {
        List adoceanResponses;
        List params;
        try {
            params = URLEncodedUtils.parse((URI)new URI(httpCall.getRequest().getUri()), (Charset)StandardCharsets.UTF_8);
        }
        catch (URISyntaxException e) {
            return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
        }
        Map<String, String> auctionIds = params != null ? params.stream().filter(param -> param.getName().equals("aid")).map(param -> param.getValue().split(":")).collect(Collectors.toMap(name -> name[0], value -> value[1])) : null;
        try {
            adoceanResponses = this.getAdoceanResponseAdUnitList(httpCall.getResponse().getBody());
        }
        catch (PreBidException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)"Failed to decode: No content to map due to end-of-input"));
        }
        List<BidderBid> bidderBids = adoceanResponses.stream().filter(adoceanResponse -> !adoceanResponse.getError().equals("true")).filter(adoceanResponse -> StringUtils.isNotBlank((CharSequence)MapUtils.getString((Map)auctionIds, (Object)adoceanResponse.getId()))).map(adoceanResponse -> BidderBid.of((Bid)AdoceanBidder.createBid((Map)auctionIds, (AdoceanResponseAdUnit)adoceanResponse), (BidType)BidType.banner, (String)adoceanResponse.getCurrency())).toList();
        return Result.withValues(bidderBids);
    }

    private static Bid createBid(Map<String, String> auctionIds, AdoceanResponseAdUnit adoceanResponse) {
        String adm = " <script> +function() {\nvar wu = \"%s\";\nvar su = \"%s\".replace(/\\[TIMESTAMP\\]/, Date.now());\nif (wu && !(navigator.sendBeacon && navigator.sendBeacon(wu))) { (new Image(1,1)).src = wu }\nif (su && !(navigator.sendBeacon && navigator.sendBeacon(su))) { (new Image(1,1)).src = su } }();\n</script>".formatted(adoceanResponse.getWinUrl(), adoceanResponse.getStatsUrl()) + HttpUtil.decodeUrl((String)adoceanResponse.getCode());
        String bidPrice = adoceanResponse.getPrice();
        return Bid.builder().id(adoceanResponse.getId()).impid(auctionIds.get(adoceanResponse.getId())).adm(adm).price(NumberUtils.isParsable((String)bidPrice) ? new BigDecimal(bidPrice) : BigDecimal.ZERO).w(Integer.valueOf(NumberUtils.toInt((String)adoceanResponse.getWidth(), (int)0))).h(Integer.valueOf(NumberUtils.toInt((String)adoceanResponse.getHeight(), (int)0))).crid(adoceanResponse.getCrid()).build();
    }

    private List<AdoceanResponseAdUnit> getAdoceanResponseAdUnitList(String responseBody) {
        try {
            return (List)this.mapper.mapper().readValue(responseBody, (JavaType)this.mapper.mapper().getTypeFactory().constructCollectionType(List.class, AdoceanResponseAdUnit.class));
        }
        catch (IOException e) {
            throw new PreBidException(e.getMessage());
        }
    }
}

