/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adnuntius;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Regs;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.User;
import com.iab.openrtb.response.Bid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.time.Clock;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.adnuntius.model.request.AdnuntiusAdUnit;
import org.prebid.server.bidder.adnuntius.model.request.AdnuntiusMetaData;
import org.prebid.server.bidder.adnuntius.model.request.AdnuntiusRequest;
import org.prebid.server.bidder.adnuntius.model.response.AdnuntiusAd;
import org.prebid.server.bidder.adnuntius.model.response.AdnuntiusAdsUnit;
import org.prebid.server.bidder.adnuntius.model.response.AdnuntiusBid;
import org.prebid.server.bidder.adnuntius.model.response.AdnuntiusGrossBid;
import org.prebid.server.bidder.adnuntius.model.response.AdnuntiusNetBid;
import org.prebid.server.bidder.adnuntius.model.response.AdnuntiusResponse;
import org.prebid.server.bidder.adnuntius.model.util.AdsUnitWithImpId;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtRegs;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;
import org.prebid.server.proto.openrtb.ext.request.adnuntius.ExtImpAdnuntius;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;
import org.prebid.server.util.ObjectUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdnuntiusBidder
implements Bidder<AdnuntiusRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAdnuntius>> ADNUNTIUS_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final int SECONDS_IN_MINUTE = 60;
    private static final String TARGET_ID_DELIMITER = "-";
    private static final String DEFAULT_PAGE = "unknown";
    private static final String DEFAULT_NETWORK = "default";
    private static final String URL_NO_COOKIES_PARAMETER = "noCookies";
    private static final BigDecimal PRICE_MULTIPLIER = BigDecimal.valueOf(1000L);
    private final String endpointUrl;
    private final Clock clock;
    private final JacksonMapper mapper;

    public AdnuntiusBidder(String endpointUrl, Clock clock, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.clock = Objects.requireNonNull(clock);
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<AdnuntiusRequest>>> makeHttpRequests(BidRequest request) {
        HashMap<String, List> networkToAdUnits = new HashMap<String, List>();
        boolean noCookies = false;
        for (Imp imp : request.getImp()) {
            ExtImpAdnuntius extImpAdnuntius;
            try {
                AdnuntiusBidder.validateImp((Imp)imp);
                extImpAdnuntius = this.parseImpExt(imp);
            }
            catch (PreBidException e) {
                return Result.withError((BidderError)BidderError.badInput((String)e.getMessage()));
            }
            noCookies = AdnuntiusBidder.resolveIsNoCookies((ExtImpAdnuntius)extImpAdnuntius);
            String network = AdnuntiusBidder.resolveNetwork((ExtImpAdnuntius)extImpAdnuntius);
            networkToAdUnits.computeIfAbsent(network, n -> new ArrayList()).add(AdnuntiusBidder.makeAdnuntiusAdUnit((Imp)imp, (ExtImpAdnuntius)extImpAdnuntius));
        }
        return Result.withValues((List)this.createHttpRequests(networkToAdUnits, request, Boolean.valueOf(noCookies)));
    }

    private static AdnuntiusAdUnit makeAdnuntiusAdUnit(Imp imp, ExtImpAdnuntius extImpAdnuntius) {
        String auId = extImpAdnuntius.getAuId();
        return AdnuntiusAdUnit.builder().auId(auId).targetId(auId + "-" + imp.getId()).dimensions(AdnuntiusBidder.createDimensions((Imp)imp)).maxDeals(AdnuntiusBidder.resolveMaxDeals((ExtImpAdnuntius)extImpAdnuntius)).build();
    }

    private static List<List<Integer>> createDimensions(Imp imp) {
        Banner banner = imp.getBanner();
        if (CollectionUtils.isNotEmpty((Collection)banner.getFormat())) {
            ArrayList<List<Integer>> formats = new ArrayList<List<Integer>>();
            for (Format format : banner.getFormat()) {
                if (format.getW() == null || format.getH() == null) continue;
                formats.add(List.of(format.getW(), format.getH()));
            }
            return formats;
        }
        if (banner.getW() != null && banner.getH() != null) {
            return Collections.singletonList(List.of(banner.getW(), banner.getH()));
        }
        return null;
    }

    private static Integer resolveMaxDeals(ExtImpAdnuntius extImpAdnuntius) {
        if (extImpAdnuntius.getMaxDeals() != null && extImpAdnuntius.getMaxDeals() > 0) {
            return extImpAdnuntius.getMaxDeals();
        }
        return null;
    }

    private static void validateImp(Imp imp) {
        if (imp.getBanner() == null) {
            throw new PreBidException("Fail on Imp.Id=%s: Adnuntius supports only Banner".formatted(imp.getId()));
        }
    }

    private ExtImpAdnuntius parseImpExt(Imp imp) {
        try {
            return (ExtImpAdnuntius)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADNUNTIUS_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException("Unmarshalling error: " + e.getMessage());
        }
    }

    private static boolean resolveIsNoCookies(ExtImpAdnuntius extImpAdnuntius) {
        return Optional.of(extImpAdnuntius).map(ExtImpAdnuntius::getNoCookies).filter(BooleanUtils::isTrue).isPresent();
    }

    private static String resolveNetwork(ExtImpAdnuntius extImpAdnuntius) {
        return Optional.of(extImpAdnuntius).map(ExtImpAdnuntius::getNetwork).filter(xva$0 -> StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{xva$0})).orElse("default");
    }

    private List<HttpRequest<AdnuntiusRequest>> createHttpRequests(Map<String, List<AdnuntiusAdUnit>> networkToAdUnits, BidRequest request, Boolean noCookies) {
        ArrayList<HttpRequest<AdnuntiusRequest>> adnuntiusRequests = new ArrayList<HttpRequest<AdnuntiusRequest>>();
        AdnuntiusMetaData metaData = AdnuntiusBidder.createMetaData((User)request.getUser());
        String page = AdnuntiusBidder.extractPage((Site)request.getSite());
        String uri = this.createUri(request, noCookies);
        Device device = request.getDevice();
        for (List<AdnuntiusAdUnit> adUnits : networkToAdUnits.values()) {
            AdnuntiusRequest adnuntiusRequest = AdnuntiusRequest.of(adUnits, (AdnuntiusMetaData)metaData, (String)page);
            adnuntiusRequests.add((HttpRequest<AdnuntiusRequest>)this.createHttpRequest(adnuntiusRequest, uri, device));
        }
        return adnuntiusRequests;
    }

    private static AdnuntiusMetaData createMetaData(User user) {
        String userId = (String)ObjectUtil.getIfNotNull((Object)user, User::getId);
        return StringUtils.isNotBlank((CharSequence)userId) ? AdnuntiusMetaData.of((String)userId) : null;
    }

    private static String extractPage(Site site) {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)ObjectUtil.getIfNotNull((Object)site, Site::getPage)), (CharSequence)"unknown");
    }

    private String createUri(BidRequest bidRequest, Boolean noCookies) {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.endpointUrl).addParameter("format", "json").addParameter("tzo", this.getTimeZoneOffset());
            String gdpr = AdnuntiusBidder.extractGdpr((Regs)bidRequest.getRegs());
            String consent = AdnuntiusBidder.extractConsent((User)bidRequest.getUser());
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{gdpr, consent})) {
                uriBuilder.addParameter("gdpr", gdpr);
                uriBuilder.addParameter("consentString", consent);
            }
            if (noCookies.booleanValue() || AdnuntiusBidder.extractNoCookies((Device)bidRequest.getDevice()).booleanValue()) {
                uriBuilder.addParameter("noCookies", "true");
            }
            return uriBuilder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new PreBidException(e.getMessage());
        }
    }

    private String getTimeZoneOffset() {
        return String.valueOf(-OffsetDateTime.now(this.clock).getOffset().getTotalSeconds() / 60);
    }

    private static String extractGdpr(Regs regs) {
        Integer gdpr = (Integer)ObjectUtil.getIfNotNull((Object)((ExtRegs)ObjectUtil.getIfNotNull((Object)regs, Regs::getExt)), ExtRegs::getGdpr);
        return gdpr != null ? gdpr.toString() : null;
    }

    private static String extractConsent(User user) {
        return (String)ObjectUtil.getIfNotNull((Object)((ExtUser)ObjectUtil.getIfNotNull((Object)user, User::getExt)), ExtUser::getConsent);
    }

    private static Boolean extractNoCookies(Device device) {
        return Optional.ofNullable(device).map(Device::getExt).map(FlexibleExtension::getProperties).map(properties -> (JsonNode)properties.get("noCookies")).filter(JsonNode::isBoolean).map(JsonNode::asBoolean).orElse(false);
    }

    private HttpRequest<AdnuntiusRequest> createHttpRequest(AdnuntiusRequest adnuntiusRequest, String uri, Device device) {
        return HttpRequest.builder().method(HttpMethod.POST).headers(this.getHeaders(device)).uri(uri).body(this.mapper.encodeToBytes((Object)adnuntiusRequest)).payload((Object)adnuntiusRequest).build();
    }

    private MultiMap getHeaders(Device device) {
        MultiMap headers = HttpUtil.headers();
        if (device != null) {
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.X_FORWARDED_FOR_HEADER, (CharSequence)device.getIp());
            HttpUtil.addHeaderIfValueIsNotEmpty((MultiMap)headers, (CharSequence)HttpUtil.USER_AGENT_HEADER, (CharSequence)device.getUa());
        }
        return headers;
    }

    public Result<List<BidderBid>> makeBids(BidderCall<AdnuntiusRequest> httpCall, BidRequest bidRequest) {
        try {
            String body = httpCall.getResponse().getBody();
            AdnuntiusResponse adnuntiusResponse = (AdnuntiusResponse)this.mapper.decodeValue(body, AdnuntiusResponse.class);
            return Result.withValues((List)this.extractBids(bidRequest, adnuntiusResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private List<BidderBid> extractBids(BidRequest bidRequest, AdnuntiusResponse adnuntiusResponse) {
        if (adnuntiusResponse == null || CollectionUtils.isEmpty((Collection)adnuntiusResponse.getAdsUnits())) {
            return Collections.emptyList();
        }
        List adsUnits = adnuntiusResponse.getAdsUnits();
        List imps = bidRequest.getImp();
        if (adsUnits.size() > imps.size()) {
            throw new PreBidException("Impressions count is less then ads units count.");
        }
        List<AdsUnitWithImpId> validAdsUnitToImp = IntStream.range(0, adsUnits.size()).mapToObj(i -> AdsUnitWithImpId.of((AdnuntiusAdsUnit)((AdnuntiusAdsUnit)adsUnits.get(i)), (Imp)((Imp)imps.get(i)), (ExtImpAdnuntius)this.parseImpExt((Imp)imps.get(i)))).filter(adsUnitWithImpId -> AdnuntiusBidder.validateAdsUnit((AdnuntiusAdsUnit)adsUnitWithImpId.getAdsUnit())).toList();
        if (validAdsUnitToImp.isEmpty()) {
            return Collections.emptyList();
        }
        String currency = AdnuntiusBidder.extractCurrency(validAdsUnitToImp);
        Stream<BidderBid> generalBids = validAdsUnitToImp.stream().map(adsUnitWithImpId -> this.makeGeneralBid(adsUnitWithImpId, currency));
        Stream<BidderBid> dealBids = validAdsUnitToImp.stream().filter(adsUnitWithImpId -> CollectionUtils.isNotEmpty((Collection)adsUnitWithImpId.getAdsUnit().getDeals())).map(adsUnitWithImpId -> this.makeDealsBid(adsUnitWithImpId, currency)).filter(Objects::nonNull);
        return Stream.concat(generalBids, dealBids).toList();
    }

    private static boolean validateAdsUnit(AdnuntiusAdsUnit adsUnit) {
        List ads = (List)ObjectUtil.getIfNotNull((Object)adsUnit, AdnuntiusAdsUnit::getAds);
        return CollectionUtils.isNotEmpty((Collection)ads) && ads.get(0) != null;
    }

    private static String extractCurrency(List<AdsUnitWithImpId> adsUnits) {
        AdnuntiusBid bid = ((AdnuntiusAd)adsUnits.get(adsUnits.size() - 1).getAdsUnit().getAds().get(0)).getBid();
        return (String)ObjectUtil.getIfNotNull((Object)bid, AdnuntiusBid::getCurrency);
    }

    private BidderBid makeGeneralBid(AdsUnitWithImpId adsUnitWithImpId, String currency) {
        AdnuntiusAdsUnit adsUnit = adsUnitWithImpId.getAdsUnit();
        AdnuntiusAd ad = (AdnuntiusAd)adsUnit.getAds().get(0);
        Bid bid = AdnuntiusBidder.createBid((AdnuntiusAdsUnit)adsUnit, (Imp)adsUnitWithImpId.getImp(), (ExtImpAdnuntius)adsUnitWithImpId.getExtImpAdnuntius(), (AdnuntiusAd)ad);
        return BidderBid.of((Bid)bid, (BidType)BidType.banner, (String)currency);
    }

    private BidderBid makeDealsBid(AdsUnitWithImpId adsUnitWithImpId, String currency) {
        AdnuntiusAdsUnit adsUnit = adsUnitWithImpId.getAdsUnit();
        return adsUnit.getDeals().stream().map(adnuntiusAd -> AdnuntiusBidder.createBid((AdnuntiusAdsUnit)adsUnit, (Imp)adsUnitWithImpId.getImp(), (ExtImpAdnuntius)adsUnitWithImpId.getExtImpAdnuntius(), (AdnuntiusAd)adnuntiusAd)).map(bid -> BidderBid.of((Bid)bid, (BidType)BidType.banner, (String)currency)).findAny().orElse(null);
    }

    private static Bid createBid(AdnuntiusAdsUnit adsUnit, Imp imp, ExtImpAdnuntius extImpAdnuntius, AdnuntiusAd ad) {
        String adId = ad.getAdId();
        return Bid.builder().id(adId).impid(imp.getId()).w(AdnuntiusBidder.parseMeasure((String)ad.getCreativeWidth())).h(AdnuntiusBidder.parseMeasure((String)ad.getCreativeHeight())).adid(adId).cid(ad.getLineItemId()).crid(ad.getCreativeId()).price(AdnuntiusBidder.resolvePrice((AdnuntiusAd)ad, (String)extImpAdnuntius.getBidType())).dealid(ad.getDealId()).adm(adsUnit.getHtml()).adomain(AdnuntiusBidder.extractDomain((Map)ad.getDestinationUrls())).build();
    }

    private static Integer parseMeasure(String measure) {
        try {
            return Integer.valueOf(measure);
        }
        catch (NumberFormatException e) {
            throw new PreBidException("Value of measure: %s can not be parsed.".formatted(measure));
        }
    }

    private static BigDecimal resolvePrice(AdnuntiusAd ad, String bidType) {
        BigDecimal amount = null;
        if (StringUtils.isEmpty((CharSequence)bidType)) {
            amount = (BigDecimal)ObjectUtil.getIfNotNull((Object)ad.getBid(), AdnuntiusBid::getAmount);
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)bidType, (CharSequence)"net")) {
            amount = (BigDecimal)ObjectUtil.getIfNotNull((Object)ad.getAdnuntiusNetBid(), AdnuntiusNetBid::getAmount);
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)bidType, (CharSequence)"gross")) {
            amount = (BigDecimal)ObjectUtil.getIfNotNull((Object)ad.getAdnuntiusGrossBid(), AdnuntiusGrossBid::getAmount);
        }
        return amount != null ? amount.multiply(PRICE_MULTIPLIER) : BigDecimal.ZERO;
    }

    private static List<String> extractDomain(Map<String, String> destinationUrls) {
        return destinationUrls == null ? Collections.emptyList() : destinationUrls.values().stream().filter(Objects::nonNull).map(url -> url.split("/")).filter(splintedUrl -> ((String[])splintedUrl).length >= 2).map(splintedUrl -> splintedUrl[2].replaceAll("www\\.", "")).toList();
    }
}

