/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder.adkerneladn;

import com.fasterxml.jackson.core.type.TypeReference;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Banner;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Format;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.response.Bid;
import com.iab.openrtb.response.BidResponse;
import com.iab.openrtb.response.SeatBid;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.prebid.server.bidder.Bidder;
import org.prebid.server.bidder.model.BidderBid;
import org.prebid.server.bidder.model.BidderCall;
import org.prebid.server.bidder.model.BidderError;
import org.prebid.server.bidder.model.HttpRequest;
import org.prebid.server.bidder.model.Result;
import org.prebid.server.exception.PreBidException;
import org.prebid.server.json.DecodeException;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.ExtPrebid;
import org.prebid.server.proto.openrtb.ext.request.adkerneladn.ExtImpAdkernelAdn;
import org.prebid.server.proto.openrtb.ext.response.BidType;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdkernelAdnBidder
implements Bidder<BidRequest> {
    private static final TypeReference<ExtPrebid<?, ExtImpAdkernelAdn>> ADKERNELADN_EXT_TYPE_REFERENCE = new /* Unavailable Anonymous Inner Class!! */;
    private static final String DEFAULT_DOMAIN = "tag.adkernel.com";
    private static final String URL_PUBLISHER_ID_MACRO = "{{PublisherID}}";
    private final String endpointUrl;
    private final JacksonMapper mapper;

    public AdkernelAdnBidder(String endpointUrl, JacksonMapper mapper) {
        this.endpointUrl = HttpUtil.validateUrl((String)Objects.requireNonNull(endpointUrl));
        this.mapper = Objects.requireNonNull(mapper);
    }

    public Result<List<HttpRequest<BidRequest>>> makeHttpRequests(BidRequest bidRequest) {
        ArrayList errors;
        List validImps = bidRequest.getImp();
        Map impWithExts = this.getAndValidateImpExt(validImps, errors = new ArrayList());
        Map pubToImps = AdkernelAdnBidder.dispatchImpressions((Map)impWithExts, errors);
        if (MapUtils.isEmpty((Map)pubToImps)) {
            return Result.withErrors(errors);
        }
        return Result.of((Object)this.buildAdapterRequests(bidRequest, pubToImps), errors);
    }

    private Map<Imp, ExtImpAdkernelAdn> getAndValidateImpExt(List<Imp> imps, List<BidderError> errors) {
        HashMap<Imp, ExtImpAdkernelAdn> validImpsWithExts = new HashMap<Imp, ExtImpAdkernelAdn>();
        for (Imp imp : imps) {
            try {
                AdkernelAdnBidder.validateImp((Imp)imp);
                validImpsWithExts.put(imp, this.parseAndValidateAdkernelAdnExt(imp));
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
            }
        }
        return validImpsWithExts;
    }

    private static void validateImp(Imp imp) {
        if (imp.getBanner() == null && imp.getVideo() == null) {
            throw new PreBidException("Invalid imp with id=%s. Expected imp.banner or imp.video".formatted(imp.getId()));
        }
    }

    private ExtImpAdkernelAdn parseAndValidateAdkernelAdnExt(Imp imp) {
        ExtImpAdkernelAdn adkernelAdnExt;
        try {
            adkernelAdnExt = (ExtImpAdkernelAdn)((ExtPrebid)this.mapper.mapper().convertValue((Object)imp.getExt(), ADKERNELADN_EXT_TYPE_REFERENCE)).getBidder();
        }
        catch (IllegalArgumentException e) {
            throw new PreBidException(e.getMessage(), (Throwable)e);
        }
        if (adkernelAdnExt.getPubId() == null || adkernelAdnExt.getPubId() < 1) {
            throw new PreBidException("Invalid pubId value. Ignoring imp id=" + imp.getId());
        }
        return adkernelAdnExt;
    }

    private static Map<ExtImpAdkernelAdn, List<Imp>> dispatchImpressions(Map<Imp, ExtImpAdkernelAdn> impsWithExts, List<BidderError> errors) {
        HashMap<ExtImpAdkernelAdn, List<Imp>> result = new HashMap<ExtImpAdkernelAdn, List<Imp>>();
        for (Imp key : impsWithExts.keySet()) {
            Imp imp;
            try {
                imp = AdkernelAdnBidder.compatImpression((Imp)key);
            }
            catch (PreBidException e) {
                errors.add(BidderError.badInput((String)e.getMessage()));
                continue;
            }
            ExtImpAdkernelAdn impExt = impsWithExts.get(key);
            result.putIfAbsent(impExt, new ArrayList());
            ((List)result.get(impExt)).add(imp);
        }
        return result;
    }

    private static Imp compatImpression(Imp imp) {
        Imp.ImpBuilder impBuilder = imp.toBuilder();
        impBuilder.ext(null);
        Banner banner = imp.getBanner();
        if (banner != null) {
            AdkernelAdnBidder.compatBannerImpression((Imp.ImpBuilder)impBuilder, (Banner)banner);
        }
        return impBuilder.audio(null).xNative(null).build();
    }

    private static void compatBannerImpression(Imp.ImpBuilder impBuilder, Banner compatBanner) {
        if (compatBanner.getW() == null && compatBanner.getH() == null) {
            List compatBannerFormat = compatBanner.getFormat();
            if (CollectionUtils.isEmpty((Collection)compatBannerFormat)) {
                throw new PreBidException("Expected at least one banner.format entry or explicit w/h");
            }
            Format format = (Format)compatBannerFormat.get(0);
            Banner.BannerBuilder bannerBuilder = compatBanner.toBuilder();
            if (compatBannerFormat.size() > 1) {
                bannerBuilder.format(compatBannerFormat.subList(1, compatBannerFormat.size()));
            } else {
                bannerBuilder.format(Collections.emptyList());
            }
            bannerBuilder.w(format.getW()).h(format.getH());
            impBuilder.banner(bannerBuilder.build());
        }
        impBuilder.video(null);
    }

    private List<HttpRequest<BidRequest>> buildAdapterRequests(BidRequest preBidRequest, Map<ExtImpAdkernelAdn, List<Imp>> pubToImps) {
        ArrayList<HttpRequest<BidRequest>> result = new ArrayList<HttpRequest<BidRequest>>();
        for (Map.Entry<ExtImpAdkernelAdn, List<Imp>> entry : pubToImps.entrySet()) {
            result.add((HttpRequest<BidRequest>)this.createRequest(entry.getKey(), entry.getValue(), preBidRequest));
        }
        return result;
    }

    private HttpRequest<BidRequest> createRequest(ExtImpAdkernelAdn extImp, List<Imp> imps, BidRequest preBidRequest) {
        BidRequest outgoingRequest = AdkernelAdnBidder.createBidRequest((BidRequest)preBidRequest, imps);
        return HttpRequest.builder().method(HttpMethod.POST).uri(this.buildEndpoint(extImp)).body(this.mapper.encodeToBytes((Object)outgoingRequest)).headers(AdkernelAdnBidder.headers()).payload((Object)outgoingRequest).build();
    }

    private static BidRequest createBidRequest(BidRequest preBidRequest, List<Imp> imps) {
        App app;
        BidRequest.BidRequestBuilder bidRequestBuilder = preBidRequest.toBuilder().imp(imps);
        Site site = preBidRequest.getSite();
        if (site != null) {
            bidRequestBuilder.site(site.toBuilder().publisher(null).domain("").build());
        }
        if ((app = preBidRequest.getApp()) != null) {
            bidRequestBuilder.app(app.toBuilder().publisher(null).build());
        }
        return bidRequestBuilder.build();
    }

    private String buildEndpoint(ExtImpAdkernelAdn impExt) {
        return this.endpointUrl.replace("{{PublisherID}}", impExt.getPubId().toString());
    }

    private static MultiMap headers() {
        return HttpUtil.headers().add(HttpUtil.X_OPENRTB_VERSION_HEADER, (CharSequence)"2.5");
    }

    public Result<List<BidderBid>> makeBids(BidderCall<BidRequest> httpCall, BidRequest bidRequest) {
        try {
            BidResponse bidResponse = (BidResponse)this.mapper.decodeValue(httpCall.getResponse().getBody(), BidResponse.class);
            return Result.withValues((List)AdkernelAdnBidder.extractBids((BidRequest)((BidRequest)httpCall.getRequest().getPayload()), (BidResponse)bidResponse));
        }
        catch (PreBidException | DecodeException e) {
            return Result.withError((BidderError)BidderError.badServerResponse((String)e.getMessage()));
        }
    }

    private static List<BidderBid> extractBids(BidRequest bidRequest, BidResponse bidResponse) {
        if (bidResponse == null || bidResponse.getSeatbid() == null) {
            return Collections.emptyList();
        }
        if (bidResponse.getSeatbid().size() != 1) {
            throw new PreBidException("Invalid SeatBids count: " + bidResponse.getSeatbid().size());
        }
        return AdkernelAdnBidder.bidsFromResponse((BidRequest)bidRequest, (BidResponse)bidResponse);
    }

    private static List<BidderBid> bidsFromResponse(BidRequest bidRequest, BidResponse bidResponse) {
        return bidResponse.getSeatbid().stream().map(SeatBid::getBid).filter(Objects::nonNull).flatMap(Collection::stream).filter(Objects::nonNull).map(bid -> BidderBid.of((Bid)bid, (BidType)AdkernelAdnBidder.getType((String)bid.getImpid(), (List)bidRequest.getImp()), (String)bidResponse.getCur())).toList();
    }

    private static BidType getType(String impId, List<Imp> imps) {
        for (Imp imp : imps) {
            if (!imp.getId().equals(impId) || imp.getBanner() == null) continue;
            return BidType.banner;
        }
        return BidType.video;
    }
}

