/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.bidder;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.prebid.server.bidder.UsersyncFormat;
import org.prebid.server.bidder.UsersyncMethod;
import org.prebid.server.bidder.UsersyncMethodType;
import org.prebid.server.bidder.UsersyncUtil;
import org.prebid.server.privacy.model.Privacy;
import org.prebid.server.proto.response.UsersyncInfo;
import org.prebid.server.util.HttpUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class UsersyncInfoBuilder {
    private String usersyncUrl;
    private String redirectUrl;
    private UsersyncMethodType type;
    private Boolean supportCORS;

    public static UsersyncInfoBuilder from(UsersyncMethod usersyncMethod) {
        UsersyncInfoBuilder usersyncInfoBuilder = new UsersyncInfoBuilder();
        usersyncInfoBuilder.usersyncUrl = StringUtils.defaultString((String)usersyncMethod.getUsersyncUrl());
        usersyncInfoBuilder.redirectUrl = UsersyncUtil.enrichUrlWithFormat((String)StringUtils.stripToEmpty((String)usersyncMethod.getRedirectUrl()), (UsersyncFormat)UsersyncUtil.resolveFormat((UsersyncMethod)usersyncMethod));
        usersyncInfoBuilder.type = usersyncMethod.getType();
        usersyncInfoBuilder.supportCORS = usersyncMethod.isSupportCORS();
        return usersyncInfoBuilder;
    }

    public UsersyncInfoBuilder usersyncUrl(String usersyncUrl) {
        this.usersyncUrl = StringUtils.defaultString((String)usersyncUrl);
        return this;
    }

    public UsersyncInfoBuilder redirectUrl(String redirectUrl) {
        this.redirectUrl = StringUtils.defaultString((String)redirectUrl);
        return this;
    }

    public UsersyncInfoBuilder privacy(Privacy privacy) {
        String gdpr = StringUtils.defaultString((String)privacy.getGdpr());
        String consent = StringUtils.defaultString((String)privacy.getConsentString());
        String ccpa = StringUtils.defaultString((String)privacy.getCcpa().getUsPrivacy());
        String gpp = StringUtils.defaultString((String)privacy.getGpp());
        String gppSid = UsersyncInfoBuilder.toString((List)privacy.getGppSid());
        this.redirectUrl = UsersyncInfoBuilder.updateUrlWithPrivacy((String)this.redirectUrl, (String)gdpr, (String)consent, (String)ccpa, (String)gpp, (String)gppSid);
        String encodedGdpr = HttpUtil.encodeUrl((String)gdpr);
        String encodedConsent = HttpUtil.encodeUrl((String)consent);
        String encodedUsPrivacy = HttpUtil.encodeUrl((String)ccpa);
        String encodedGpp = HttpUtil.encodeUrl((String)gpp);
        String endodedGppSid = HttpUtil.encodeUrl((String)gppSid);
        this.usersyncUrl = UsersyncInfoBuilder.updateUrlWithPrivacy((String)this.usersyncUrl, (String)encodedGdpr, (String)encodedConsent, (String)encodedUsPrivacy, (String)encodedGpp, (String)endodedGppSid);
        return this;
    }

    private static String toString(List<Integer> gppSid) {
        return CollectionUtils.emptyIfNull(gppSid).stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    private static String updateUrlWithPrivacy(String url, String gdpr, String gdprConsent, String usPrivacy, String gpp, String gppSid) {
        return url.replace("{{gdpr}}", gdpr).replace("{{gdpr_consent}}", gdprConsent).replace("{{us_privacy}}", usPrivacy).replace("{{gpp}}", gpp).replace("{{gpp_sid}}", gppSid);
    }

    public UsersyncInfo build() {
        String resolvedRedirectUrl = StringUtils.countMatches((CharSequence)this.redirectUrl, (char)'?') > 1 ? UsersyncInfoBuilder.resolveQueryParams((String)this.redirectUrl) : HttpUtil.encodeUrl((String)this.redirectUrl);
        String resolvedUsersyncUrl = this.usersyncUrl.replace("{{redirect_url}}", resolvedRedirectUrl);
        return UsersyncInfo.of((String)resolvedUsersyncUrl, (UsersyncMethodType)this.type, (Boolean)this.supportCORS);
    }

    private static String resolveQueryParams(String redirectUrl) {
        int queryParamsIndex = redirectUrl.lastIndexOf(63);
        String queryParams = redirectUrl.substring(queryParamsIndex);
        return HttpUtil.encodeUrl((String)redirectUrl.substring(0, queryParamsIndex)) + queryParams;
    }
}

