/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.versionconverter.down;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.iab.openrtb.request.App;
import com.iab.openrtb.request.Audio;
import com.iab.openrtb.request.BidRequest;
import com.iab.openrtb.request.Content;
import com.iab.openrtb.request.Device;
import com.iab.openrtb.request.Eid;
import com.iab.openrtb.request.Imp;
import com.iab.openrtb.request.Producer;
import com.iab.openrtb.request.Publisher;
import com.iab.openrtb.request.Regs;
import com.iab.openrtb.request.Site;
import com.iab.openrtb.request.Source;
import com.iab.openrtb.request.SupplyChain;
import com.iab.openrtb.request.User;
import com.iab.openrtb.request.Video;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.prebid.server.auction.versionconverter.BidRequestOrtbVersionConverter;
import org.prebid.server.json.JacksonMapper;
import org.prebid.server.proto.openrtb.ext.FlexibleExtension;
import org.prebid.server.proto.openrtb.ext.request.ExtRegs;
import org.prebid.server.proto.openrtb.ext.request.ExtSource;
import org.prebid.server.proto.openrtb.ext.request.ExtUser;

/*
 * Exception performing whole class analysis ignored.
 */
public class BidRequestOrtb26To25Converter
implements BidRequestOrtbVersionConverter {
    private static final String PREBID_FIELD = "prebid";
    private static final String IS_REWARDED_INVENTORY_FIELD = "is_rewarded_inventory";
    private static final Producer EMPTY_PRODUCER = Producer.builder().build();
    private static final Publisher EMPTY_PUBLISHER = Publisher.builder().build();
    private final JacksonMapper mapper;

    public BidRequestOrtb26To25Converter(JacksonMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    public BidRequest convert(BidRequest bidRequest) {
        List imps = bidRequest.getImp();
        List modifiedImps = this.modifyImps(imps);
        Site site = bidRequest.getSite();
        Site modifiedSite = BidRequestOrtb26To25Converter.modifySite((Site)site);
        App app = bidRequest.getApp();
        App modifiedApp = BidRequestOrtb26To25Converter.modifyApp((App)app);
        Device device = bidRequest.getDevice();
        Device modifiedDevice = BidRequestOrtb26To25Converter.modifyDevice((Device)device);
        User user = bidRequest.getUser();
        User modifiedUser = BidRequestOrtb26To25Converter.modifyUser((User)user);
        Source source = bidRequest.getSource();
        Source modifiedSource = BidRequestOrtb26To25Converter.modifySource((Source)source);
        Regs regs = bidRequest.getRegs();
        Regs modifiedRegs = BidRequestOrtb26To25Converter.modifyRegs((Regs)regs);
        return ObjectUtils.anyNotNull((Object[])new Object[]{modifiedImps, modifiedSite, modifiedApp, modifiedDevice, modifiedUser, bidRequest.getWlangb(), bidRequest.getCattax(), bidRequest.getDooh(), modifiedSource, modifiedRegs}) ? bidRequest.toBuilder().imp(modifiedImps != null ? modifiedImps : imps).site(modifiedSite != null ? modifiedSite : site).app(modifiedApp != null ? modifiedApp : app).device(modifiedDevice != null ? modifiedDevice : device).user(modifiedUser != null ? modifiedUser : user).wlangb(null).cattax(null).dooh(null).source(modifiedSource != null ? modifiedSource : source).regs(modifiedRegs != null ? modifiedRegs : regs).build() : bidRequest;
    }

    private List<Imp> modifyImps(List<Imp> imps) {
        List<Imp> modifiedImps = imps.stream().map(arg_0 -> this.modifyImp(arg_0)).toList();
        if (modifiedImps.stream().allMatch(Objects::isNull)) {
            return null;
        }
        return IntStream.range(0, imps.size()).mapToObj(i -> (Imp)ObjectUtils.defaultIfNull((Object)((Imp)modifiedImps.get(i)), (Object)((Imp)imps.get(i)))).toList();
    }

    private Imp modifyImp(Imp imp) {
        Video video = imp.getVideo();
        Video modifiedVideo = BidRequestOrtb26To25Converter.modifyVideo((Video)video);
        Audio audio = imp.getAudio();
        Audio modifiedAudio = BidRequestOrtb26To25Converter.modifyAudio((Audio)audio);
        ObjectNode impExt = imp.getExt();
        ObjectNode modifiedImpExt = this.modifyImpExt(impExt, imp.getRwdd());
        return ObjectUtils.anyNotNull((Object[])new Object[]{modifiedVideo, modifiedAudio, imp.getSsai(), imp.getQty(), imp.getDt(), imp.getRefresh(), modifiedImpExt}) ? imp.toBuilder().video(modifiedVideo != null ? modifiedVideo : video).audio(modifiedAudio != null ? modifiedAudio : audio).rwdd(null).ssai(null).qty(null).dt(null).refresh(null).ext(modifiedImpExt != null ? modifiedImpExt : impExt).build() : null;
    }

    private static Video modifyVideo(Video video) {
        if (video == null) {
            return null;
        }
        return ObjectUtils.anyNotNull((Object[])new Object[]{video.getMaxseq(), video.getPoddur(), video.getPodid(), video.getPodseq(), video.getRqddurs(), video.getSlotinpod(), video.getMincpmpersec(), video.getPlcmt()}) ? video.toBuilder().maxseq(null).poddur(null).podid(null).podseq(null).rqddurs(null).slotinpod(null).mincpmpersec(null).plcmt(null).build() : null;
    }

    private static Audio modifyAudio(Audio audio) {
        if (audio == null) {
            return null;
        }
        return ObjectUtils.anyNotNull((Object[])new Object[]{audio.getPoddur(), audio.getRqddurs(), audio.getPodid(), audio.getPodseq(), audio.getSlotinpod(), audio.getMincpmpersec(), audio.getMaxseq()}) ? audio.toBuilder().poddur(null).rqddurs(null).podid(null).podseq(null).slotinpod(null).mincpmpersec(null).maxseq(null).build() : null;
    }

    private ObjectNode modifyImpExt(ObjectNode impExt, Integer rewarded) {
        if (rewarded == null) {
            return null;
        }
        ObjectNode copy = Optional.ofNullable(impExt).map(ObjectNode::deepCopy).orElseGet(() -> ((ObjectMapper)this.mapper.mapper()).createObjectNode());
        JsonNode prebidNode = copy.get("prebid");
        if (prebidNode == null || !prebidNode.isObject()) {
            prebidNode = this.mapper.mapper().createObjectNode();
            copy.set("prebid", prebidNode);
        }
        ((ObjectNode)prebidNode).put("is_rewarded_inventory", rewarded);
        return copy;
    }

    private static Site modifySite(Site site) {
        if (site == null) {
            return null;
        }
        Publisher publisher = site.getPublisher();
        Publisher modifiedPublisher = BidRequestOrtb26To25Converter.modifyPublisher((Publisher)publisher);
        Content content = site.getContent();
        Content modifiedContent = BidRequestOrtb26To25Converter.modifyContent((Content)content);
        return ObjectUtils.anyNotNull((Object[])new Object[]{site.getCattax(), site.getInventorypartnerdomain(), modifiedPublisher, modifiedContent, site.getKwarray()}) ? site.toBuilder().cattax(null).inventorypartnerdomain(null).publisher(modifiedPublisher != null ? BidRequestOrtb26To25Converter.nullIfEmpty((Publisher)modifiedPublisher) : publisher).content(modifiedContent != null ? BidRequestOrtb26To25Converter.nullIfEmpty((Content)modifiedContent) : content).kwarray(null).build() : null;
    }

    private static Publisher modifyPublisher(Publisher publisher) {
        return publisher != null && publisher.getCattax() != null ? publisher.toBuilder().cattax(null).build() : null;
    }

    private static Content modifyContent(Content content) {
        if (content == null) {
            return null;
        }
        Producer producer = content.getProducer();
        Producer modifiedProducer = BidRequestOrtb26To25Converter.modifyProducer((Producer)producer);
        return ObjectUtils.anyNotNull((Object[])new Object[]{modifiedProducer, content.getCattax(), content.getKwarray(), content.getLangb(), content.getNetwork(), content.getChannel()}) ? content.toBuilder().producer(modifiedProducer != null ? BidRequestOrtb26To25Converter.nullIfEmpty((Producer)modifiedProducer) : producer).cattax(null).kwarray(null).langb(null).network(null).channel(null).build() : null;
    }

    private static Producer modifyProducer(Producer producer) {
        return producer != null && producer.getCattax() != null ? producer.toBuilder().cattax(null).build() : null;
    }

    private static Producer nullIfEmpty(Producer producer) {
        return (Producer)BidRequestOrtb26To25Converter.nullIfEmpty((Object)producer, (boolean)EMPTY_PRODUCER.equals((Object)producer));
    }

    private static Publisher nullIfEmpty(Publisher publisher) {
        return (Publisher)BidRequestOrtb26To25Converter.nullIfEmpty((Object)publisher, (boolean)EMPTY_PUBLISHER.equals((Object)publisher));
    }

    private static Content nullIfEmpty(Content content) {
        return (Content)BidRequestOrtb26To25Converter.nullIfEmpty((Object)content, (boolean)content.isEmpty());
    }

    private static <T> T nullIfEmpty(T object, boolean isEmpty) {
        return isEmpty ? null : (T)object;
    }

    private static App modifyApp(App app) {
        if (app == null) {
            return null;
        }
        Publisher publisher = app.getPublisher();
        Publisher modifiedPublisher = BidRequestOrtb26To25Converter.modifyPublisher((Publisher)publisher);
        Content content = app.getContent();
        Content modifiedContent = BidRequestOrtb26To25Converter.modifyContent((Content)content);
        return ObjectUtils.anyNotNull((Object[])new Object[]{app.getCattax(), app.getInventorypartnerdomain(), modifiedPublisher, modifiedContent, app.getKwarray()}) ? app.toBuilder().cattax(null).inventorypartnerdomain(null).publisher(modifiedPublisher != null ? BidRequestOrtb26To25Converter.nullIfEmpty((Publisher)modifiedPublisher) : publisher).content(modifiedContent != null ? BidRequestOrtb26To25Converter.nullIfEmpty((Content)modifiedContent) : content).kwarray(null).build() : null;
    }

    private static Device modifyDevice(Device device) {
        if (device == null) {
            return null;
        }
        return ObjectUtils.anyNotNull((Object[])new Object[]{device.getSua(), device.getLangb()}) ? device.toBuilder().sua(null).langb(null).build() : null;
    }

    private static User modifyUser(User user) {
        if (user == null) {
            return null;
        }
        ExtUser extUser = user.getExt();
        ExtUser modifiedExtUser = BidRequestOrtb26To25Converter.modifyUserExt((ExtUser)extUser, (String)user.getConsent(), (List)user.getEids());
        return ObjectUtils.anyNotNull((Object[])new Object[]{user.getKwarray(), modifiedExtUser}) ? user.toBuilder().kwarray(null).consent(null).eids(null).ext(modifiedExtUser != null ? modifiedExtUser : extUser).build() : null;
    }

    private static ExtUser modifyUserExt(ExtUser extUser, String consent, List<Eid> eids) {
        if (consent == null && CollectionUtils.isEmpty(eids)) {
            return null;
        }
        ExtUser modifiedExtUser = Optional.ofNullable(extUser).map(ExtUser::toBuilder).orElseGet(ExtUser::builder).consent(consent).eids(eids).build();
        BidRequestOrtb26To25Converter.copyProperties((FlexibleExtension)extUser, (FlexibleExtension)modifiedExtUser);
        return modifiedExtUser;
    }

    private static void copyProperties(FlexibleExtension source, FlexibleExtension target) {
        Optional.ofNullable(source).map(FlexibleExtension::getProperties).ifPresent(arg_0 -> ((FlexibleExtension)target).addProperties(arg_0));
    }

    private static Source modifySource(Source source) {
        if (source == null) {
            return null;
        }
        SupplyChain supplyChain = source.getSchain();
        if (supplyChain == null) {
            return null;
        }
        ExtSource extSource = ExtSource.of((SupplyChain)supplyChain);
        BidRequestOrtb26To25Converter.copyProperties((FlexibleExtension)source.getExt(), (FlexibleExtension)extSource);
        return source.toBuilder().schain(null).ext(extSource).build();
    }

    private static Regs modifyRegs(Regs regs) {
        if (regs == null) {
            return null;
        }
        Integer gdpr = regs.getGdpr();
        String usPrivacy = regs.getUsPrivacy();
        String gpp = regs.getGpp();
        List gppSid = regs.getGppSid();
        if (gdpr == null && usPrivacy == null && gpp == null && gppSid == null) {
            return null;
        }
        ExtRegs originalExtRegs = regs.getExt();
        String gpc = originalExtRegs != null ? originalExtRegs.getGpc() : null;
        ExtRegs extRegs = ExtRegs.of((Integer)gdpr, (String)usPrivacy, (String)gpc);
        BidRequestOrtb26To25Converter.copyProperties((FlexibleExtension)originalExtRegs, (FlexibleExtension)extRegs);
        return regs.toBuilder().gdpr(null).usPrivacy(null).gpp(null).gppSid(null).ext(extRegs).build();
    }
}

