/*
 * Decompiled with CFR 0.152.
 */
package org.prebid.server.auction.model;

import com.fasterxml.jackson.annotation.JsonValue;
import org.prebid.server.auction.model.BidRejectionReason;
import org.prebid.server.bidder.model.BidderError;

public enum BidRejectionReason {
    NO_BID(0),
    TIMED_OUT(101),
    REJECTED_BY_HOOK(200),
    REJECTED_BY_PRIVACY(202),
    REJECTED_BY_MEDIA_TYPE(204),
    REJECTED_DUE_TO_PRICE_FLOOR(301),
    FAILED_TO_REQUEST_BIDS(100),
    OTHER_ERROR(100);

    public final int code;

    private BidRejectionReason(int code) {
        this.code = code;
    }

    @JsonValue
    private int getValue() {
        return this.code;
    }

    public static BidRejectionReason fromBidderError(BidderError error) {
        return switch (1.$SwitchMap$org$prebid$server$bidder$model$BidderError$Type[error.getType().ordinal()]) {
            case 1 -> TIMED_OUT;
            case 2 -> REJECTED_DUE_TO_PRICE_FLOOR;
            default -> OTHER_ERROR;
        };
    }
}

